/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.importWizard;

import com.intellij.application.options.CodeStyle;
import com.intellij.icons.AllIcons;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectMacrosUtil;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.roots.impl.storage.ClasspathStorage;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.EclipseBundle;
import org.jetbrains.idea.eclipse.EclipseProjectFinder;
import org.jetbrains.idea.eclipse.conversion.EclipseClasspathReader;
import org.jetbrains.idea.eclipse.conversion.EclipseUserLibrariesHelper;
import org.jetbrains.idea.eclipse.importWizard.EclipseNatureImporter;
import org.jetbrains.idea.eclipse.importWizard.EclipseProjectWizardContext;
import org.jetbrains.idea.eclipse.importWizard.Options;
import org.jetbrains.idea.eclipse.importer.EclipseProjectCodeStyleData;

public final class EclipseImportBuilder
extends ProjectImportBuilder<String>
implements EclipseProjectWizardContext {
    private static final Logger LOG = Logger.getInstance(EclipseImportBuilder.class);
    private Parameters parameters;

    @NotNull
    public String getName() {
        String string = EclipseBundle.message("eclipse.name", new Object[0]);
        if (string == null) {
            EclipseImportBuilder.$$$reportNull$$$0(0);
        }
        return string;
    }

    public Icon getIcon() {
        return AllIcons.Providers.Eclipse;
    }

    @Override
    @Nullable
    public String getRootDirectory() {
        return this.getParameters().root;
    }

    @Override
    public boolean setRootDirectory(final @NotNull String path) {
        if (path == null) {
            EclipseImportBuilder.$$$reportNull$$$0(1);
        }
        ProgressManager.getInstance().run((Task)new Task.Modal(EclipseImportBuilder.getCurrentProject(), EclipseBundle.message("eclipse.import.scanning", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                ArrayList<String> roots = new ArrayList<String>();
                EclipseProjectFinder.findModuleRoots(roots, (String)path, path12 -> {
                    ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                    if (progressIndicator != null) {
                        if (progressIndicator.isCanceled()) {
                            return false;
                        }
                        progressIndicator.setText2(path12);
                    }
                    return true;
                });
                roots.sort((path1, path2) -> {
                    String projectName1 = EclipseProjectFinder.findProjectName((String)path1);
                    String projectName2 = EclipseProjectFinder.findProjectName((String)path2);
                    return projectName1 != null && projectName2 != null ? projectName1.compareToIgnoreCase(projectName2) : 0;
                });
                EclipseImportBuilder.this.getParameters().workspace = roots;
                EclipseImportBuilder.this.getParameters().root = path;
            }

            public void onCancel() {
                EclipseImportBuilder.this.getParameters().workspace = null;
                EclipseImportBuilder.this.getParameters().root = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/eclipse/importWizard/EclipseImportBuilder$1", "run"));
            }
        });
        this.setFileToImport(path);
        return this.getParameters().workspace != null;
    }

    public List<String> getList() {
        return this.getParameters().workspace;
    }

    public boolean isMarked(String element) {
        if (this.getParameters().projectsToConvert != null) {
            return this.getParameters().projectsToConvert.contains(element);
        }
        return !this.getParameters().existingModuleNames.contains(EclipseProjectFinder.findProjectName((String)element));
    }

    public void setList(List<String> list) {
        this.getParameters().projectsToConvert = list;
    }

    public boolean isOpenProjectSettingsAfter() {
        return this.getParameters().openModuleSettings;
    }

    public void setOpenProjectSettingsAfter(boolean on) {
        this.getParameters().openModuleSettings = on;
    }

    public void cleanup() {
        super.cleanup();
        this.parameters = null;
    }

    public boolean validate(@Nullable Project currentProject, @NotNull Project project) {
        if (project == null) {
            EclipseImportBuilder.$$$reportNull$$$0(2);
        }
        Ref refEx = new Ref();
        HashSet variables = new HashSet();
        HashMap naturesNames = new HashMap();
        List<String> projectsToConvert = this.getParameters().projectsToConvert;
        boolean oneProjectToConvert = projectsToConvert.size() == 1;
        String separator = oneProjectToConvert ? "<br>" : ", ";
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            try {
                for (String path : projectsToConvert) {
                    File classPathFile = new File(path, ".classpath");
                    if (classPathFile.exists()) {
                        EclipseClasspathReader.collectVariables(variables, JDOMUtil.load((File)classPathFile), path);
                    }
                    EclipseImportBuilder.collectUnknownNatures(path, naturesNames, separator);
                }
            }
            catch (IOException | JDOMException e) {
                refEx.set((Object)e);
            }
        }, EclipseBundle.message("eclipse.import.converting", new Object[0]), false, null);
        if (!refEx.isNull()) {
            Messages.showErrorDialog((Project)project, (String)((Exception)refEx.get()).getMessage(), (String)this.getTitle());
            return false;
        }
        if (!ProjectMacrosUtil.checkNonIgnoredMacros((Project)project, variables)) {
            return false;
        }
        if (!naturesNames.isEmpty()) {
            String title = EclipseBundle.message("notification.title.unknown.natures.detected", new Object[0]);
            String naturesByProject = oneProjectToConvert ? (String)naturesNames.values().iterator().next() : StringUtil.join(naturesNames.keySet(), projectPath -> projectPath + "(" + (String)naturesNames.get(projectPath) + ")", (String)"<br>");
            Notifications.Bus.notify((Notification)new Notification("Unknown Natures Detected", title, EclipseBundle.message("notification.content.imported.projects.contain.unknown.natures", naturesByProject), NotificationType.WARNING));
        }
        return true;
    }

    public List<Module> commit(Project project, ModifiableModuleModel model, ModulesProvider modulesProvider, ModifiableArtifactModel artifactModel) {
        TreeSet<@NlsSafe String> unknownLibraries = new TreeSet<String>();
        TreeSet<String> unknownJdks = new TreeSet<String>();
        HashSet<String> refsToModules = new HashSet<String>();
        ArrayList<Module> result = new ArrayList<Module>();
        HashMap<Module, Set<String>> module2NatureNames = new HashMap<Module, Set<String>>();
        try {
            int resultCode;
            ModifiableModuleModel moduleModel = model != null ? model : ModuleManager.getInstance((Project)project).getModifiableModel();
            ModifiableRootModel[] rootModels = new ModifiableRootModel[this.getParameters().projectsToConvert.size()];
            HashSet<File> files = new HashSet<File>();
            HashSet<String> moduleNames = new HashSet<String>(this.getParameters().projectsToConvert.size());
            for (String path : this.getParameters().projectsToConvert) {
                File emlFile;
                Object modulesDirectory = this.getParameters().converterOptions.commonModulesDirectory;
                if (modulesDirectory == null) {
                    modulesDirectory = path;
                }
                String moduleName = EclipseProjectFinder.findProjectName((String)path);
                moduleNames.add(moduleName);
                File imlFile = new File((String)modulesDirectory + File.separator + moduleName + ".iml");
                if (imlFile.isFile()) {
                    files.add(imlFile);
                }
                if (!(emlFile = new File((String)modulesDirectory + File.separator + moduleName + ".eml")).isFile()) continue;
                files.add(emlFile);
            }
            if (!files.isEmpty() && (resultCode = Messages.showYesNoCancelDialog((String)EclipseBundle.message("dialog.message.0.module.files.found.1.would.you.like.to.reuse.them", ApplicationNamesInfo.getInstance().getFullProductName(), StringUtil.join(files, file -> file.getPath(), (String)"\n")), (String)EclipseBundle.message("dialog.title.module.files.found", new Object[0]), (Icon)Messages.getQuestionIcon())) != 0) {
                if (resultCode == 1) {
                    LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
                    for (File file2 : files) {
                        final VirtualFile virtualFile = localFileSystem.findFileByIoFile(file2);
                        if (virtualFile != null) {
                            ApplicationManager.getApplication().runWriteAction((ThrowableComputable)new ThrowableComputable<Void, IOException>(){

                                public Void compute() throws IOException {
                                    virtualFile.delete((Object)this);
                                    return null;
                                }
                            });
                            continue;
                        }
                        FileUtil.delete((File)file2);
                    }
                } else {
                    return result;
                }
            }
            int idx = 0;
            for (String path : this.getParameters().projectsToConvert) {
                String modulesDirectory = this.getParameters().converterOptions.commonModulesDirectory;
                if (modulesDirectory == null) {
                    modulesDirectory = path;
                }
                Module module = moduleModel.newModule(modulesDirectory + "/" + EclipseProjectFinder.findProjectName((String)path) + ".iml", StdModuleTypes.JAVA.getId());
                result.add(module);
                Set<String> natures = EclipseImportBuilder.collectNatures(path);
                if (!natures.isEmpty()) {
                    module2NatureNames.put(module, natures);
                }
                ModifiableRootModel rootModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                rootModels[idx++] = rootModel;
                File classpathFile = new File(path, ".classpath");
                EclipseClasspathReader classpathReader = new EclipseClasspathReader(path, project, this.getParameters().projectsToConvert, moduleNames);
                classpathReader.init(rootModel);
                if (classpathFile.exists()) {
                    Element classpathElement = JDOMUtil.load((File)classpathFile);
                    classpathReader.readClasspath(rootModel, unknownLibraries, unknownJdks, refsToModules, this.getParameters().converterOptions.testPattern, classpathElement);
                } else {
                    EclipseClasspathReader.setOutputUrl(rootModel, path + "/bin");
                }
                ClasspathStorage.setStorageType((ModuleRootModel)rootModel, (String)(this.getParameters().linkConverted ? "eclipse" : "default"));
                if (model == null) continue;
                ApplicationManager.getApplication().runWriteAction(() -> rootModel.commit());
            }
            if (model == null) {
                ApplicationManager.getApplication().runWriteAction(() -> ModifiableModelCommitter.multiCommit((ModifiableRootModel[])rootModels, (ModifiableModuleModel)moduleModel));
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        EclipseImportBuilder.scheduleNaturesImporting(project, module2NatureNames);
        EclipseImportBuilder.createEclipseLibrary(project, unknownLibraries, "ECLIPSE");
        refsToModules.removeAll(this.getParameters().existingModuleNames);
        for (String path : this.getParameters().projectsToConvert) {
            String projectName = EclipseProjectFinder.findProjectName((String)path);
            if (projectName == null) continue;
            refsToModules.remove(projectName);
            this.getParameters().existingModuleNames.add(projectName);
        }
        @Nls StringBuilder message = new StringBuilder();
        if (!refsToModules.isEmpty()) {
            message.append(EclipseBundle.message("unknown.modules.detected.dialog.message", StringUtil.join(refsToModules, (String)"\n")));
        }
        if (!unknownJdks.isEmpty()) {
            message.append(EclipseBundle.message("unknown.jdks.detected.message", !message.isEmpty() ? 0 : 1, StringUtil.join(unknownJdks, (String)"\n")));
        }
        if (!unknownLibraries.isEmpty()) {
            HtmlBuilder buf = new HtmlBuilder();
            buf.append(EclipseBundle.message("eclipse.import.warning.undefinded.libraries", new Object[0]));
            for (String name : unknownLibraries) {
                buf.br().append(name);
            }
            if (model == null) {
                buf.br().append((HtmlChunk)HtmlChunk.text((String)EclipseBundle.message("unknown.libraries.dialog.description", new Object[0])).bold());
                FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, false){

                    public boolean isFileSelectable(@Nullable VirtualFile file) {
                        return super.isFileSelectable(file) && Comparing.strEqual((String)file.getExtension(), (String)"userlibraries");
                    }
                };
                descriptor.setDescription(buf.wrapWithHtmlBody().toString());
                descriptor.setTitle(this.getTitle());
                VirtualFile selectedFile = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, (VirtualFile)project.getBaseDir());
                if (selectedFile != null) {
                    try {
                        EclipseUserLibrariesHelper.readProjectLibrariesContent(selectedFile, project, unknownLibraries);
                    }
                    catch (Exception e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
        }
        this.setupProjectCodeStyle(project, message);
        if (!message.isEmpty()) {
            Messages.showErrorDialog((Project)project, (String)message.toString(), (String)this.getTitle());
        }
        return result;
    }

    private void setupProjectCodeStyle(@NotNull Project project, @NotNull StringBuilder messageBuilder) {
        if (project == null) {
            EclipseImportBuilder.$$$reportNull$$$0(3);
        }
        if (messageBuilder == null) {
            EclipseImportBuilder.$$$reportNull$$$0(4);
        }
        try {
            CodeStyleSettings projectSettings;
            EclipseProjectCodeStyleData codeStyleData = this.getParameters().codeStyleData;
            if (codeStyleData != null && (projectSettings = codeStyleData.importCodeStyle()) != null) {
                CodeStyle.setMainProjectSettings((Project)project, (CodeStyleSettings)projectSettings);
            }
        }
        catch (Exception e) {
            if (!messageBuilder.isEmpty()) {
                messageBuilder.append('\n');
            }
            messageBuilder.append(EclipseBundle.message("error.while.importing.project.code.style", e.getMessage()));
        }
    }

    private static void scheduleNaturesImporting(@NotNull Project project, @NotNull Map<Module, Set<String>> module2NatureNames) {
        if (project == null) {
            EclipseImportBuilder.$$$reportNull$$$0(5);
        }
        if (module2NatureNames == null) {
            EclipseImportBuilder.$$$reportNull$$$0(6);
        }
        if (module2NatureNames.isEmpty()) {
            return;
        }
        StartupManager.getInstance((Project)project).runAfterOpened(() -> DumbService.getInstance((Project)project).smartInvokeLater(() -> {
            for (EclipseNatureImporter importer : (EclipseNatureImporter[])EclipseNatureImporter.EP_NAME.getExtensions()) {
                String importerNatureName = importer.getNatureName();
                ArrayList<Module> modulesToImport = new ArrayList<Module>();
                for (Map.Entry entry : module2NatureNames.entrySet()) {
                    Module module = (Module)entry.getKey();
                    Set natureNames = (Set)entry.getValue();
                    if (!natureNames.contains(importerNatureName)) continue;
                    modulesToImport.add(module);
                }
                if (modulesToImport.isEmpty()) continue;
                importer.doImport(project, modulesToImport);
            }
        }));
    }

    private static void createEclipseLibrary(Project project, Collection<String> libraries, String libraryName) {
        if (libraries.contains(libraryName)) {
            VirtualFile pluginsDir;
            FileChooserDescriptor fileChooserDescriptor = new FileChooserDescriptor(false, true, false, false, false, false){

                public Icon getIcon(VirtualFile file) {
                    return 4.looksLikeEclipse(file) ? 4.dressIcon((VirtualFile)file, (Icon)AllIcons.Providers.Eclipse) : super.getIcon(file);
                }

                private static boolean looksLikeEclipse(VirtualFile file) {
                    return file.findChild(".eclipseproduct") != null;
                }
            };
            fileChooserDescriptor.setTitle(EclipseBundle.message("eclipse.create.library.title", new Object[0]));
            fileChooserDescriptor.setDescription(EclipseBundle.message("eclipse.create.library.description", libraryName));
            VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)fileChooserDescriptor, (Project)project, null);
            if (file != null && (pluginsDir = file.findChild("plugins")) != null) {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    LibraryTable table = LibraryTablesRegistrar.getInstance().getLibraryTableByLevel("application", project);
                    assert (table != null);
                    LibraryTable.ModifiableModel tableModel = table.getModifiableModel();
                    Library library = tableModel.createLibrary(libraryName);
                    Library.ModifiableModel libraryModel = library.getModifiableModel();
                    libraryModel.addJarDirectory(pluginsDir, true);
                    libraryModel.commit();
                    tableModel.commit();
                });
                libraries.remove(libraryName);
            }
        }
    }

    @NotNull
    public Parameters getParameters() {
        if (this.parameters == null) {
            Project project;
            this.parameters = new Parameters();
            this.parameters.existingModuleNames = new HashSet<String>();
            if (this.isUpdate() && (project = EclipseImportBuilder.getCurrentProject()) != null) {
                for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                    this.parameters.existingModuleNames.add(module.getName());
                }
            }
        }
        Parameters parameters = this.parameters;
        if (parameters == null) {
            EclipseImportBuilder.$$$reportNull$$$0(7);
        }
        return parameters;
    }

    public static void collectUnknownNatures(String path, Map<String, String> naturesNames, String separator) {
        Set<String> natures = EclipseImportBuilder.collectNatures(path);
        natures.removeAll(EclipseNatureImporter.getDefaultNatures());
        for (EclipseNatureImporter importer : (EclipseNatureImporter[])EclipseNatureImporter.EP_NAME.getExtensions()) {
            natures.remove(importer.getNatureName());
        }
        if (!natures.isEmpty()) {
            naturesNames.put(path, StringUtil.join(natures, (String)separator));
        }
    }

    @NotNull
    public static Set<String> collectNatures(@NotNull String path) {
        if (path == null) {
            EclipseImportBuilder.$$$reportNull$$$0(8);
        }
        HashSet<String> naturesNames = new HashSet<String>();
        try {
            Element natures = JDOMUtil.load((File)new File(path, ".project")).getChild("natures");
            if (natures != null) {
                for (Element nature : natures.getChildren("nature")) {
                    String natureName = nature.getText();
                    if (StringUtil.isEmptyOrSpaces((String)natureName)) continue;
                    naturesNames.add(natureName);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashSet<String> hashSet = naturesNames;
        if (hashSet == null) {
            EclipseImportBuilder.$$$reportNull$$$0(9);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/eclipse/importWizard/EclipseImportBuilder";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBuilder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module2NatureNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/eclipse/importWizard/EclipseImportBuilder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "collectNatures";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setRootDirectory";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setupProjectCodeStyle";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "scheduleNaturesImporting";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectNatures";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 8 -> new IllegalArgumentException(string);
        };
    }

    public static class Parameters {
        public String root;
        public List<String> workspace;
        public boolean linkConverted;
        public List<String> projectsToConvert = new ArrayList<String>();
        public boolean openModuleSettings;
        public Options converterOptions = new Options();
        public Set<String> existingModuleNames;
        @Nullable
        public EclipseProjectCodeStyleData codeStyleData;
    }
}

