/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.util;

import com.intellij.collaboration.messages.CollaborationToolsBundle;
import com.intellij.util.UriUtilKt;
import com.intellij.util.io.URLUtil;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0005J\u0016\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u0013\u0010\r\u001a\u00070\u0005\u00a2\u0006\u0002\b\u000e2\u0006\u0010\u0006\u001a\u00020\u000bJ\u0016\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/collaboration/util/URIUtil;", "", "<init>", "()V", "normalizeAndValidateHttpUri", "", "uri", "isValidHttpUri", "", "equalWithoutSchema", "first", "Ljava/net/URI;", "second", "toStringWithoutScheme", "Lcom/intellij/openapi/util/NlsSafe;", "createUriWithCustomScheme", "scheme", "removeProtocolPrefix", "url", "intellij.platform.collaborationTools"})
@SourceDebugExtension(value={"SMAP\nURIUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 URIUtil.kt\ncom/intellij/collaboration/util/URIUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,68:1\n1#2:69\n*E\n"})
public final class URIUtil {
    @NotNull
    public static final URIUtil INSTANCE = new URIUtil();

    private URIUtil() {
    }

    @NotNull
    public final String normalizeAndValidateHttpUri(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String string = URLUtil.addSchemaIfMissing((String)uri);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"addSchemaIfMissing(...)");
        String normalized = StringsKt.removeSuffix((String)string, (CharSequence)"/");
        if (!StringsKt.startsWith$default((String)normalized, (String)"http", (boolean)false, (int)2, null)) {
            boolean bl = false;
            String string2 = CollaborationToolsBundle.message("login.server.invalid", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            String string3 = string2;
            throw new IllegalArgumentException(string3.toString());
        }
        URI.create(normalized);
        return normalized;
    }

    public final boolean isValidHttpUri(@NotNull String uri) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        if (StringsKt.isBlank((CharSequence)uri)) {
            return false;
        }
        try {
            this.normalizeAndValidateHttpUri(uri);
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }

    public final boolean equalWithoutSchema(@NotNull URI first, @NotNull URI second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        String stubScheme = "stub";
        return Intrinsics.areEqual((Object)UriUtilKt.withScheme((URI)first, (String)stubScheme), (Object)UriUtilKt.withScheme((URI)second, (String)stubScheme));
    }

    @NotNull
    public final String toStringWithoutScheme(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String schemeText = uri.getScheme() + "://";
        String string = uri.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return StringsKt.removePrefix((String)string, (CharSequence)schemeText);
    }

    @NotNull
    public final URI createUriWithCustomScheme(@NotNull String uri, @NotNull String scheme) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        String prefix = scheme + "://";
        if (StringsKt.startsWith$default((String)uri, (String)prefix, (boolean)false, (int)2, null)) {
            return new URI(uri);
        }
        return new URI(prefix + this.removeProtocolPrefix(uri));
    }

    private final String removeProtocolPrefix(String url) {
        String string;
        int index = StringsKt.indexOf$default((CharSequence)url, (String)"://", (int)0, (boolean)false, (int)6, null);
        if (index != -1) {
            String string2 = url.substring(index + 3);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = url;
        }
        return string;
    }
}

