/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.refactoring.copy;

import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesDialog;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.idea.base.util.FqNameUtils;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.k2.refactoring.copy.CopyKotlinDeclarationsHandler$doRefactoringOnElement$lambda$18$lambda$17$;
import org.jetbrains.kotlin.idea.k2.refactoring.move.descriptor.K2MoveTargetDescriptor;
import org.jetbrains.kotlin.idea.k2.refactoring.move.processor.conflict.ModuleDependencyConflictKt;
import org.jetbrains.kotlin.idea.k2.refactoring.move.processor.conflict.VisibilityConflictKt;
import org.jetbrains.kotlin.idea.k2.refactoring.move.processor.usages.K2MoveRenameUsageInfo;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.copy.AbstractCopyKotlinDeclarationsHandler;
import org.jetbrains.kotlin.idea.refactoring.copy.AbstractCopyKotlinDeclarationsHandlerKt;
import org.jetbrains.kotlin.idea.refactoring.copy.CopyKotlinDeclarationDialog;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0003*+,B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0002J\f\u0010\u000e\u001a\u00020\u000f*\u00020\tH\u0002J'\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\tH\u0002\u00a2\u0006\u0002\u0010\u0017J'\u0010\u0018\u001a\u00020\u00122\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u00142\b\u0010\u001b\u001a\u0004\u0018\u00010\tH\u0016\u00a2\u0006\u0002\u0010\u001cJ\u0018\u0010\u001d\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u000bH\u0002J(\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010$\u001a\u00020 2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010%\u001a\u00020\u0005H\u0002J$\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00070'2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u000bH\u0002J\u0010\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u001aH\u0016\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/copy/CopyKotlinDeclarationsHandler;", "Lorg/jetbrains/kotlin/idea/refactoring/copy/AbstractCopyKotlinDeclarationsHandler;", "<init>", "()V", "createFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "targetFileName", "", "targetDirectory", "Lcom/intellij/psi/PsiDirectory;", "getTargetData", "Lorg/jetbrains/kotlin/idea/k2/refactoring/copy/CopyKotlinDeclarationsHandler$TargetData;", "sourceData", "Lorg/jetbrains/kotlin/idea/k2/refactoring/copy/CopyKotlinDeclarationsHandler$SourceData;", "toDirectory", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$Directory;", "Lcom/intellij/refactoring/MoveDestination;", "doCopyFiles", "", "filesToCopy", "", "Lcom/intellij/psi/PsiFileSystemItem;", "initialTargetDirectory", "([Lcom/intellij/psi/PsiFileSystemItem;Lcom/intellij/psi/PsiDirectory;)V", "doCopy", "elements", "Lcom/intellij/psi/PsiElement;", "defaultTargetDirectory", "([Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiDirectory;)V", "doRefactor", "targetData", "doRefactoringOnFile", "Lorg/jetbrains/kotlin/idea/k2/refactoring/copy/CopyKotlinDeclarationsHandler$RefactoringResult;", "fileToCopy", "isSingleDeclarationInFile", "", "doRefactoringOnElement", "targetFile", "collectConflicts", "Lcom/intellij/util/containers/MultiMap;", "doClone", "element", "TargetData", "SourceData", "RefactoringResult", "kotlin.refactorings.k2"})
@SourceDebugExtension(value={"SMAP\nCopyKotlinDeclarationsHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CopyKotlinDeclarationsHandler.kt\norg/jetbrains/kotlin/idea/k2/refactoring/copy/CopyKotlinDeclarationsHandler\n+ 2 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 analyzeUtils.kt\norg/jetbrains/kotlin/idea/base/analysis/api/utils/AnalyzeUtilsKt\n+ 7 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,323:1\n73#2:324\n73#2:363\n11546#3,9:325\n13472#3:334\n13473#3:336\n11555#3:337\n4135#3,11:377\n1#4:335\n1#4:392\n808#5,11:338\n808#5,11:364\n1869#5,2:375\n1869#5,2:388\n1869#5,2:390\n1563#5:393\n1634#5,3:394\n1869#5:397\n1870#5:436\n30#6,7:349\n30#6,7:356\n427#7,15:398\n347#7,2:413\n359#7:415\n446#7:416\n427#7,15:417\n347#7,2:432\n359#7:434\n446#7:435\n*S KotlinDebug\n*F\n+ 1 CopyKotlinDeclarationsHandler.kt\norg/jetbrains/kotlin/idea/k2/refactoring/copy/CopyKotlinDeclarationsHandler\n*L\n70#1:324\n305#1:363\n145#1:325,9\n145#1:334\n145#1:336\n145#1:337\n184#1:377,11\n145#1:335\n158#1:338,11\n311#1:364,11\n311#1:375,2\n184#1:388,2\n224#1:390,2\n283#1:393\n283#1:394,3\n285#1:397\n285#1:436\n166#1:349,7\n172#1:356,7\n286#1:398,15\n286#1:413,2\n286#1:415\n286#1:416\n287#1:417,15\n287#1:432,2\n287#1:434\n287#1:435\n*E\n"})
public final class CopyKotlinDeclarationsHandler
extends AbstractCopyKotlinDeclarationsHandler {
    @Override
    @NotNull
    public KtFile createFile(@NotNull String targetFileName, @NotNull PsiDirectory targetDirectory) {
        Intrinsics.checkNotNullParameter((Object)targetFileName, (String)"targetFileName");
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        return PackageUtilsKt.createKotlinFile$default(targetFileName, targetDirectory, null, 4, null);
    }

    private final TargetData getTargetData(SourceData sourceData) {
        KtNamedDeclaration singleNamedSourceElement;
        boolean $i$f$isUnitTestMode = false;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            VirtualFile virtualFile = ProjectRootsUtilKt.getSourceRoot((PsiFileSystemItem)sourceData.getInitialTargetDirectory());
            if (virtualFile == null) {
                return null;
            }
            VirtualFile targetSourceRoot = virtualFile;
            String string = AbstractCopyKotlinDeclarationsHandlerKt.getCopyNewName(sourceData.getProject());
            if (string == null) {
                KtElement ktElement = sourceData.getSingleElementToCopy();
                string = ktElement != null ? ktElement.getName() : null;
                if (string == null) {
                    String string2 = sourceData.getOriginalFile().getName();
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                }
            }
            String newName = string;
            if (sourceData.getSingleElementToCopy() != null && ((CharSequence)newName).length() == 0) {
                return null;
            }
            return new TargetData(false, newName, this.toDirectory(sourceData.getInitialTargetDirectory()), targetSourceRoot);
        }
        boolean openInEditor = false;
        String newName = null;
        K2MoveTargetDescriptor targetDirWrapper = null;
        VirtualFile targetSourceRoot = null;
        KtElement ktElement = sourceData.getSingleElementToCopy();
        KtNamedDeclaration ktNamedDeclaration = singleNamedSourceElement = ktElement instanceof KtNamedDeclaration ? (KtNamedDeclaration)ktElement : null;
        if (singleNamedSourceElement != null) {
            dialog = new CopyKotlinDeclarationDialog(singleNamedSourceElement, sourceData.getInitialTargetDirectory(), sourceData.getProject());
            dialog.setTitle(AbstractCopyKotlinDeclarationsHandlerKt.getCopyCommandName());
            if (!dialog.showAndGet()) {
                return null;
            }
            openInEditor = dialog.getOpenInEditor();
            newName = dialog.getNewName();
            MoveDestination moveDestination = dialog.getTargetDirectory();
            targetDirWrapper = moveDestination != null ? this.toDirectory(moveDestination, sourceData) : null;
            targetSourceRoot = dialog.getTargetSourceRoot();
        } else {
            KtFile[] ktFileArray = new KtFile[]{sourceData.getOriginalFile()};
            dialog = new CopyFilesOrDirectoriesDialog((PsiElement[])ktFileArray, sourceData.getInitialTargetDirectory(), sourceData.getProject(), false);
            if (!dialog.showAndGet()) {
                return null;
            }
            openInEditor = dialog.openInEditor();
            newName = dialog.getNewName();
            PsiDirectory psiDirectory = dialog.getTargetDirectory();
            targetDirWrapper = psiDirectory != null ? this.toDirectory(psiDirectory) : null;
            PsiDirectory psiDirectory2 = dialog.getTargetDirectory();
            Object object = targetSourceRoot = psiDirectory2 != null ? ProjectRootsUtilKt.getSourceRoot((PsiFileSystemItem)psiDirectory2) : null;
        }
        if (targetDirWrapper == null || newName == null) {
            return null;
        }
        if (sourceData.getSingleElementToCopy() != null && ((CharSequence)newName).length() == 0) {
            return null;
        }
        return new TargetData(openInEditor, newName, targetDirWrapper, targetSourceRoot);
    }

    private final K2MoveTargetDescriptor.Directory toDirectory(MoveDestination $this$toDirectory, SourceData sourceData) {
        String string = $this$toDirectory.getTargetPackage().getQualifiedName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getQualifiedName(...)");
        FqName fqName2 = new FqName(string);
        Object object = ActionsKt.runWriteAction(() -> CopyKotlinDeclarationsHandler.toDirectory$lambda$0($this$toDirectory, sourceData));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runWriteAction(...)");
        return new K2MoveTargetDescriptor.Directory(fqName2, (PsiDirectory)object);
    }

    private final K2MoveTargetDescriptor.Directory toDirectory(PsiDirectory $this$toDirectory) {
        return new K2MoveTargetDescriptor.Directory(PackageUtilsKt.getFqNameWithImplicitPrefixOrRoot($this$toDirectory), $this$toDirectory);
    }

    private final void doCopyFiles(PsiFileSystemItem[] filesToCopy, PsiDirectory initialTargetDirectory) {
        if (filesToCopy.length == 0) {
            return;
        }
        Project project = ((PsiFileSystemItem)ArraysKt.first((Object[])filesToCopy)).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ApplicationUtilsKt.executeCommand$default(project, AbstractCopyKotlinDeclarationsHandlerKt.getCopyCommandName(), null, () -> CopyKotlinDeclarationsHandler.doCopyFiles$lambda$1(this, filesToCopy, initialTargetDirectory), 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public void doCopy(@NotNull PsiElement[] elements, @Nullable PsiDirectory defaultTargetDirectory) {
        void contextElement$iv;
        KtElement element2;
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        if (elements.length == 0) {
            return;
        }
        if (!this.canCopyDeclarations(elements)) {
            PsiFileSystemItem[] psiFileSystemItemArray = this.getSourceFiles(elements);
            if (psiFileSystemItemArray == null) {
                return;
            }
            PsiFileSystemItem[] sourceFiles = psiFileSystemItemArray;
            this.doCopyFiles(sourceFiles, defaultTargetDirectory);
            return;
        }
        PsiElement[] $this$mapNotNull$iv = elements;
        boolean $i$f$mapNotNull = false;
        PsiElement[] psiElementArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        for (void element$iv$iv$iv : $this$forEach$iv$iv$iv) {
            KtElement it$iv$iv;
            Iterator element$iv$iv = element$iv$iv$iv;
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            if (AbstractCopyKotlinDeclarationsHandlerKt.getCopyableElement((PsiElement)it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List elementsToCopy = (List)destination$iv$iv;
        if (elementsToCopy.isEmpty()) {
            return;
        }
        KtElement singleElementToCopy = (KtElement)CollectionsKt.singleOrNull((List)elementsToCopy);
        PsiFile psiFile = ((KtElement)CollectionsKt.first((List)elementsToCopy)).getContainingFile();
        Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        KtFile originalFile = (KtFile)psiFile;
        PsiDirectory psiDirectory = defaultTargetDirectory;
        if (psiDirectory == null && (psiDirectory = originalFile.getContainingDirectory()) == null) {
            return;
        }
        PsiDirectory initialTargetDirectory = psiDirectory;
        Project project = initialTargetDirectory.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        $this$forEach$iv$iv$iv = elementsToCopy;
        KtElement ktElement = singleElementToCopy;
        Project project3 = project2;
        boolean $i$f$filterIsInstance = false;
        void var11_16 = $this$filterIsInstance$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtNamedDeclaration)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv2;
        PsiDirectory psiDirectory2 = initialTargetDirectory;
        KtFile ktFile2 = originalFile;
        List list3 = list2;
        KtElement ktElement2 = ktElement;
        Project project4 = project3;
        SourceData sourceData = new SourceData(project4, ktElement2, list3, ktFile2, psiDirectory2);
        TargetData targetData = this.getTargetData(sourceData);
        if (targetData == null) {
            return;
        }
        TargetData targetData2 = targetData;
        for (KtElement element2 : elementsToCopy) {
            String windowTitle$iv;
            void contextElement$iv2;
            destination$iv$iv2 = (KtElement)CollectionsKt.first((List)elementsToCopy);
            Intrinsics.checkNotNullExpressionValue((Object)RefactoringBundle.message((String)"refactoring.preprocess.usages.progress"), (String)"message(...)");
            boolean $i$f$analyzeInModalWindow = false;
            ThreadingAssertions.assertEventDispatchThread();
            Project element$iv$iv = contextElement$iv2.getProject();
            Task.WithResult<Unit, Exception> task$iv = new Task.WithResult<Unit, Exception>(windowTitle$iv, (KtElement)contextElement$iv2, element$iv$iv, element2){
                final /* synthetic */ KtElement $contextElement;
                final /* synthetic */ KtElement $element$inlined;
                {
                    this.$contextElement = $contextElement;
                    this.$element$inlined = ktElement;
                    super($super_call_param$1, $windowTitle, true);
                }

                protected Unit compute(ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    return ActionsKt.runReadAction((Function0)((Function0)new Function0<Unit>(this.$contextElement, this.$element$inlined){
                        final /* synthetic */ KtElement $contextElement;
                        final /* synthetic */ KtElement $element$inlined;
                        {
                            this.$contextElement = $contextElement;
                            this.$element$inlined = ktElement;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * WARNING - void declaration
                         */
                        public final Unit invoke() {
                            Unit unit;
                            void this_$iv$iv;
                            KtElement useSiteElement$iv = this.$contextElement;
                            boolean $i$f$analyze = false;
                            Project project = useSiteElement$iv.getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                            KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
                            KtElement useSiteElement$iv$iv = useSiteElement$iv;
                            boolean $i$f$analyze2 = false;
                            KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv$iv);
                            this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
                            try {
                                Unit unit2;
                                Object lock$iv$iv;
                                Object object = lock$iv$iv = new Object();
                                synchronized (object) {
                                    boolean bl = false;
                                    KaSession $this$doCopy_u24lambda_u243 = analysisSession$iv$iv;
                                    boolean bl2 = false;
                                    K2MoveRenameUsageInfo.Companion.markInternalUsages((PsiElement)this.$element$inlined, this.$element$inlined);
                                    unit2 = Unit.INSTANCE;
                                }
                                unit = unit2;
                            }
                            catch (Throwable throwable$iv$iv) {
                                this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, useSiteElement$iv$iv);
                                throw new KotlinNothingValueException();
                            }
                            finally {
                                this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
                            }
                            return unit;
                        }
                    }));
                }
            };
            task$iv.queue();
            task$iv.getResult();
        }
        element2 = (KtElement)CollectionsKt.first((List)elementsToCopy);
        String string = RefactoringBundle.message((String)"detecting.possible.conflicts");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String windowTitle$iv = string;
        boolean $i$f$analyzeInModalWindow = false;
        ThreadingAssertions.assertEventDispatchThread();
        Project project5 = contextElement$iv.getProject();
        Task.WithResult<MultiMap<PsiElement, String>, Exception> task$iv = new Task.WithResult<MultiMap<PsiElement, String>, Exception>(windowTitle$iv, (KtElement)contextElement$iv, project5, this, sourceData, targetData2){
            final /* synthetic */ KtElement $contextElement;
            final /* synthetic */ CopyKotlinDeclarationsHandler this$0;
            final /* synthetic */ SourceData $sourceData$inlined;
            final /* synthetic */ TargetData $targetData$inlined;
            {
                this.$contextElement = $contextElement;
                this.this$0 = copyKotlinDeclarationsHandler;
                this.$sourceData$inlined = sourceData;
                this.$targetData$inlined = targetData;
                super($super_call_param$1, $windowTitle, true);
            }

            protected MultiMap<PsiElement, String> compute(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                return ActionsKt.runReadAction((Function0)((Function0)new Function0<MultiMap<PsiElement, String>>(this.$contextElement, this.this$0, this.$sourceData$inlined, this.$targetData$inlined){
                    final /* synthetic */ KtElement $contextElement;
                    final /* synthetic */ CopyKotlinDeclarationsHandler this$0;
                    final /* synthetic */ SourceData $sourceData$inlined;
                    final /* synthetic */ TargetData $targetData$inlined;
                    {
                        this.$contextElement = $contextElement;
                        this.this$0 = copyKotlinDeclarationsHandler;
                        this.$sourceData$inlined = sourceData;
                        this.$targetData$inlined = targetData;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * WARNING - void declaration
                     */
                    public final MultiMap<PsiElement, String> invoke() {
                        MultiMap multiMap;
                        void this_$iv$iv;
                        KtElement useSiteElement$iv = this.$contextElement;
                        boolean $i$f$analyze = false;
                        Project project = useSiteElement$iv.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                        KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
                        KtElement useSiteElement$iv$iv = useSiteElement$iv;
                        boolean $i$f$analyze2 = false;
                        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv$iv);
                        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
                        try {
                            MultiMap multiMap2;
                            Object lock$iv$iv;
                            Object object = lock$iv$iv = new Object();
                            synchronized (object) {
                                boolean bl = false;
                                KaSession $this$doCopy_u24lambda_u244 = analysisSession$iv$iv;
                                boolean bl2 = false;
                                multiMap2 = CopyKotlinDeclarationsHandler.access$collectConflicts(this.this$0, this.$sourceData$inlined, this.$targetData$inlined);
                            }
                            multiMap = multiMap2;
                        }
                        catch (Throwable throwable$iv$iv) {
                            this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, useSiteElement$iv$iv);
                            throw new KotlinNothingValueException();
                        }
                        finally {
                            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
                        }
                        return multiMap;
                    }
                }));
            }
        };
        task$iv.queue();
        MultiMap conflicts = (MultiMap)task$iv.getResult();
        KotlinCommonRefactoringUtilKt.checkConflictsInteractively$default(project2, conflicts, null, () -> CopyKotlinDeclarationsHandler.doCopy$lambda$8(project2, elements, this, sourceData, targetData2), 2, null);
    }

    private final void doRefactor(SourceData sourceData, TargetData targetData) {
        try {
            RefactoringResult refactoringResult;
            KtFile fileToCopy;
            PsiDirectory targetDirectory = (PsiDirectory)ActionsKt.runWriteAction(() -> CopyKotlinDeclarationsHandler.doRefactor$lambda$9(targetData));
            String targetFileName = StringsKt.contains$default((CharSequence)targetData.getNewName(), (CharSequence)".", (boolean)false, (int)2, null) ? targetData.getNewName() : targetData.getNewName() + "." + sourceData.getOriginalFile().getVirtualFile().getExtension();
            boolean isSingleDeclarationInFile = sourceData.getSingleElementToCopy() instanceof KtNamedDeclaration && Intrinsics.areEqual((Object)CollectionsKt.singleOrNull((List)sourceData.getOriginalFile().getDeclarations()), (Object)sourceData.getSingleElementToCopy());
            Object object = sourceData.getSingleElementToCopy() instanceof KtFile ? (KtFile)sourceData.getSingleElementToCopy() : (fileToCopy = isSingleDeclarationInFile ? sourceData.getOriginalFile() : null);
            if (fileToCopy != null) {
                refactoringResult = this.doRefactoringOnFile(fileToCopy, targetDirectory, targetFileName, isSingleDeclarationInFile);
            } else {
                KtFile ktFile2 = this.getOrCreateTargetFile(sourceData.getOriginalFile(), targetDirectory, targetFileName);
                if (ktFile2 == null) {
                    throw new IncorrectOperationException("Could not create target file.");
                }
                KtFile targetFile = ktFile2;
                refactoringResult = this.doRefactoringOnElement(sourceData, targetFile);
            }
            RefactoringResult refactoringResult2 = refactoringResult;
            KtNamedDeclaration ktNamedDeclaration = refactoringResult2.getCopiedDeclaration();
            if (ktNamedDeclaration != null) {
                KtNamedDeclaration newDeclaration = ktNamedDeclaration;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)targetData.getNewName(), (Object)newDeclaration.getName())) {
                    Collection selfReferences = ReferencesSearch.search((PsiElement)((PsiElement)newDeclaration), (SearchScope)((SearchScope)new LocalSearchScope((PsiElement)newDeclaration))).findAll();
                    ActionsKt.runWriteAction(() -> CopyKotlinDeclarationsHandler.doRefactor$lambda$12$lambda$11(selfReferences, newDeclaration, targetData));
                }
            }
            if (targetData.getOpenInEditor()) {
                EditorHelper.openInEditor((PsiElement)((PsiElement)refactoringResult2.getTargetFile()));
            }
        }
        catch (IncorrectOperationException e) {
            ApplicationManager.getApplication().invokeLater(() -> CopyKotlinDeclarationsHandler.doRefactor$lambda$13(sourceData, e), ModalityState.nonModal());
        }
    }

    private final RefactoringResult doRefactoringOnFile(KtFile fileToCopy, PsiDirectory targetDirectory, String targetFileName, boolean isSingleDeclarationInFile) {
        Object object;
        PsiFile targetFile = (PsiFile)ActionsKt.runWriteAction(() -> CopyKotlinDeclarationsHandler.doRefactoringOnFile$lambda$15(targetDirectory, targetFileName, fileToCopy));
        KtNamedDeclaration copiedDeclaration = isSingleDeclarationInFile && targetFile instanceof KtFile ? ((object = CollectionsKt.singleOrNull((List)((KtFile)targetFile).getDeclarations())) instanceof KtNamedDeclaration ? (KtNamedDeclaration)object : null) : null;
        return new RefactoringResult(targetFile, copiedDeclaration, null, 4, null);
    }

    private final RefactoringResult doRefactoringOnElement(SourceData sourceData, KtFile targetFile) {
        ArrayList restoredInternalUsages = new ArrayList();
        HashMap oldToNewElementsMapping = new HashMap();
        KtNamedDeclaration copiedDeclaration = (KtNamedDeclaration)ActionsKt.runWriteAction(() -> CopyKotlinDeclarationsHandler.doRefactoringOnElement$lambda$18(sourceData, oldToNewElementsMapping, targetFile));
        return new RefactoringResult((PsiFile)targetFile, copiedDeclaration, restoredInternalUsages);
    }

    /*
     * WARNING - void declaration
     */
    private final MultiMap<PsiElement, String> collectConflicts(SourceData sourceData, TargetData targetData) {
        MultiMap multiMap;
        boolean $i$f$isUnitTestMode = false;
        if (ApplicationManager.getApplication().isUnitTestMode() && BaseRefactoringProcessor.ConflictsInTestsException.isTestIgnore()) {
            MultiMap multiMap2 = MultiMap.empty();
            Intrinsics.checkNotNullExpressionValue((Object)multiMap2, (String)"empty(...)");
            return multiMap2;
        }
        if (!Intrinsics.areEqual((Object)sourceData.getProject(), (Object)sourceData.getOriginalFile().getProject())) {
            MultiMap multiMap3 = MultiMap.empty();
            Intrinsics.checkNotNullExpressionValue((Object)multiMap3, (String)"empty(...)");
            return multiMap3;
        }
        Set elements = new LinkedHashSet();
        elements.addAll((Collection)sourceData.getElementsToCopy());
        KtElement ktElement = sourceData.getSingleElementToCopy();
        Object object = ktElement instanceof KtFile ? (KtFile)ktElement : null;
        if (object != null && (object = object.getDeclarations()) != null) {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = (Iterable)object;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof KtNamedDeclaration)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtNamedDeclaration p0 = (KtNamedDeclaration)element$iv;
                boolean bl = false;
                elements.add(p0);
            }
        }
        if (elements.isEmpty()) {
            MultiMap multiMap4 = MultiMap.empty();
            Intrinsics.checkNotNullExpressionValue((Object)multiMap4, (String)"empty(...)");
            return multiMap4;
        }
        MultiMap $this$collectConflicts_u24lambda_u2419 = multiMap = new MultiMap();
        boolean bl = false;
        $this$collectConflicts_u24lambda_u2419.putAllValues(VisibilityConflictKt.checkVisibilityConflictsForInternalUsages$default(sourceData.getElementsToCopy(), elements, targetData.getTargetDirWrapper().getPkgName(), targetData.getTargetDirWrapper().getBaseDirectory(), null, 16, null));
        $this$collectConflicts_u24lambda_u2419.putAllValues(ModuleDependencyConflictKt.checkModuleDependencyConflictsForInternalUsages((Iterable<? extends KtNamedDeclaration>)sourceData.getElementsToCopy(), elements, targetData.getTargetDirWrapper().getBaseDirectory()));
        return multiMap;
    }

    public void doClone(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
    }

    private static final PsiDirectory toDirectory$lambda$0(MoveDestination $this_toDirectory, SourceData $sourceData) {
        return $this_toDirectory.getTargetDirectory($sourceData.getInitialTargetDirectory());
    }

    private static final Unit doCopyFiles$lambda$1(CopyKotlinDeclarationsHandler this$0, PsiFileSystemItem[] $filesToCopy, PsiDirectory $initialTargetDirectory) {
        if (this$0.getCopyFilesHandler().canCopy((PsiElement[])$filesToCopy)) {
            this$0.getCopyFilesHandler().doCopy((PsiElement[])$filesToCopy, $initialTargetDirectory);
        }
        return Unit.INSTANCE;
    }

    private static final Unit doCopy$lambda$8$lambda$6$lambda$5(CopyKotlinDeclarationsHandler this$0, SourceData $sourceData, TargetData $targetData) {
        this$0.doRefactor($sourceData, $targetData);
        return Unit.INSTANCE;
    }

    private static final Unit doCopy$lambda$8$lambda$6(Project $project, CopyKotlinDeclarationsHandler this$0, SourceData $sourceData, TargetData $targetData, ProgressIndicator it) {
        ApplicationUtilsKt.executeCommand$default($project, AbstractCopyKotlinDeclarationsHandlerKt.getCopyCommandName(), null, () -> CopyKotlinDeclarationsHandler.doCopy$lambda$8$lambda$6$lambda$5(this$0, $sourceData, $targetData), 2, null);
        return Unit.INSTANCE;
    }

    private static final void doCopy$lambda$8$lambda$7(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Unit doCopy$lambda$8(Project $project, PsiElement[] $elements, CopyKotlinDeclarationsHandler this$0, SourceData $sourceData, TargetData $targetData) {
        void $this$forEach$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Object $this$filterIsInstance$iv;
        try {
            ApplicationManagerEx.getApplicationEx().runWriteActionWithCancellableProgressInDispatchThread(AbstractCopyKotlinDeclarationsHandlerKt.getCopyCommandName(), $project, null, arg_0 -> CopyKotlinDeclarationsHandler.doCopy$lambda$8$lambda$7(arg_0 -> CopyKotlinDeclarationsHandler.doCopy$lambda$8$lambda$6($project, this$0, $sourceData, $targetData, arg_0), arg_0));
            $this$filterIsInstance$iv = $elements;
            boolean $i$f$filterIsInstance = false;
            PsiElement[] psiElementArray = $this$filterIsInstance$iv;
        }
        catch (Throwable throwable) {
            void $this$forEach$iv2;
            void $this$filterIsInstanceTo$iv$iv2;
            Object $this$filterIsInstance$iv2 = $elements;
            boolean $i$f$filterIsInstance = false;
            PsiElement[] destination$iv$iv = $this$filterIsInstance$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
                if (!(element$iv$iv instanceof KtElement)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filterIsInstance$iv2 = (List)destination$iv$iv2;
            K2MoveRenameUsageInfo.Companion companion = K2MoveRenameUsageInfo.Companion;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv2) {
                KtElement p0 = (KtElement)element$iv;
                boolean bl = false;
                companion.unMarkAllUsages(p0);
            }
            throw throwable;
        }
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtElement)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        K2MoveRenameUsageInfo.Companion $i$f$filterIsInstance = K2MoveRenameUsageInfo.Companion;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtElement p0 = (KtElement)element$iv;
            boolean bl = false;
            $i$f$filterIsInstance.unMarkAllUsages(p0);
        }
        return Unit.INSTANCE;
    }

    private static final PsiDirectory doRefactor$lambda$9(TargetData $targetData) {
        PsiElement psiElement = $targetData.getTargetDirWrapper().getOrCreateTarget(true);
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.psi.PsiDirectory");
        return (PsiDirectory)psiElement;
    }

    private static final Unit doRefactor$lambda$12$lambda$11(Collection $selfReferences, KtNamedDeclaration $newDeclaration, TargetData $targetData) {
        Iterable $this$forEach$iv = $selfReferences;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiReference it = (PsiReference)element$iv;
            boolean bl = false;
            it.handleElementRename($targetData.getNewName());
        }
        $newDeclaration.setName($targetData.getNewName());
        return Unit.INSTANCE;
    }

    private static final void doRefactor$lambda$13(SourceData $sourceData, IncorrectOperationException $e) {
        Messages.showMessageDialog((Project)$sourceData.getProject(), (String)$e.getMessage(), (String)RefactoringBundle.message((String)"error.title"), (Icon)Messages.getErrorIcon());
    }

    private static final PsiFile doRefactoringOnFile$lambda$15(PsiDirectory $targetDirectory, String $targetFileName, KtFile $fileToCopy) {
        FqName targetDirectoryFqName = PackageUtilsKt.getFqNameWithImplicitPrefix($targetDirectory);
        PsiFile psiFile = $targetDirectory.copyFileFrom($targetFileName, (PsiFile)$fileToCopy);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"copyFileFrom(...)");
        PsiFile copiedFile = psiFile;
        if (copiedFile instanceof KtFile) {
            if (PackageUtilsKt.packageMatchesDirectoryOrImplicit($fileToCopy)) {
                FqName fqName2 = targetDirectoryFqName;
                if (fqName2 != null && (fqName2 = FqNameUtils.quoteIfNeeded(fqName2)) != null) {
                    FqName it = fqName2;
                    boolean bl = false;
                    ((KtFile)copiedFile).setPackageFqName(it);
                }
            }
            K2MoveRenameUsageInfo.Companion.retargetInternalUsagesForCopyFile($fileToCopy, (KtFile)copiedFile);
        }
        return copiedFile;
    }

    /*
     * WARNING - void declaration
     */
    private static final KtNamedDeclaration doRefactoringOnElement$lambda$18(SourceData $sourceData, HashMap $oldToNewElementsMapping, KtFile $targetFile) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $sourceData.getElementsToCopy();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PsiElement psiElement = $targetFile.add(it.copy());
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedDeclaration");
            collection.add((KtNamedDeclaration)psiElement);
        }
        List newElements = (List)destination$iv$iv;
        Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)$sourceData.getElementsToCopy(), (Iterable)newElements);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement $this$forEachDescendantOfType$iv$iv$iv$iv;
            Collection to$iv$iv$iv;
            PsiElement $this$collectDescendantsOfTypeTo$iv$iv$iv;
            PsiElement $this$collectDescendantsOfType$iv$iv;
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            KtNamedDeclaration original = (KtNamedDeclaration)pair.component1();
            KtNamedDeclaration newElement2 = (KtNamedDeclaration)pair.component2();
            PsiElement $this$collectDescendantsOfType_u24default$iv = (PsiElement)original;
            Function1 predicate$iv = doRefactoringOnElement$lambda$18$lambda$17$$inlined$collectDescendantsOfType$default$1.INSTANCE;
            boolean $i$f$collectDescendantsOfType = false;
            PsiElement psiElement = $this$collectDescendantsOfType_u24default$iv;
            Function1 predicate$iv$iv = predicate$iv;
            boolean $i$f$collectDescendantsOfType2 = false;
            void var18_22 = $this$collectDescendantsOfType$iv$iv;
            Collection collection = new ArrayList();
            Function1 predicate$iv$iv$iv = predicate$iv$iv;
            boolean $i$f$collectDescendantsOfTypeTo = false;
            void var22_26 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
            Function1 action$iv$iv$iv$iv = (Function1)new Function1<KtNamedDeclaration, Unit>(predicate$iv$iv$iv, to$iv$iv$iv){
                final /* synthetic */ Function1 $predicate;
                final /* synthetic */ Collection $to;
                {
                    this.$predicate = $predicate;
                    this.$to = $to;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final void invoke(PsiElement it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                        this.$to.add(it);
                    }
                }
            };
            boolean $i$f$forEachDescendantOfType = false;
            PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv$iv$iv$iv);
            $this$forEachDescendantOfType$iv$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
                final /* synthetic */ Function1 $action;
                {
                    this.$action = $action;
                }

                public void visitElement(PsiElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    PsiElement it = element;
                    boolean bl = false;
                    super.visitElement(element);
                    if (element instanceof KtNamedDeclaration) {
                        this.$action.invoke((Object)element);
                    }
                }
            });
            Iterable iterable2 = (List)to$iv$iv$iv;
            $this$collectDescendantsOfType_u24default$iv = (PsiElement)newElement2;
            predicate$iv = doRefactoringOnElement$lambda$18$lambda$17$$inlined$collectDescendantsOfType$default$4.INSTANCE;
            $i$f$collectDescendantsOfType = false;
            $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType_u24default$iv;
            predicate$iv$iv = predicate$iv;
            $i$f$collectDescendantsOfType2 = false;
            $this$collectDescendantsOfTypeTo$iv$iv$iv = $this$collectDescendantsOfType$iv$iv;
            to$iv$iv$iv = new ArrayList();
            predicate$iv$iv$iv = predicate$iv$iv;
            $i$f$collectDescendantsOfTypeTo = false;
            $this$forEachDescendantOfType$iv$iv$iv$iv = $this$collectDescendantsOfTypeTo$iv$iv$iv;
            action$iv$iv$iv$iv = (Function1)new Function1<KtNamedDeclaration, Unit>(predicate$iv$iv$iv, to$iv$iv$iv){
                final /* synthetic */ Function1 $predicate;
                final /* synthetic */ Collection $to;
                {
                    this.$predicate = $predicate;
                    this.$to = $to;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final void invoke(PsiElement it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                        this.$to.add(it);
                    }
                }
            };
            $i$f$forEachDescendantOfType = false;
            PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv$iv$iv$iv);
            $this$forEachDescendantOfType$iv$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
                final /* synthetic */ Function1 $action;
                {
                    this.$action = $action;
                }

                public void visitElement(PsiElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    PsiElement it = element;
                    boolean bl = false;
                    super.visitElement(element);
                    if (element instanceof KtNamedDeclaration) {
                        this.$action.invoke((Object)element);
                    }
                }
            });
            MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)iterable2, (Iterable)((List)to$iv$iv$iv)), (Map)$oldToNewElementsMapping);
        }
        List list2 = CollectionsKt.emptyList();
        Intrinsics.checkNotNull((Object)$oldToNewElementsMapping, (String)"null cannot be cast to non-null type kotlin.collections.Map<com.intellij.psi.PsiElement, com.intellij.psi.PsiElement>");
        K2MoveRenameUsageInfo.Companion.retargetUsages(list2, $oldToNewElementsMapping, true);
        return (KtNamedDeclaration)CollectionsKt.singleOrNull((List)newElements);
    }

    public static final /* synthetic */ MultiMap access$collectConflicts(CopyKotlinDeclarationsHandler $this, SourceData sourceData, TargetData targetData) {
        return $this.collectConflicts(sourceData, targetData);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u0011\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007H\u00c6\u0003J1\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/copy/CopyKotlinDeclarationsHandler$RefactoringResult;", "", "targetFile", "Lcom/intellij/psi/PsiFile;", "copiedDeclaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "restoredInternalUsages", "", "Lcom/intellij/usageView/UsageInfo;", "<init>", "(Lcom/intellij/psi/PsiFile;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Ljava/util/List;)V", "getTargetFile", "()Lcom/intellij/psi/PsiFile;", "getCopiedDeclaration", "()Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "getRestoredInternalUsages", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.refactorings.k2"})
    private static final class RefactoringResult {
        @NotNull
        private final PsiFile targetFile;
        @Nullable
        private final KtNamedDeclaration copiedDeclaration;
        @Nullable
        private final List<UsageInfo> restoredInternalUsages;

        public RefactoringResult(@NotNull PsiFile targetFile, @Nullable KtNamedDeclaration copiedDeclaration, @Nullable List<? extends UsageInfo> restoredInternalUsages) {
            Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
            this.targetFile = targetFile;
            this.copiedDeclaration = copiedDeclaration;
            this.restoredInternalUsages = restoredInternalUsages;
        }

        public /* synthetic */ RefactoringResult(PsiFile psiFile, KtNamedDeclaration ktNamedDeclaration, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list2 = null;
            }
            this(psiFile, ktNamedDeclaration, list2);
        }

        @NotNull
        public final PsiFile getTargetFile() {
            return this.targetFile;
        }

        @Nullable
        public final KtNamedDeclaration getCopiedDeclaration() {
            return this.copiedDeclaration;
        }

        @Nullable
        public final List<UsageInfo> getRestoredInternalUsages() {
            return this.restoredInternalUsages;
        }

        @NotNull
        public final PsiFile component1() {
            return this.targetFile;
        }

        @Nullable
        public final KtNamedDeclaration component2() {
            return this.copiedDeclaration;
        }

        @Nullable
        public final List<UsageInfo> component3() {
            return this.restoredInternalUsages;
        }

        @NotNull
        public final RefactoringResult copy(@NotNull PsiFile targetFile, @Nullable KtNamedDeclaration copiedDeclaration, @Nullable List<? extends UsageInfo> restoredInternalUsages) {
            Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
            return new RefactoringResult(targetFile, copiedDeclaration, restoredInternalUsages);
        }

        public static /* synthetic */ RefactoringResult copy$default(RefactoringResult refactoringResult, PsiFile psiFile, KtNamedDeclaration ktNamedDeclaration, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                psiFile = refactoringResult.targetFile;
            }
            if ((n & 2) != 0) {
                ktNamedDeclaration = refactoringResult.copiedDeclaration;
            }
            if ((n & 4) != 0) {
                list2 = refactoringResult.restoredInternalUsages;
            }
            return refactoringResult.copy(psiFile, ktNamedDeclaration, list2);
        }

        @NotNull
        public String toString() {
            return "RefactoringResult(targetFile=" + this.targetFile + ", copiedDeclaration=" + this.copiedDeclaration + ", restoredInternalUsages=" + this.restoredInternalUsages + ")";
        }

        public int hashCode() {
            int result2 = this.targetFile.hashCode();
            result2 = result2 * 31 + (this.copiedDeclaration == null ? 0 : this.copiedDeclaration.hashCode());
            result2 = result2 * 31 + (this.restoredInternalUsages == null ? 0 : ((Object)this.restoredInternalUsages).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RefactoringResult)) {
                return false;
            }
            RefactoringResult refactoringResult = (RefactoringResult)other;
            if (!Intrinsics.areEqual((Object)this.targetFile, (Object)refactoringResult.targetFile)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.copiedDeclaration, (Object)refactoringResult.copiedDeclaration)) {
                return false;
            }
            return Intrinsics.areEqual(this.restoredInternalUsages, refactoringResult.restoredInternalUsages);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\nH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\fH\u00c6\u0003JC\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\t\u0010$\u001a\u00020%H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/copy/CopyKotlinDeclarationsHandler$SourceData;", "", "project", "Lcom/intellij/openapi/project/Project;", "singleElementToCopy", "Lorg/jetbrains/kotlin/psi/KtElement;", "elementsToCopy", "", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "originalFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "initialTargetDirectory", "Lcom/intellij/psi/PsiDirectory;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/psi/KtElement;Ljava/util/List;Lorg/jetbrains/kotlin/psi/KtFile;Lcom/intellij/psi/PsiDirectory;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSingleElementToCopy", "()Lorg/jetbrains/kotlin/psi/KtElement;", "getElementsToCopy", "()Ljava/util/List;", "getOriginalFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "getInitialTargetDirectory", "()Lcom/intellij/psi/PsiDirectory;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.refactorings.k2"})
    private static final class SourceData {
        @NotNull
        private final Project project;
        @Nullable
        private final KtElement singleElementToCopy;
        @NotNull
        private final List<KtNamedDeclaration> elementsToCopy;
        @NotNull
        private final KtFile originalFile;
        @NotNull
        private final PsiDirectory initialTargetDirectory;

        public SourceData(@NotNull Project project, @Nullable KtElement singleElementToCopy, @NotNull List<? extends KtNamedDeclaration> elementsToCopy, @NotNull KtFile originalFile, @NotNull PsiDirectory initialTargetDirectory) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(elementsToCopy, (String)"elementsToCopy");
            Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
            Intrinsics.checkNotNullParameter((Object)initialTargetDirectory, (String)"initialTargetDirectory");
            this.project = project;
            this.singleElementToCopy = singleElementToCopy;
            this.elementsToCopy = elementsToCopy;
            this.originalFile = originalFile;
            this.initialTargetDirectory = initialTargetDirectory;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @Nullable
        public final KtElement getSingleElementToCopy() {
            return this.singleElementToCopy;
        }

        @NotNull
        public final List<KtNamedDeclaration> getElementsToCopy() {
            return this.elementsToCopy;
        }

        @NotNull
        public final KtFile getOriginalFile() {
            return this.originalFile;
        }

        @NotNull
        public final PsiDirectory getInitialTargetDirectory() {
            return this.initialTargetDirectory;
        }

        @NotNull
        public final Project component1() {
            return this.project;
        }

        @Nullable
        public final KtElement component2() {
            return this.singleElementToCopy;
        }

        @NotNull
        public final List<KtNamedDeclaration> component3() {
            return this.elementsToCopy;
        }

        @NotNull
        public final KtFile component4() {
            return this.originalFile;
        }

        @NotNull
        public final PsiDirectory component5() {
            return this.initialTargetDirectory;
        }

        @NotNull
        public final SourceData copy(@NotNull Project project, @Nullable KtElement singleElementToCopy, @NotNull List<? extends KtNamedDeclaration> elementsToCopy, @NotNull KtFile originalFile, @NotNull PsiDirectory initialTargetDirectory) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(elementsToCopy, (String)"elementsToCopy");
            Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
            Intrinsics.checkNotNullParameter((Object)initialTargetDirectory, (String)"initialTargetDirectory");
            return new SourceData(project, singleElementToCopy, elementsToCopy, originalFile, initialTargetDirectory);
        }

        public static /* synthetic */ SourceData copy$default(SourceData sourceData, Project project, KtElement ktElement, List list2, KtFile ktFile2, PsiDirectory psiDirectory, int n, Object object) {
            if ((n & 1) != 0) {
                project = sourceData.project;
            }
            if ((n & 2) != 0) {
                ktElement = sourceData.singleElementToCopy;
            }
            if ((n & 4) != 0) {
                list2 = sourceData.elementsToCopy;
            }
            if ((n & 8) != 0) {
                ktFile2 = sourceData.originalFile;
            }
            if ((n & 0x10) != 0) {
                psiDirectory = sourceData.initialTargetDirectory;
            }
            return sourceData.copy(project, ktElement, list2, ktFile2, psiDirectory);
        }

        @NotNull
        public String toString() {
            return "SourceData(project=" + this.project + ", singleElementToCopy=" + this.singleElementToCopy + ", elementsToCopy=" + this.elementsToCopy + ", originalFile=" + this.originalFile + ", initialTargetDirectory=" + this.initialTargetDirectory + ")";
        }

        public int hashCode() {
            int result2 = this.project.hashCode();
            result2 = result2 * 31 + (this.singleElementToCopy == null ? 0 : this.singleElementToCopy.hashCode());
            result2 = result2 * 31 + ((Object)this.elementsToCopy).hashCode();
            result2 = result2 * 31 + this.originalFile.hashCode();
            result2 = result2 * 31 + this.initialTargetDirectory.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SourceData)) {
                return false;
            }
            SourceData sourceData = (SourceData)other;
            if (!Intrinsics.areEqual((Object)this.project, (Object)sourceData.project)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.singleElementToCopy, (Object)sourceData.singleElementToCopy)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.elementsToCopy, sourceData.elementsToCopy)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.originalFile, (Object)sourceData.originalFile)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.initialTargetDirectory, (Object)sourceData.initialTargetDirectory);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\tH\u00c6\u0003J3\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u00032\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/copy/CopyKotlinDeclarationsHandler$TargetData;", "", "openInEditor", "", "newName", "", "targetDirWrapper", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor;", "targetSourceRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(ZLjava/lang/String;Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getOpenInEditor", "()Z", "getNewName", "()Ljava/lang/String;", "getTargetDirWrapper", "()Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor;", "getTargetSourceRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "kotlin.refactorings.k2"})
    private static final class TargetData {
        private final boolean openInEditor;
        @NotNull
        private final String newName;
        @NotNull
        private final K2MoveTargetDescriptor targetDirWrapper;
        @Nullable
        private final VirtualFile targetSourceRoot;

        public TargetData(boolean openInEditor, @NotNull String newName, @NotNull K2MoveTargetDescriptor targetDirWrapper, @Nullable VirtualFile targetSourceRoot) {
            Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
            Intrinsics.checkNotNullParameter((Object)targetDirWrapper, (String)"targetDirWrapper");
            this.openInEditor = openInEditor;
            this.newName = newName;
            this.targetDirWrapper = targetDirWrapper;
            this.targetSourceRoot = targetSourceRoot;
        }

        public final boolean getOpenInEditor() {
            return this.openInEditor;
        }

        @NotNull
        public final String getNewName() {
            return this.newName;
        }

        @NotNull
        public final K2MoveTargetDescriptor getTargetDirWrapper() {
            return this.targetDirWrapper;
        }

        @Nullable
        public final VirtualFile getTargetSourceRoot() {
            return this.targetSourceRoot;
        }

        public final boolean component1() {
            return this.openInEditor;
        }

        @NotNull
        public final String component2() {
            return this.newName;
        }

        @NotNull
        public final K2MoveTargetDescriptor component3() {
            return this.targetDirWrapper;
        }

        @Nullable
        public final VirtualFile component4() {
            return this.targetSourceRoot;
        }

        @NotNull
        public final TargetData copy(boolean openInEditor, @NotNull String newName, @NotNull K2MoveTargetDescriptor targetDirWrapper, @Nullable VirtualFile targetSourceRoot) {
            Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
            Intrinsics.checkNotNullParameter((Object)targetDirWrapper, (String)"targetDirWrapper");
            return new TargetData(openInEditor, newName, targetDirWrapper, targetSourceRoot);
        }

        public static /* synthetic */ TargetData copy$default(TargetData targetData, boolean bl, String string, K2MoveTargetDescriptor k2MoveTargetDescriptor, VirtualFile virtualFile, int n, Object object) {
            if ((n & 1) != 0) {
                bl = targetData.openInEditor;
            }
            if ((n & 2) != 0) {
                string = targetData.newName;
            }
            if ((n & 4) != 0) {
                k2MoveTargetDescriptor = targetData.targetDirWrapper;
            }
            if ((n & 8) != 0) {
                virtualFile = targetData.targetSourceRoot;
            }
            return targetData.copy(bl, string, k2MoveTargetDescriptor, virtualFile);
        }

        @NotNull
        public String toString() {
            return "TargetData(openInEditor=" + this.openInEditor + ", newName=" + this.newName + ", targetDirWrapper=" + this.targetDirWrapper + ", targetSourceRoot=" + this.targetSourceRoot + ")";
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.openInEditor);
            result2 = result2 * 31 + this.newName.hashCode();
            result2 = result2 * 31 + this.targetDirWrapper.hashCode();
            result2 = result2 * 31 + (this.targetSourceRoot == null ? 0 : this.targetSourceRoot.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TargetData)) {
                return false;
            }
            TargetData targetData = (TargetData)other;
            if (this.openInEditor != targetData.openInEditor) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.newName, (Object)targetData.newName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.targetDirWrapper, (Object)targetData.targetDirWrapper)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.targetSourceRoot, (Object)targetData.targetSourceRoot);
        }
    }
}

