/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.compilation;

import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.sun.jdi.Location;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.idea.base.utils.fqname.FqNameUtilKt;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.ExecutionContext;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.ThisLabelUtilsKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.DebuggerFieldPropertyDescriptor;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerEvaluationBundle;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentParameter;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentParameterAnalyzer;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentParameterAnalyzerKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.ForeignPropertyDescriptor;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.K1CodeFragmentParameterInfo;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.OnceUsedChecker;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.SmartCodeFragmentParameter;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitor;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CoroutineCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ContextClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ContextReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.expressions.FunctionsTypingVisitorKt;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u001a\u001a\u00020\u001bJ\u0012\u0010\u001c\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\r2\u0006\u0010 \u001a\u00020!H\u0002J$\u0010\"\u001a\u0004\u0018\u00010\r2\u0006\u0010 \u001a\u00020#2\u0006\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'H\u0002J\u0010\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020#H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010 \u001a\u00020#H\u0002J\u001a\u0010,\u001a\u0004\u0018\u00010\r2\u0006\u0010 \u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010\r2\u0006\u0010 \u001a\u00020#H\u0002J\u0010\u0010.\u001a\u00020\r2\u0006\u0010 \u001a\u00020/H\u0002J\u001a\u00100\u001a\u0004\u0018\u00010\r2\u0006\u00101\u001a\u00020\f2\u0006\u00102\u001a\u000203H\u0002J\u0010\u00104\u001a\u00020+2\u0006\u00101\u001a\u00020\fH\u0002J\u0010\u00105\u001a\u00020+2\u0006\u00102\u001a\u000206H\u0002J\u0010\u00107\u001a\u00020+2\u0006\u00101\u001a\u000208H\u0002J\u0012\u00109\u001a\u0004\u0018\u00010\r2\u0006\u00101\u001a\u00020\fH\u0002J\u0012\u0010:\u001a\u0004\u0018\u00010\r2\u0006\u00101\u001a\u00020\fH\u0002J\"\u0010;\u001a\u00020<2\b\u0010 \u001a\u0004\u0018\u00010\f2\u0006\u00102\u001a\u00020=2\b\u0010>\u001a\u0004\u0018\u00010\rJ\u0018\u0010?\u001a\u00020+2\u0006\u00102\u001a\u0002062\u0006\u0010@\u001a\u000206H\u0002J\u0012\u0010A\u001a\u00020+2\b\u0010 \u001a\u0004\u0018\u00010\fH\u0002J\u0015\u0010B\u001a\u00020+*\u0002062\u0006\u0010C\u001a\u000206H\u0082\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0014\u001a\u0004\u0018\u00010\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006D"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameterAnalyzer;", "", "context", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;Lorg/jetbrains/kotlin/psi/KtCodeFragment;Lorg/jetbrains/kotlin/resolve/BindingContext;)V", "parameters", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/SmartCodeFragmentParameter;", "Lkotlin/collections/LinkedHashMap;", "crossingBounds", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameter$Dumb;", "onceUsedChecker", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/OnceUsedChecker;", "containingPrimaryConstructor", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "getContainingPrimaryConstructor", "()Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "containingPrimaryConstructor$delegate", "Lkotlin/Lazy;", "analyze", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/K1CodeFragmentParameterInfo;", "processReceiver", "receiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ImplicitReceiver;", "processDispatchReceiver", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "processExtensionReceiver", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "receiverType", "Lorg/jetbrains/kotlin/types/KotlinType;", "label", "", "getLabel", "callableDescriptor", "isFakeFunctionForJavaContext", "", "processContextReceiver", "processFakeJavaCodeReceiver", "processSyntheticFieldVariable", "Lorg/jetbrains/kotlin/descriptors/impl/SyntheticFieldDescriptor;", "processSimpleNameExpression", "target", "expression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "isPrimaryConstructorParameter", "isAssignmentLValue", "Lcom/intellij/psi/PsiElement;", "isContainingPrimaryConstructorParameter", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "processCoroutineContextCall", "processForeignProperty", "checkBounds", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "parameter", "doesCrossInlineBounds", "declaration", "isCodeFragmentDeclaration", "isInside", "parent", "kotlin.jvm-debugger.evaluation.k1"})
@SourceDebugExtension(value={"SMAP\nCodeFragmentParameterAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeFragmentParameterAnalyzer.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameterAnalyzer\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,478:1\n382#2,7:479\n382#2,7:486\n382#2,7:494\n382#2,7:501\n382#2,7:508\n382#2,7:515\n382#2,7:522\n382#2,7:529\n382#2,7:536\n1#3:493\n196#4:543\n196#4:544\n196#4:545\n*S KotlinDebug\n*F\n+ 1 CodeFragmentParameterAnalyzer.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameterAnalyzer\n*L\n229#1:479,7\n244#1:486,7\n273#1:494,7\n288#1:501,7\n297#1:508,7\n316#1:515,7\n324#1:522,7\n362#1:529,7\n373#1:536,7\n68#1:543\n395#1:544\n396#1:545\n*E\n"})
public final class CodeFragmentParameterAnalyzer {
    @NotNull
    private final ExecutionContext context;
    @NotNull
    private final KtCodeFragment codeFragment;
    @NotNull
    private final BindingContext bindingContext;
    @NotNull
    private final LinkedHashMap<DeclarationDescriptor, SmartCodeFragmentParameter> parameters;
    @NotNull
    private final Set<CodeFragmentParameter.Dumb> crossingBounds;
    @NotNull
    private final OnceUsedChecker onceUsedChecker;
    @NotNull
    private final Lazy containingPrimaryConstructor$delegate;

    public CodeFragmentParameterAnalyzer(@NotNull ExecutionContext context, @NotNull KtCodeFragment codeFragment, @NotNull BindingContext bindingContext) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        this.context = context;
        this.codeFragment = codeFragment;
        this.bindingContext = bindingContext;
        this.parameters = new LinkedHashMap();
        this.crossingBounds = new LinkedHashSet();
        this.onceUsedChecker = new OnceUsedChecker(CodeFragmentParameterAnalyzer.class);
        this.containingPrimaryConstructor$delegate = LazyKt.lazy(() -> CodeFragmentParameterAnalyzer.containingPrimaryConstructor_delegate$lambda$1(this));
    }

    private final ConstructorDescriptor getContainingPrimaryConstructor() {
        Lazy lazy = this.containingPrimaryConstructor$delegate;
        return (ConstructorDescriptor)lazy.getValue();
    }

    @NotNull
    public final K1CodeFragmentParameterInfo analyze() {
        this.onceUsedChecker.trigger();
        this.codeFragment.accept((KtVisitor)new KtTreeVisitor<Unit>(this){
            final /* synthetic */ CodeFragmentParameterAnalyzer this$0;
            {
                this.this$0 = $receiver;
            }

            public Void visitSimpleNameExpression(KtSimpleNameExpression expression, Unit data) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression), (BindingContext)CodeFragmentParameterAnalyzer.access$getBindingContext$p(this.this$0));
                if (resolvedCall == null) {
                    return null;
                }
                ResolvedCall resolvedCall2 = resolvedCall;
                this.processResolvedCall(resolvedCall2, expression);
                return null;
            }

            private final void processResolvedCall(ResolvedCall<?> resolvedCall, KtSimpleNameExpression expression) {
                SmartCodeFragmentParameter parameter;
                if (resolvedCall instanceof VariableAsFunctionResolvedCall) {
                    this.processResolvedCall(((VariableAsFunctionResolvedCall)resolvedCall).getFunctionCall(), expression);
                    this.processResolvedCall(((VariableAsFunctionResolvedCall)resolvedCall).getVariableCall(), expression);
                    return;
                }
                CallableDescriptor callableDescriptor = resolvedCall.getResultingDescriptor();
                Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"getResultingDescriptor(...)");
                CallableDescriptor descriptor2 = callableDescriptor;
                analyze.1 var4_4 = this;
                CodeFragmentParameterAnalyzer codeFragmentParameterAnalyzer = this.this$0;
                analyze.1 $this$processResolvedCall_u24lambda_u240 = var4_4;
                boolean bl = false;
                DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
                ClassDescriptor containingClass = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
                ReceiverParameterDescriptor extensionParameter = descriptor2.getExtensionReceiverParameter();
                if (!(descriptor2 instanceof DebuggerFieldPropertyDescriptor) && extensionParameter != null && containingClass != null && containingClass.getKind() != ClassKind.OBJECT) {
                    SmartCodeFragmentParameter parameter2 = CodeFragmentParameterAnalyzer.access$processDispatchReceiver(codeFragmentParameterAnalyzer, containingClass);
                    codeFragmentParameterAnalyzer.checkBounds((DeclarationDescriptor)descriptor2, (KtExpression)expression, parameter2);
                }
                if (((Boolean)ActionsKt.runReadAction(() -> analyze.1.processResolvedCall$lambda$1(expression))).booleanValue()) {
                    CallableDescriptor callableDescriptor2 = resolvedCall.getResultingDescriptor();
                    Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor2, (String)"getResultingDescriptor(...)");
                    SmartCodeFragmentParameter parameter3 = CodeFragmentParameterAnalyzer.access$processCoroutineContextCall(this.this$0, (DeclarationDescriptor)callableDescriptor2);
                    if (parameter3 != null) {
                        this.this$0.checkBounds((DeclarationDescriptor)descriptor2, (KtExpression)expression, parameter3);
                    }
                }
                if (CodeFragmentParameterAnalyzer.access$isCodeFragmentDeclaration(this.this$0, (DeclarationDescriptor)descriptor2)) {
                    return;
                }
                Ref.BooleanRef processed = new Ref.BooleanRef();
                codeFragmentParameterAnalyzer = this.this$0;
                ResolvedCall<?> $this$processResolvedCall_u24lambda_u242 = resolvedCall;
                boolean bl2 = false;
                analyze.1.processResolvedCall$processImplicitReceiver(codeFragmentParameterAnalyzer, descriptor2, expression, processed, $this$processResolvedCall_u24lambda_u242.getDispatchReceiver());
                analyze.1.processResolvedCall$processImplicitReceiver(codeFragmentParameterAnalyzer, descriptor2, expression, processed, $this$processResolvedCall_u24lambda_u242.getExtensionReceiver());
                List list2 = $this$processResolvedCall_u24lambda_u242.getContextReceivers();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getContextReceivers(...)");
                Iterable $this$forEach$iv = list2;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    ReceiverValue p0 = (ReceiverValue)element$iv;
                    boolean bl3 = false;
                    analyze.1.processResolvedCall$processImplicitReceiver(codeFragmentParameterAnalyzer, descriptor2, expression, processed, p0);
                }
                if (!processed.element && descriptor2 instanceof SyntheticFieldDescriptor) {
                    parameter = CodeFragmentParameterAnalyzer.access$processSyntheticFieldVariable(this.this$0, (SyntheticFieldDescriptor)descriptor2);
                    this.this$0.checkBounds((DeclarationDescriptor)descriptor2, (KtExpression)expression, parameter);
                    processed.element = true;
                }
                if (!processed.element) {
                    parameter = this.processDescriptor((DeclarationDescriptor)descriptor2, expression);
                    this.this$0.checkBounds((DeclarationDescriptor)descriptor2, (KtExpression)expression, parameter);
                }
            }

            private final SmartCodeFragmentParameter processDescriptor(DeclarationDescriptor descriptor2, KtSimpleNameExpression expression) {
                SmartCodeFragmentParameter smartCodeFragmentParameter = CodeFragmentParameterAnalyzer.access$processForeignProperty(this.this$0, descriptor2);
                if (smartCodeFragmentParameter == null && (smartCodeFragmentParameter = CodeFragmentParameterAnalyzer.access$processCoroutineContextCall(this.this$0, descriptor2)) == null) {
                    smartCodeFragmentParameter = CodeFragmentParameterAnalyzer.access$processSimpleNameExpression(this.this$0, descriptor2, expression);
                }
                return smartCodeFragmentParameter;
            }

            public Void visitThisExpression(KtThisExpression expression, Unit data) {
                SmartCodeFragmentParameter smartCodeFragmentParameter;
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                Object object = ActionsKt.runReadAction(() -> analyze.1.visitThisExpression$lambda$3(expression));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
                KtReferenceExpression instanceReference = (KtReferenceExpression)object;
                DeclarationDescriptor target = (DeclarationDescriptor)CodeFragmentParameterAnalyzer.access$getBindingContext$p(this.this$0).get((ReadOnlySlice)BindingContext.REFERENCE_TARGET, (Object)instanceReference);
                if (CodeFragmentParameterAnalyzer.access$isCodeFragmentDeclaration(this.this$0, target)) {
                    return null;
                }
                DeclarationDescriptor declarationDescriptor = target;
                if (declarationDescriptor instanceof ClassDescriptor) {
                    smartCodeFragmentParameter = CodeFragmentParameterAnalyzer.access$processDispatchReceiver(this.this$0, (ClassDescriptor)target);
                } else if (declarationDescriptor instanceof CallableDescriptor) {
                    KotlinTypeInfo kotlinTypeInfo = (KotlinTypeInfo)CodeFragmentParameterAnalyzer.access$getBindingContext$p(this.this$0).get((ReadOnlySlice)BindingContext.EXPRESSION_TYPE_INFO, (Object)expression);
                    if (kotlinTypeInfo == null || (kotlinTypeInfo = kotlinTypeInfo.getType()) == null) {
                        return null;
                    }
                    KotlinTypeInfo type2 = kotlinTypeInfo;
                    smartCodeFragmentParameter = CodeFragmentParameterAnalyzer.access$processContextReceiver(this.this$0, (CallableDescriptor)target, (KotlinType)type2);
                    if (smartCodeFragmentParameter == null) {
                        smartCodeFragmentParameter = CodeFragmentParameterAnalyzer.access$processExtensionReceiver(this.this$0, (CallableDescriptor)target, (KotlinType)type2, expression.getLabelName());
                    }
                } else {
                    smartCodeFragmentParameter = null;
                }
                SmartCodeFragmentParameter parameter = smartCodeFragmentParameter;
                this.this$0.checkBounds(target, (KtExpression)expression, parameter);
                return null;
            }

            /*
             * WARNING - void declaration
             */
            public Void visitSuperExpression(KtSuperExpression expression, Unit data) {
                block2: {
                    void $this$getOrPut$iv;
                    Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                    KotlinType kotlinType = (KotlinType)CodeFragmentParameterAnalyzer.access$getBindingContext$p(this.this$0).get((ReadOnlySlice)BindingContext.THIS_TYPE_FOR_SUPER_EXPRESSION, (Object)expression);
                    if (kotlinType == null) {
                        return null;
                    }
                    KotlinType type2 = kotlinType;
                    ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
                    ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
                    if (classDescriptor == null) {
                        return null;
                    }
                    ClassDescriptor descriptor2 = classDescriptor;
                    Map map2 = CodeFragmentParameterAnalyzer.access$getParameters$p(this.this$0);
                    ClassDescriptor key$iv = descriptor2;
                    boolean $i$f$getOrPut = false;
                    V value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv != null) break block2;
                    boolean bl = false;
                    String string = descriptor2.getName().asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                    String name2 = string;
                    SmartCodeFragmentParameter answer$iv = new SmartCodeFragmentParameter(new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.DISPATCH_RECEIVER, "", "super@" + name2), type2, (DeclarationDescriptor)descriptor2, false, 8, null);
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                }
                return null;
            }

            public Void visitCallExpression(KtCallExpression expression, Unit data) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression), (BindingContext)CodeFragmentParameterAnalyzer.access$getBindingContext$p(this.this$0));
                if (resolvedCall != null) {
                    CallableDescriptor callableDescriptor = resolvedCall.getResultingDescriptor();
                    Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"getResultingDescriptor(...)");
                    CallableDescriptor descriptor2 = callableDescriptor;
                    if (descriptor2 instanceof ConstructorDescriptor && KotlinBuiltIns.isNothing((KotlinType)((ConstructorDescriptor)descriptor2).getReturnType())) {
                        throw EvaluateExceptionUtil.createEvaluateException((String)KotlinDebuggerEvaluationBundle.message("error.nothing.initialization", new Object[0]));
                    }
                }
                return (Void)super.visitCallExpression(expression, (Object)data);
            }

            private static final boolean processResolvedCall$lambda$1(KtSimpleNameExpression $expression) {
                return KtPsiUtilKt.isDotSelector((KtExpression)((KtExpression)$expression));
            }

            private static final void processResolvedCall$processImplicitReceiver(CodeFragmentParameterAnalyzer this$0, CallableDescriptor descriptor2, KtSimpleNameExpression $expression, Ref.BooleanRef processed, ReceiverValue receiver2) {
                SmartCodeFragmentParameter parameter;
                if (receiver2 instanceof ImplicitReceiver && !CodeFragmentParameterAnalyzer.access$isPrimaryConstructorParameter(this$0, (DeclarationDescriptor)descriptor2) && (parameter = CodeFragmentParameterAnalyzer.access$processReceiver(this$0, (ImplicitReceiver)receiver2)) != null) {
                    this$0.checkBounds(((ImplicitReceiver)receiver2).getDeclarationDescriptor(), (KtExpression)$expression, parameter);
                    processed.element = true;
                }
            }

            private static final KtReferenceExpression visitThisExpression$lambda$3(KtThisExpression $expression) {
                return $expression.getInstanceReference();
            }
        }, (Object)Unit.INSTANCE);
        Collection<SmartCodeFragmentParameter> collection = this.parameters.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return new K1CodeFragmentParameterInfo(CollectionsKt.toList((Iterable)collection), this.crossingBounds);
    }

    private final SmartCodeFragmentParameter processReceiver(ImplicitReceiver receiver2) {
        SmartCodeFragmentParameter smartCodeFragmentParameter;
        if (this.isCodeFragmentDeclaration(receiver2.getDeclarationDescriptor())) {
            return null;
        }
        ImplicitReceiver implicitReceiver = receiver2;
        if (implicitReceiver instanceof ImplicitClassReceiver) {
            smartCodeFragmentParameter = this.processDispatchReceiver(((ImplicitClassReceiver)receiver2).getClassDescriptor());
        } else if (implicitReceiver instanceof ExtensionReceiver) {
            CallableDescriptor callableDescriptor = ((ExtensionReceiver)receiver2).getDeclarationDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"<get-declarationDescriptor>(...)");
            KotlinType kotlinType = ((ExtensionReceiver)receiver2).getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            smartCodeFragmentParameter = this.processExtensionReceiver(callableDescriptor, kotlinType, null);
        } else if (implicitReceiver instanceof ContextReceiver) {
            CallableDescriptor callableDescriptor = ((ContextReceiver)receiver2).getDeclarationDescriptor();
            KotlinType kotlinType = ((ContextReceiver)receiver2).getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            smartCodeFragmentParameter = this.processContextReceiver(callableDescriptor, kotlinType);
        } else {
            smartCodeFragmentParameter = implicitReceiver instanceof ContextClassReceiver ? this.processDispatchReceiver(((ContextClassReceiver)receiver2).getClassDescriptor()) : null;
        }
        return smartCodeFragmentParameter;
    }

    /*
     * WARNING - void declaration
     */
    private final SmartCodeFragmentParameter processDispatchReceiver(ClassDescriptor descriptor2) {
        Object object;
        void $this$getOrPut$iv;
        if (descriptor2.getKind() == ClassKind.OBJECT) {
            return null;
        }
        SimpleType simpleType = descriptor2.getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getDefaultType(...)");
        SimpleType type2 = simpleType;
        Map map2 = this.parameters;
        ClassDescriptor key$iv = descriptor2;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Name name2 = descriptor2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getName(...)");
            Name name3 = name2;
            String debugLabel = name3.isSpecial() ? "" : "@" + name3.asString();
            SmartCodeFragmentParameter answer$iv = new SmartCodeFragmentParameter(new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.DISPATCH_RECEIVER, "", "this" + debugLabel), (KotlinType)type2, (DeclarationDescriptor)descriptor2, false, 8, null);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (SmartCodeFragmentParameter)object;
    }

    /*
     * WARNING - void declaration
     */
    private final SmartCodeFragmentParameter processExtensionReceiver(CallableDescriptor descriptor2, KotlinType receiverType, String label2) {
        Object object;
        void $this$getOrPut$iv;
        if (this.isFakeFunctionForJavaContext(descriptor2)) {
            return this.processFakeJavaCodeReceiver(descriptor2);
        }
        String string = label2;
        if (string == null) {
            string = this.getLabel(descriptor2);
        }
        String actualLabel = string;
        ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getExtensionReceiverParameter();
        if (receiverParameterDescriptor == null) {
            return null;
        }
        ReceiverParameterDescriptor receiverParameter = receiverParameterDescriptor;
        Map map2 = this.parameters;
        CallableDescriptor key$iv = descriptor2;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            SmartCodeFragmentParameter answer$iv = new SmartCodeFragmentParameter(new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.EXTENSION_RECEIVER, actualLabel, "this@" + actualLabel), receiverType, (DeclarationDescriptor)receiverParameter, false, 8, null);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (SmartCodeFragmentParameter)object;
    }

    private final String getLabel(CallableDescriptor callableDescriptor) {
        Object object;
        SourceElement sourceElement = callableDescriptor.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"getSource(...)");
        PsiElement source = PsiSourceElementKt.getPsi((SourceElement)sourceElement);
        if (source instanceof KtFunctionLiteral && (object = CodeFragmentParameterAnalyzerKt.getCallLabelForLambdaArgument((KtFunctionLiteral)source, this.bindingContext)) != null) {
            Object it = object;
            boolean bl = false;
            return it;
        }
        Name it = object = callableDescriptor.getName();
        boolean bl = false;
        return String.valueOf(!it.isSpecial() ? object : null);
    }

    private final boolean isFakeFunctionForJavaContext(CallableDescriptor descriptor2) {
        return descriptor2 instanceof FunctionDescriptor && Intrinsics.areEqual((Object)((FunctionDescriptor)descriptor2).getName().asString(), (Object)"_java_locals_debug_fun_") && this.codeFragment.getCopyableUserData(KtCodeFragment.Companion.getFAKE_CONTEXT_FOR_JAVA_FILE()) != null;
    }

    /*
     * WARNING - void declaration
     */
    private final SmartCodeFragmentParameter processContextReceiver(CallableDescriptor descriptor2, KotlinType receiverType) {
        Object object;
        void $this$getOrPut$iv;
        Object v1;
        block4: {
            List list2 = descriptor2.getContextReceiverParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getContextReceiverParameters(...)");
            Iterable iterable = list2;
            for (Object t : iterable) {
                ReceiverParameterDescriptor it = (ReceiverParameterDescriptor)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)receiverType)) continue;
                v1 = t;
                break block4;
            }
            v1 = null;
        }
        ReceiverParameterDescriptor receiverParameterDescriptor = v1;
        if (receiverParameterDescriptor == null) {
            return null;
        }
        ReceiverParameterDescriptor receiverParameter = receiverParameterDescriptor;
        Map map2 = this.parameters;
        ReceiverParameterDescriptor key$iv = receiverParameter;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            String string = receiverParameter.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            String name2 = string;
            FqName fqName2 = FqNameUtilKt.getFqName(receiverType);
            String label2 = ThisLabelUtilsKt.getThisName(String.valueOf(fqName2 != null ? fqName2.shortName() : null));
            SmartCodeFragmentParameter answer$iv = new SmartCodeFragmentParameter(new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.CONTEXT_RECEIVER, name2, label2), receiverType, (DeclarationDescriptor)receiverParameter, false, 8, null);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (SmartCodeFragmentParameter)object;
    }

    /*
     * WARNING - void declaration
     */
    private final SmartCodeFragmentParameter processFakeJavaCodeReceiver(CallableDescriptor descriptor2) {
        Object object;
        void $this$getOrPut$iv;
        CallableDescriptor callableDescriptor;
        CallableDescriptor callableDescriptor2;
        Object it = callableDescriptor2 = descriptor2;
        boolean bl = false;
        Object object2 = callableDescriptor = descriptor2 instanceof FunctionDescriptor ? callableDescriptor2 : null;
        if (callableDescriptor == null || (callableDescriptor2 = callableDescriptor.getExtensionReceiverParameter()) == null) {
            return null;
        }
        CallableDescriptor receiverParameter = callableDescriptor2;
        String label2 = "_java_locals_debug_fun_";
        KotlinType kotlinType = receiverParameter.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        KotlinType type2 = kotlinType;
        it = this.parameters;
        CallableDescriptor key$iv = descriptor2;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl2 = false;
            SmartCodeFragmentParameter answer$iv = new SmartCodeFragmentParameter(new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.FAKE_JAVA_OUTER_CLASS, label2, "this"), type2, (DeclarationDescriptor)receiverParameter, false, 8, null);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (SmartCodeFragmentParameter)object;
    }

    /*
     * WARNING - void declaration
     */
    private final SmartCodeFragmentParameter processSyntheticFieldVariable(SyntheticFieldDescriptor descriptor2) {
        Object object;
        void $this$getOrPut$iv;
        PropertyDescriptor propertyDescriptor = descriptor2.getPropertyDescriptor();
        String string = propertyDescriptor.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String fieldName = string;
        KotlinType kotlinType = propertyDescriptor.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        KotlinType type2 = kotlinType;
        Map map2 = this.parameters;
        SyntheticFieldDescriptor key$iv = descriptor2;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            SmartCodeFragmentParameter answer$iv = new SmartCodeFragmentParameter(new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.FIELD_VAR, fieldName, "field"), type2, (DeclarationDescriptor)descriptor2, false, 8, null);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (SmartCodeFragmentParameter)object;
    }

    /*
     * WARNING - void declaration
     */
    private final SmartCodeFragmentParameter processSimpleNameExpression(DeclarationDescriptor target, KtSimpleNameExpression expression) {
        SmartCodeFragmentParameter smartCodeFragmentParameter;
        if (target instanceof ValueParameterDescriptor && ((ValueParameterDescriptor)target).isCrossinline()) {
            throw EvaluateExceptionUtil.createEvaluateException((String)KotlinDebuggerEvaluationBundle.message("error.crossinline.lambda.evaluation", new Object[0]));
        }
        if (!this.isPrimaryConstructorParameter(target)) {
            return null;
        }
        DeclarationDescriptor declarationDescriptor = target;
        if (declarationDescriptor instanceof SimpleFunctionDescriptor) {
            Object object;
            void $this$getOrPut$iv;
            KotlinType kotlinType = FunctionsTypingVisitorKt.createFunctionType$default((SimpleFunctionDescriptor)((SimpleFunctionDescriptor)target), (KotlinBuiltIns)DescriptorUtilsKt.getBuiltIns((DeclarationDescriptor)target), (boolean)((SimpleFunctionDescriptor)target).isSuspend(), (boolean)false, (int)4, null);
            if (kotlinType == null) {
                return null;
            }
            KotlinType type2 = kotlinType;
            Map map2 = this.parameters;
            DeclarationDescriptor key$iv = target;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                String string = ((SimpleFunctionDescriptor)target).getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                CodeFragmentParameter.Dumb dumb = new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.LOCAL_FUNCTION, string, null, 4, null);
                SimpleFunctionDescriptor simpleFunctionDescriptor = ((SimpleFunctionDescriptor)target).getOriginal();
                Intrinsics.checkNotNullExpressionValue((Object)simpleFunctionDescriptor, (String)"getOriginal(...)");
                SmartCodeFragmentParameter answer$iv = new SmartCodeFragmentParameter(dumb, type2, (DeclarationDescriptor)simpleFunctionDescriptor, false, 8, null);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            smartCodeFragmentParameter = (SmartCodeFragmentParameter)object;
        } else if (declarationDescriptor instanceof ValueDescriptor) {
            Object object;
            void $this$getOrPut$iv;
            boolean bl;
            KtExpression unwrappedExpression;
            KtExpression ktExpression = unwrappedExpression = KtPsiUtil.deparenthesize((KtExpression)((KtExpression)expression));
            if (ktExpression != null) {
                KtExpression it = ktExpression;
                boolean bl2 = false;
                bl = this.isAssignmentLValue((PsiElement)it);
            } else {
                bl = false;
            }
            boolean isLValue = bl;
            Map key$iv = this.parameters;
            DeclarationDescriptor key$iv2 = target;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv2);
            if (value$iv == null) {
                boolean bl3 = false;
                CodeFragmentParameter.Kind kind2 = target instanceof LocalVariableDescriptor && ((LocalVariableDescriptor)target).isDelegated() ? CodeFragmentParameter.Kind.DELEGATED : CodeFragmentParameter.Kind.ORDINARY;
                String string = ((ValueDescriptor)target).getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                CodeFragmentParameter.Dumb dumb = new CodeFragmentParameter.Dumb(kind2, string, null, 4, null);
                KotlinType kotlinType = ((ValueDescriptor)target).getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
                SmartCodeFragmentParameter answer$iv = new SmartCodeFragmentParameter(dumb, kotlinType, target, isLValue);
                $this$getOrPut$iv.put(key$iv2, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            smartCodeFragmentParameter = (SmartCodeFragmentParameter)object;
        } else {
            smartCodeFragmentParameter = null;
        }
        return smartCodeFragmentParameter;
    }

    private final boolean isPrimaryConstructorParameter(DeclarationDescriptor target) {
        DeclarationDescriptorWithVisibility declarationDescriptorWithVisibility = target instanceof DeclarationDescriptorWithVisibility ? (DeclarationDescriptorWithVisibility)target : null;
        boolean isLocalTarget = Intrinsics.areEqual((Object)(declarationDescriptorWithVisibility != null ? declarationDescriptorWithVisibility.getVisibility() : null), (Object)DescriptorVisibilities.LOCAL);
        boolean isPrimaryConstructorParameter = !isLocalTarget && target instanceof PropertyDescriptor && this.isContainingPrimaryConstructorParameter((PropertyDescriptor)target);
        return isLocalTarget || isPrimaryConstructorParameter;
    }

    private final boolean isAssignmentLValue(PsiElement expression) {
        Object object;
        block3: {
            block2: {
                KtBinaryExpression ktBinaryExpression;
                PsiElement psiElement = expression.getParent();
                object = psiElement instanceof KtBinaryExpression ? (KtBinaryExpression)psiElement : null;
                if (object == null) break block2;
                KtBinaryExpression it = ktBinaryExpression = object;
                boolean bl = false;
                object = KtPsiUtil.isAssignment((PsiElement)((PsiElement)it)) ? ktBinaryExpression : null;
                if (object != null) break block3;
            }
            return false;
        }
        KtBinaryExpression assignmentExpression = object;
        return Intrinsics.areEqual((Object)assignmentExpression.getLeft(), (Object)expression);
    }

    private final boolean isContainingPrimaryConstructorParameter(PropertyDescriptor target) {
        ConstructorDescriptor constructorDescriptor = this.getContainingPrimaryConstructor();
        if (constructorDescriptor == null) {
            return false;
        }
        ConstructorDescriptor primaryConstructor = constructorDescriptor;
        for (ValueParameterDescriptor parameter : primaryConstructor.getValueParameters()) {
            PropertyDescriptor property = (PropertyDescriptor)this.bindingContext.get((ReadOnlySlice)BindingContext.VALUE_PARAMETER_AS_PROPERTY, (Object)parameter);
            if (!Intrinsics.areEqual((Object)target, (Object)property)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final SmartCodeFragmentParameter processCoroutineContextCall(DeclarationDescriptor target) {
        if (target instanceof PropertyDescriptor && Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)target), (Object)CoroutineCallCheckerKt.getCOROUTINE_CONTEXT_FQ_NAME())) {
            Object object;
            void $this$getOrPut$iv;
            Map map2 = this.parameters;
            DeclarationDescriptor key$iv = target;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                CodeFragmentParameter.Dumb dumb = new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.COROUTINE_CONTEXT, "", null, 4, null);
                KotlinType kotlinType = ((PropertyDescriptor)target).getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
                SmartCodeFragmentParameter answer$iv = new SmartCodeFragmentParameter(dumb, kotlinType, target, false, 8, null);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return (SmartCodeFragmentParameter)object;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final SmartCodeFragmentParameter processForeignProperty(DeclarationDescriptor target) {
        Object object;
        void $this$getOrPut$iv;
        ForeignPropertyDescriptor foreignPropertyDescriptor = target instanceof ForeignPropertyDescriptor ? (ForeignPropertyDescriptor)target : null;
        if (foreignPropertyDescriptor == null) {
            return null;
        }
        ForeignPropertyDescriptor descriptor2 = foreignPropertyDescriptor;
        Map map2 = this.parameters;
        DeclarationDescriptor key$iv = target;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            CodeFragmentParameter.Dumb dumb = new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.FOREIGN_VALUE, descriptor2.getPropertyName(), null, 4, null);
            KotlinType kotlinType = descriptor2.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            SmartCodeFragmentParameter answer$iv = new SmartCodeFragmentParameter(dumb, kotlinType, (DeclarationDescriptor)descriptor2, false, 8, null);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (SmartCodeFragmentParameter)object;
    }

    public final void checkBounds(@Nullable DeclarationDescriptor descriptor2, @NotNull KtExpression expression, @Nullable SmartCodeFragmentParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (parameter == null || !(descriptor2 instanceof DeclarationDescriptorWithSource)) {
            return;
        }
        SourceElement sourceElement = ((DeclarationDescriptorWithSource)descriptor2).getSource();
        Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"getSource(...)");
        PsiElement targetPsi = PsiSourceElementKt.getPsi((SourceElement)sourceElement);
        if (targetPsi != null && this.doesCrossInlineBounds((PsiElement)expression, targetPsi)) {
            ((Collection)this.crossingBounds).add(parameter.getDumb());
        }
    }

    private final boolean doesCrossInlineBounds(PsiElement expression, PsiElement declaration) {
        Object object;
        PsiElement declarationCommonParent;
        block7: {
            block6: {
                PsiElement psiElement;
                PsiElement psiElement2 = CodeFragmentParameterAnalyzer.doesCrossInlineBounds$findCommonParent(declaration);
                if (psiElement2 == null) {
                    return false;
                }
                declarationCommonParent = psiElement2;
                object = expression.getParent();
                if (object == null) break block6;
                PsiElement it = psiElement = object;
                boolean bl = false;
                object = this.isInside(it, declarationCommonParent) ? psiElement : null;
                if (object != null) break block7;
            }
            return false;
        }
        PsiElement currentParent = object;
        while (currentParent != null && !Intrinsics.areEqual((Object)currentParent, (Object)declarationCommonParent)) {
            SimpleFunctionDescriptor functionDescriptor;
            if (currentParent instanceof KtFunction && (functionDescriptor = (SimpleFunctionDescriptor)this.bindingContext.get((ReadOnlySlice)BindingContext.FUNCTION, (Object)currentParent)) != null && !functionDescriptor.isInline()) {
                return true;
            }
            currentParent = currentParent instanceof KtCodeFragment ? ((KtCodeFragment)currentParent).getContext() : currentParent.getParent();
        }
        return false;
    }

    private final boolean isCodeFragmentDeclaration(DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof ValueParameterDescriptor && this.isCodeFragmentDeclaration((DeclarationDescriptor)((ValueParameterDescriptor)descriptor2).getContainingDeclaration())) {
            return true;
        }
        if (!(descriptor2 instanceof DeclarationDescriptorWithSource)) {
            return false;
        }
        SourceElement sourceElement = ((DeclarationDescriptorWithSource)descriptor2).getSource();
        Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"getSource(...)");
        PsiElement psiElement = PsiSourceElementKt.getPsi((SourceElement)sourceElement);
        return (psiElement != null ? psiElement.getContainingFile() : null) instanceof KtCodeFragment;
    }

    private final boolean isInside(PsiElement $this$isInside, PsiElement parent2) {
        CodeFragmentParameterAnalyzer codeFragmentParameterAnalyzer = this;
        while (!PsiUtilsKt.isAncestor$default((PsiElement)parent2, (PsiElement)$this$isInside, (boolean)false, (int)2, null)) {
            PsiFile psiFile = $this$isInside.getContainingFile();
            KtCodeFragment ktCodeFragment = psiFile instanceof KtCodeFragment ? (KtCodeFragment)psiFile : null;
            if (ktCodeFragment == null || (ktCodeFragment = ktCodeFragment.getContext()) == null) {
                return false;
            }
            KtCodeFragment context = ktCodeFragment;
            CodeFragmentParameterAnalyzer codeFragmentParameterAnalyzer2 = codeFragmentParameterAnalyzer;
            psiFile = parent2;
            codeFragmentParameterAnalyzer = codeFragmentParameterAnalyzer2;
            $this$isInside = context;
            parent2 = psiFile;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final ConstructorDescriptor containingPrimaryConstructor_delegate$lambda$1(CodeFragmentParameterAnalyzer this$0) {
        PsiElement psiElement;
        block7: {
            block6: {
                void $this$getParentOfType$iv;
                Comparable<Location> comparable;
                block5: {
                    block4: {
                        Comparable<Location> comparable2 = SafeUtilKt.safeLocation((StackFrameProxy)this$0.context.getFrameProxy());
                        if (comparable2 == null || (comparable2 = SafeUtilKt.safeMethod((Location)comparable2)) == null) break block4;
                        Comparable<Location> it = comparable = comparable2;
                        boolean bl = false;
                        comparable2 = it.isConstructor() ? comparable : null;
                        if (comparable2 != null) break block5;
                    }
                    return null;
                }
                psiElement = this$0.codeFragment.getContext();
                if (psiElement == null) break block6;
                comparable = psiElement;
                boolean strict$iv = false;
                boolean $i$f$getParentOfType = false;
                psiElement = (KtPrimaryConstructor)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtPrimaryConstructor.class, (boolean)strict$iv);
                if (psiElement != null) break block7;
            }
            return null;
        }
        PsiElement constructor = psiElement;
        return (ConstructorDescriptor)this$0.bindingContext.get((ReadOnlySlice)BindingContext.CONSTRUCTOR, (Object)constructor);
    }

    /*
     * WARNING - void declaration
     */
    private static final PsiElement doesCrossInlineBounds$findCommonParent(PsiElement declaration) {
        PsiElement psiElement;
        PsiElement declarationParent = declaration.getParent();
        if (declarationParent instanceof KtDestructuringDeclaration) {
            void $this$getParentOfType$iv;
            PsiElement psiElement2 = declarationParent;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            psiElement = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtBlockExpression.class, (boolean)strict$iv);
        } else if (declarationParent instanceof KtParameterList && ((KtParameterList)declarationParent).getParent() instanceof KtPrimaryConstructor) {
            PsiElement $this$getParentOfType$iv = declaration;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            psiElement = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtClass.class, (boolean)strict$iv);
        } else {
            psiElement = declarationParent instanceof KtParameterList && ((KtParameterList)declarationParent).getParent() instanceof KtFunction ? ((KtParameterList)declarationParent).getParent() : declarationParent;
        }
        return psiElement;
    }

    public static final /* synthetic */ BindingContext access$getBindingContext$p(CodeFragmentParameterAnalyzer $this) {
        return $this.bindingContext;
    }

    public static final /* synthetic */ SmartCodeFragmentParameter access$processCoroutineContextCall(CodeFragmentParameterAnalyzer $this, DeclarationDescriptor target) {
        return $this.processCoroutineContextCall(target);
    }

    public static final /* synthetic */ boolean access$isCodeFragmentDeclaration(CodeFragmentParameterAnalyzer $this, DeclarationDescriptor descriptor2) {
        return $this.isCodeFragmentDeclaration(descriptor2);
    }

    public static final /* synthetic */ SmartCodeFragmentParameter access$processSyntheticFieldVariable(CodeFragmentParameterAnalyzer $this, SyntheticFieldDescriptor descriptor2) {
        return $this.processSyntheticFieldVariable(descriptor2);
    }

    public static final /* synthetic */ SmartCodeFragmentParameter access$processForeignProperty(CodeFragmentParameterAnalyzer $this, DeclarationDescriptor target) {
        return $this.processForeignProperty(target);
    }

    public static final /* synthetic */ SmartCodeFragmentParameter access$processSimpleNameExpression(CodeFragmentParameterAnalyzer $this, DeclarationDescriptor target, KtSimpleNameExpression expression) {
        return $this.processSimpleNameExpression(target, expression);
    }

    public static final /* synthetic */ SmartCodeFragmentParameter access$processDispatchReceiver(CodeFragmentParameterAnalyzer $this, ClassDescriptor descriptor2) {
        return $this.processDispatchReceiver(descriptor2);
    }

    public static final /* synthetic */ SmartCodeFragmentParameter access$processContextReceiver(CodeFragmentParameterAnalyzer $this, CallableDescriptor descriptor2, KotlinType receiverType) {
        return $this.processContextReceiver(descriptor2, receiverType);
    }

    public static final /* synthetic */ SmartCodeFragmentParameter access$processExtensionReceiver(CodeFragmentParameterAnalyzer $this, CallableDescriptor descriptor2, KotlinType receiverType, String label2) {
        return $this.processExtensionReceiver(descriptor2, receiverType, label2);
    }

    public static final /* synthetic */ LinkedHashMap access$getParameters$p(CodeFragmentParameterAnalyzer $this) {
        return $this.parameters;
    }

    public static final /* synthetic */ boolean access$isPrimaryConstructorParameter(CodeFragmentParameterAnalyzer $this, DeclarationDescriptor target) {
        return $this.isPrimaryConstructorParameter(target);
    }

    public static final /* synthetic */ SmartCodeFragmentParameter access$processReceiver(CodeFragmentParameterAnalyzer $this, ImplicitReceiver receiver2) {
        return $this.processReceiver(receiver2);
    }
}

