/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.stepping;

import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.VMDisconnectedException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.core.stepping.CoroutineBreakpointFacilityKt;
import org.jetbrains.kotlin.idea.debugger.core.stepping.KotlinMethodFilter;
import org.jetbrains.kotlin.idea.debugger.core.stepping.KotlinRequestHintKt;
import org.jetbrains.kotlin.idea.debugger.core.stepping.KotlinSteppingCommandProviderKt;
import org.jetbrains.kotlin.idea.debugger.core.stepping.filter.KotlinStepOverParamDefaultImplsMethodFilterKt;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinStepOverRequestHint;", "Lcom/intellij/debugger/engine/RequestHint;", "stepThread", "Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "filter", "Lorg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinMethodFilter;", "parentHint", "stepSize", "", "<init>", "(Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;Lcom/intellij/debugger/engine/SuspendContextImpl;Lorg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinMethodFilter;Lcom/intellij/debugger/engine/RequestHint;I)V", "startLocation", "Lorg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinStepOverRequestHint$LocationData;", "hasBeenAtSuspensionSwitcher", "", "getNextStepDepth", "context", "isSteppedFromDefaultParamsOriginal", "location", "Lcom/sun/jdi/Location;", "Companion", "LocationData", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nKotlinRequestHint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinRequestHint.kt\norg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinStepOverRequestHint\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,320:1\n1#2:321\n*E\n"})
public final class KotlinStepOverRequestHint
extends RequestHint {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final KotlinMethodFilter filter;
    @Nullable
    private final LocationData startLocation;
    private boolean hasBeenAtSuspensionSwitcher;
    @NotNull
    private static final Logger LOG;

    public KotlinStepOverRequestHint(@NotNull ThreadReferenceProxyImpl stepThread, @NotNull SuspendContextImpl suspendContext, @NotNull KotlinMethodFilter filter2, @Nullable RequestHint parentHint, int stepSize) {
        Intrinsics.checkNotNullParameter((Object)stepThread, (String)"stepThread");
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        super(stepThread, suspendContext, stepSize, 2, (MethodFilter)filter2, parentHint);
        this.filter = filter2;
        this.startLocation = LocationData.Companion.create(CoroutineBreakpointFacilityKt.getLocationCompat(suspendContext));
    }

    public int getNextStepDepth(@NotNull SuspendContextImpl context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            StackFrameProxyImpl stackFrameProxyImpl = context.getFrameProxy();
            if (stackFrameProxyImpl == null) {
                return 0;
            }
            StackFrameProxyImpl frameProxy = stackFrameProxyImpl;
            if (this.isTheSameFrame(context)) {
                if (DebuggerUtil.isOnSuspensionPoint(frameProxy)) {
                    this.setIgnoreFilters(true);
                    this.hasBeenAtSuspensionSwitcher = true;
                    return 2;
                }
                Location location = SafeUtilKt.safeLocation((StackFrameProxy)frameProxy);
                boolean isAcceptable = location != null && this.filter.locationMatches(context, location);
                return isAcceptable ? 0 : 2;
            }
            if (this.isSteppedOut()) {
                Method method;
                if (this.hasBeenAtSuspensionSwitcher) {
                    return -100;
                }
                Location location = SafeUtilKt.safeLocation((StackFrameProxy)frameProxy);
                if (KotlinRequestHintKt.access$needTechnicalStepInto(context)) {
                    return 1;
                }
                Integer isAcceptable = this.processSteppingFilters(context, location);
                if (isAcceptable != null) {
                    int it = ((Number)isAcceptable).intValue();
                    boolean bl = false;
                    return it;
                }
                Location location2 = location;
                Method method2 = method = location2 != null ? SafeUtilKt.safeMethod(location2) : null;
                if (method != null && KotlinSteppingCommandProviderKt.isSyntheticMethodForDefaultParameters(method) && this.isSteppedFromDefaultParamsOriginal(location)) {
                    return 2;
                }
                Location location3 = location;
                int lineNumber = location3 != null ? SafeUtilKt.safeLineNumber(location3, "Java") : -1;
                return lineNumber >= 0 ? 0 : 2;
            }
            return 3;
        }
        catch (VMDisconnectedException frameProxy) {
        }
        catch (EvaluateException e) {
            LOG.error((Throwable)e);
        }
        return 0;
    }

    private final boolean isSteppedFromDefaultParamsOriginal(Location location) {
        LocationData locationData = this.startLocation;
        if (locationData == null) {
            return false;
        }
        LocationData startLocation = locationData;
        LocationData locationData2 = LocationData.Companion.create(location);
        if (locationData2 == null) {
            return false;
        }
        LocationData endLocation = locationData2;
        if (!Intrinsics.areEqual((Object)startLocation.getDeclaringType(), (Object)endLocation.getDeclaringType())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)(startLocation.getMethod() + "$default"), (Object)endLocation.getMethod())) {
            return false;
        }
        return KotlinStepOverParamDefaultImplsMethodFilterKt.matchesDefaultMethodSignature(endLocation.getSignature(), startLocation.getSignature(), KotlinStepOverParamDefaultImplsMethodFilterKt.isSyntheticDefaultMethodPossiblyConvertedToStatic(location), Intrinsics.areEqual((Object)startLocation.getMethod(), (Object)"<init>"));
    }

    static {
        Logger logger = Logger.getInstance(KotlinStepOverRequestHint.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinStepOverRequestHint$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.jvm-debugger.core"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinStepOverRequestHint$LocationData;", "", "method", "", "signature", "Lorg/jetbrains/org/objectweb/asm/Type;", "declaringType", "<init>", "(Ljava/lang/String;Lorg/jetbrains/org/objectweb/asm/Type;Ljava/lang/String;)V", "getMethod", "()Ljava/lang/String;", "getSignature", "()Lorg/jetbrains/org/objectweb/asm/Type;", "getDeclaringType", "Companion", "kotlin.jvm-debugger.core"})
    private static final class LocationData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String method;
        @NotNull
        private final Type signature;
        @NotNull
        private final String declaringType;

        public LocationData(@NotNull String method, @NotNull Type signature, @NotNull String declaringType) {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            Intrinsics.checkNotNullParameter((Object)declaringType, (String)"declaringType");
            this.method = method;
            this.signature = signature;
            this.declaringType = declaringType;
        }

        @NotNull
        public final String getMethod() {
            return this.method;
        }

        @NotNull
        public final Type getSignature() {
            return this.signature;
        }

        @NotNull
        public final String getDeclaringType() {
            return this.declaringType;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinStepOverRequestHint$LocationData$Companion;", "", "<init>", "()V", "create", "Lorg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinStepOverRequestHint$LocationData;", "location", "Lcom/sun/jdi/Location;", "kotlin.jvm-debugger.core"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final LocationData create(@Nullable Location location) {
                Comparable<Location> comparable = location;
                if (comparable == null || (comparable = SafeUtilKt.safeMethod((Location)comparable)) == null) {
                    return null;
                }
                Comparable<Location> method = comparable;
                Type signature = Type.getMethodType((String)method.signature());
                String string = method.name();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
                Intrinsics.checkNotNull((Object)signature);
                String string2 = location.declaringType().name();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name(...)");
                return new LocationData(string, signature, string2);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

