/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceFile;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.WhenMissingCase;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirEnumWhenTrackerComponent;
import org.jetbrains.kotlin.fir.FirEnumWhenTrackerComponentKt;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.expressions.ExhaustivenessStatus;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirElseIfTrueCondition;
import org.jetbrains.kotlin.fir.resolve.BodyResolveComponents;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenExhaustivenessChecker;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenOnBooleanExhaustivenessChecker;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenOnEnumExhaustivenessChecker;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenOnNothingExhaustivenessChecker;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenOnNullableExhaustivenessChecker;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenOnSealedClassExhaustivenessChecker;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenSelfTypeExhaustivenessChecker;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeDynamicType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeRigidType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirTransformer;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.types.TypeApproximatorConfiguration;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0001\u001dB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J)\u0010\u0007\u001a\u0002H\b\"\b\b\u0000\u0010\b*\u00020\t2\u0006\u0010\n\u001a\u0002H\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0010H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\"\u0010\u0019\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e\u00b2\u0006\n\u0010\u001f\u001a\u00020\u0016X\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer;", "Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;", "", "bodyResolveComponents", "Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;)V", "transformElement", "E", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "data", "(Lorg/jetbrains/kotlin/fir/FirElement;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/FirElement;", "transformWhenExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "whenExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "processExhaustivenessCheck", "", "hasElseBranch", "", "computeExhaustivenessStatus", "Lorg/jetbrains/kotlin/fir/expressions/ExhaustivenessStatus;", "subjectType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "computeStatusForNonIntersectionType", "unwrappedSubjectType", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "Companion", "resolve", "minimumStatus"})
@SourceDebugExtension(value={"SMAP\nFirWhenExhaustivenessTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirWhenExhaustivenessTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,626:1\n1761#2,3:627\n48#3:630\n*S KotlinDebug\n*F\n+ 1 FirWhenExhaustivenessTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer\n*L\n193#1:627,3\n212#1:630\n*E\n"})
public final class FirWhenExhaustivenessTransformer
extends FirTransformer<Object> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BodyResolveComponents bodyResolveComponents;
    @NotNull
    private static final List<WhenExhaustivenessChecker> exhaustivenessCheckers;

    public FirWhenExhaustivenessTransformer(@NotNull BodyResolveComponents bodyResolveComponents2) {
        Intrinsics.checkNotNullParameter((Object)bodyResolveComponents2, (String)"bodyResolveComponents");
        this.bodyResolveComponents = bodyResolveComponents2;
    }

    @Override
    @NotNull
    public <E extends FirElement> E transformElement(@NotNull E element, @Nullable Object data) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        throw new IllegalArgumentException("Should not be there");
    }

    @Override
    @NotNull
    public FirStatement transformWhenExpression(@NotNull FirWhenExpression whenExpression, @Nullable Object data) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)whenExpression, (String)"whenExpression");
            this.processExhaustivenessCheck(whenExpression);
            FirEnumWhenTrackerComponent firEnumWhenTrackerComponent = FirEnumWhenTrackerComponentKt.getEnumWhenTracker(this.bodyResolveComponents.getSession());
            if (firEnumWhenTrackerComponent == null) break block0;
            KtSourceFile ktSourceFile = this.bodyResolveComponents.getFile().getSourceFile();
            ConeKotlinType coneKotlinType = FirWhenExhaustivenessTransformer.Companion.getSubjectType(this.bodyResolveComponents.getSession(), whenExpression);
            FirEnumWhenTrackerComponentKt.reportEnumUsageInWhen(firEnumWhenTrackerComponent, ktSourceFile != null ? ktSourceFile.getPath() : null, coneKotlinType != null ? FirWhenExhaustivenessTransformer.Companion.minimumBoundIfFlexible(coneKotlinType, this.bodyResolveComponents.getSession()) : null);
        }
        return whenExpression;
    }

    private final void processExhaustivenessCheck(FirWhenExpression whenExpression) {
        FirSession session = this.bodyResolveComponents.getSession();
        ConeKotlinType subjectType = FirWhenExhaustivenessTransformer.Companion.getSubjectType(session, whenExpression);
        if (subjectType == null) {
            whenExpression.replaceExhaustivenessStatus(this.hasElseBranch(whenExpression) ? (ExhaustivenessStatus)ExhaustivenessStatus.ProperlyExhaustive.INSTANCE : (ExhaustivenessStatus)ExhaustivenessStatus.NotExhaustive.Companion.noElseBranch(null));
            return;
        }
        ConeRigidType minimumBound = FirWhenExhaustivenessTransformer.Companion.minimumBoundIfFlexible(subjectType, session);
        Lazy minimumStatus$delegate = LazyKt.lazy(() -> FirWhenExhaustivenessTransformer.processExhaustivenessCheck$lambda$0(this, whenExpression, minimumBound));
        ExhaustivenessStatus status = this.hasElseBranch(whenExpression) ? (Intrinsics.areEqual((Object)FirWhenExhaustivenessTransformer.processExhaustivenessCheck$computeUpperBoundStatus(subjectType, minimumBound, this, whenExpression, (Lazy<? extends ExhaustivenessStatus>)minimumStatus$delegate), (Object)ExhaustivenessStatus.ProperlyExhaustive.INSTANCE) ? (ExhaustivenessStatus)ExhaustivenessStatus.RedundantlyExhaustive.INSTANCE : (ExhaustivenessStatus)ExhaustivenessStatus.ProperlyExhaustive.INSTANCE) : FirWhenExhaustivenessTransformer.processExhaustivenessCheck$lambda$1((Lazy<? extends ExhaustivenessStatus>)minimumStatus$delegate);
        whenExpression.replaceExhaustivenessStatus(status);
    }

    private final boolean hasElseBranch(FirWhenExpression $this$hasElseBranch) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = $this$hasElseBranch.getBranches();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirWhenBranch it = (FirWhenBranch)element$iv;
                    boolean bl2 = false;
                    if (!(it.getCondition() instanceof FirElseIfTrueCondition)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final ExhaustivenessStatus computeExhaustivenessStatus(FirWhenExpression whenExpression, ConeKotlinType subjectType) {
        ExhaustivenessStatus exhaustivenessStatus;
        ConeKotlinType approximatedType;
        FirSession session = this.bodyResolveComponents.getSession();
        ConeKotlinType coneKotlinType = TypeComponentsKt.getTypeApproximator(session).approximateToSuperType(subjectType, (TypeApproximatorConfiguration)TypeApproximatorConfiguration.FinalApproximationAfterResolutionAndInference.INSTANCE);
        if (coneKotlinType == null) {
            coneKotlinType = approximatedType = subjectType;
        }
        if (whenExpression.getBranches().isEmpty() && ConeBuiltinTypeUtilsKt.isNothing(approximatedType)) {
            return ExhaustivenessStatus.ExhaustiveAsNothing.INSTANCE;
        }
        ExhaustivenessStatus status = null;
        Collection unwrappedIntersectionTypes = FirWhenExhaustivenessTransformer.Companion.unwrapTypeParameterAndIntersectionTypes(approximatedType, session);
        for (ConeKotlinType unwrappedSubjectType : unwrappedIntersectionTypes) {
            boolean bl;
            FirRegularClassSymbol firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol(unwrappedSubjectType, session);
            if (firRegularClassSymbol != null) {
                FirClassLikeSymbol $this$isExpect$iv = firRegularClassSymbol;
                boolean $i$f$isExpect = false;
                bl = $this$isExpect$iv.getRawStatus().isExpect();
            } else {
                bl = false;
            }
            if (bl && !Intrinsics.areEqual((Object)ConeTypeUtilsKt.getClassId(unwrappedSubjectType), (Object)StandardClassIds.INSTANCE.getBoolean())) continue;
            ExhaustivenessStatus localStatus = this.computeStatusForNonIntersectionType(unwrappedSubjectType, session, whenExpression);
            if (localStatus == ExhaustivenessStatus.ProperlyExhaustive.INSTANCE) {
                status = localStatus;
                break;
            }
            if (status != null || localStatus == null) continue;
            status = localStatus;
        }
        if ((exhaustivenessStatus = status) == null) {
            exhaustivenessStatus = ExhaustivenessStatus.NotExhaustive.Companion.noElseBranch(approximatedType);
        }
        return exhaustivenessStatus;
    }

    private final ExhaustivenessStatus computeStatusForNonIntersectionType(ConeKotlinType unwrappedSubjectType, FirSession session, FirWhenExpression whenExpression) {
        List checkers = FirWhenExhaustivenessTransformer.Companion.getCheckers(unwrappedSubjectType, session);
        if (checkers.isEmpty()) {
            return null;
        }
        List whenMissingCases = new ArrayList();
        FirWhenExhaustivenessTransformer.Companion.collectMissingCases(whenMissingCases, checkers, whenExpression, unwrappedSubjectType, session);
        return whenMissingCases.isEmpty() ? (ExhaustivenessStatus)ExhaustivenessStatus.ProperlyExhaustive.INSTANCE : (ExhaustivenessStatus)new ExhaustivenessStatus.NotExhaustive(whenMissingCases, unwrappedSubjectType);
    }

    private static final ExhaustivenessStatus processExhaustivenessCheck$lambda$0(FirWhenExhaustivenessTransformer this$0, FirWhenExpression $whenExpression, ConeRigidType $minimumBound) {
        return this$0.computeExhaustivenessStatus($whenExpression, $minimumBound);
    }

    private static final ExhaustivenessStatus processExhaustivenessCheck$lambda$1(Lazy<? extends ExhaustivenessStatus> $minimumStatus$delegate) {
        Lazy<? extends ExhaustivenessStatus> lazy = $minimumStatus$delegate;
        return (ExhaustivenessStatus)lazy.getValue();
    }

    private static final ExhaustivenessStatus processExhaustivenessCheck$computeUpperBoundStatus(ConeKotlinType subjectType, ConeRigidType minimumBound, FirWhenExhaustivenessTransformer this$0, FirWhenExpression $whenExpression, Lazy<? extends ExhaustivenessStatus> minimumStatus$delegate) {
        ConeRigidType upperBound = ConeTypeUtilsKt.upperBoundIfFlexible(subjectType);
        if (Intrinsics.areEqual((Object)upperBound, (Object)minimumBound)) {
            return FirWhenExhaustivenessTransformer.processExhaustivenessCheck$lambda$1(minimumStatus$delegate);
        }
        return this$0.computeExhaustivenessStatus($whenExpression, upperBound);
    }

    static {
        Object[] objectArray = new WhenExhaustivenessChecker[]{WhenOnBooleanExhaustivenessChecker.INSTANCE, WhenOnEnumExhaustivenessChecker.INSTANCE, WhenOnSealedClassExhaustivenessChecker.INSTANCE, WhenOnNothingExhaustivenessChecker.INSTANCE};
        exhaustivenessCheckers = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0010!\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012*\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J8\u0010\u0015\u001a\u00020\u0016*\b\u0012\u0004\u0012\u00020\b0\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer$Companion;", "", "<init>", "()V", "exhaustivenessCheckers", "", "Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenExhaustivenessChecker;", "computeAllMissingCases", "Lorg/jetbrains/kotlin/diagnostics/WhenMissingCase;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "whenExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "getSubjectType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "minimumBoundIfFlexible", "Lorg/jetbrains/kotlin/fir/types/ConeRigidType;", "unwrapTypeParameterAndIntersectionTypes", "", "getCheckers", "subjectType", "collectMissingCases", "", "", "checkers", "resolve"})
    @SourceDebugExtension(value={"SMAP\nFirWhenExhaustivenessTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirWhenExhaustivenessTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,626:1\n1#2:627\n1460#3,5:628\n1563#3:633\n1634#3,3:634\n865#3,2:637\n*S KotlinDebug\n*F\n+ 1 FirWhenExhaustivenessTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer$Companion\n*L\n91#1:628,5\n98#1:633\n98#1:634,3\n108#1:637,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<WhenMissingCase> computeAllMissingCases(@NotNull FirSession session, @NotNull FirWhenExpression whenExpression) {
            List list2;
            Intrinsics.checkNotNullParameter((Object)((Object)session), (String)"session");
            Intrinsics.checkNotNullParameter((Object)whenExpression, (String)"whenExpression");
            ConeKotlinType coneKotlinType = this.getSubjectType(session, whenExpression);
            if (coneKotlinType == null || (coneKotlinType = this.minimumBoundIfFlexible(coneKotlinType, session)) == null) {
                return ExhaustivenessStatus.NotExhaustive.Companion.getNO_ELSE_BRANCH_REASONS();
            }
            ConeKotlinType subjectType = coneKotlinType;
            List $this$computeAllMissingCases_u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
            boolean bl = false;
            for (ConeKotlinType type2 : Companion.unwrapTypeParameterAndIntersectionTypes(subjectType, session)) {
                List<WhenExhaustivenessChecker> checkers = Companion.getCheckers(type2, session);
                Companion.collectMissingCases($this$computeAllMissingCases_u24lambda_u240, checkers, whenExpression, type2, session);
            }
            return CollectionsKt.build((List)list2);
        }

        private final ConeKotlinType getSubjectType(FirSession session, FirWhenExpression whenExpression) {
            Object object;
            block6: {
                FirPureAbstractElement firPureAbstractElement;
                block5: {
                    FirVariable firVariable;
                    object = whenExpression.getSubjectVariable();
                    if (object == null) break block5;
                    FirVariable it = firVariable = object;
                    boolean bl = false;
                    object = !FirExpressionUtilKt.isImplicitWhenSubjectVariable(it) ? firVariable : null;
                    if (object != null && (object = ((FirVariable)object).getReturnTypeRef()) != null && (object = FirTypeUtilsKt.getConeType((FirTypeRef)object)) != null) break block6;
                }
                if ((firPureAbstractElement = whenExpression.getSubjectVariable()) != null && (firPureAbstractElement = firPureAbstractElement.getInitializer()) != null) {
                    object = FirTypeUtilsKt.getResolvedType((FirExpression)firPureAbstractElement);
                } else {
                    return null;
                }
            }
            Object subjectType = object;
            return TypeExpansionUtilsKt.fullyExpandedType$default((ConeKotlinType)subjectType, session, null, 2, null);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final ConeRigidType minimumBoundIfFlexible(ConeKotlinType $this$minimumBoundIfFlexible, FirSession session) {
            ConeRigidType coneRigidType;
            ConeKotlinType coneKotlinType = $this$minimumBoundIfFlexible;
            if (coneKotlinType instanceof ConeDynamicType) {
                boolean bl = FirLanguageSettingsComponentKt.getLanguageVersionSettings(session).supportsFeature(LanguageFeature.ImprovedExhaustivenessChecksIn21);
                if (bl) {
                    coneRigidType = ((ConeDynamicType)$this$minimumBoundIfFlexible).getUpperBound();
                    return coneRigidType;
                } else {
                    if (bl) throw new NoWhenBranchMatchedException();
                    coneRigidType = ((ConeDynamicType)$this$minimumBoundIfFlexible).getLowerBound();
                }
                return coneRigidType;
            } else if (coneKotlinType instanceof ConeFlexibleType) {
                coneRigidType = ((ConeFlexibleType)$this$minimumBoundIfFlexible).getLowerBound();
                return coneRigidType;
            } else {
                if (!(coneKotlinType instanceof ConeRigidType)) throw new NoWhenBranchMatchedException();
                coneRigidType = (ConeRigidType)$this$minimumBoundIfFlexible;
            }
            return coneRigidType;
        }

        /*
         * WARNING - void declaration
         */
        private final Collection<ConeKotlinType> unwrapTypeParameterAndIntersectionTypes(ConeKotlinType $this$unwrapTypeParameterAndIntersectionTypes, FirSession session) {
            Collection collection;
            if ($this$unwrapTypeParameterAndIntersectionTypes instanceof ConeIntersectionType) {
                collection = ((ConeIntersectionType)$this$unwrapTypeParameterAndIntersectionTypes).getIntersectedTypes();
            } else if ($this$unwrapTypeParameterAndIntersectionTypes instanceof ConeTypeParameterType && FirLanguageSettingsComponentKt.getLanguageVersionSettings(session).supportsFeature(LanguageFeature.ImprovedExhaustivenessChecksIn21)) {
                void $this$flatMapTo$iv;
                List list2;
                List $this$unwrapTypeParameterAndIntersectionTypes_u24lambda_u243 = list2 = CollectionsKt.createListBuilder();
                boolean bl = false;
                Iterable iterable = ((ConeTypeParameterType)$this$unwrapTypeParameterAndIntersectionTypes).getLookupTag().getTypeParameterSymbol().getResolvedBounds();
                Collection destination$iv = $this$unwrapTypeParameterAndIntersectionTypes_u24lambda_u243;
                boolean $i$f$flatMapTo = false;
                for (Object element$iv : $this$flatMapTo$iv) {
                    FirResolvedTypeRef it = (FirResolvedTypeRef)element$iv;
                    boolean bl2 = false;
                    Iterable list$iv = Companion.unwrapTypeParameterAndIntersectionTypes(it.getConeType(), session);
                    CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
                }
                $this$unwrapTypeParameterAndIntersectionTypes_u24lambda_u243.add($this$unwrapTypeParameterAndIntersectionTypes);
                collection = CollectionsKt.build((List)list2);
            } else if ($this$unwrapTypeParameterAndIntersectionTypes instanceof ConeDefinitelyNotNullType && FirLanguageSettingsComponentKt.getLanguageVersionSettings(session).supportsFeature(LanguageFeature.ImprovedExhaustivenessChecksIn21)) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.unwrapTypeParameterAndIntersectionTypes(((ConeDefinitelyNotNullType)$this$unwrapTypeParameterAndIntersectionTypes).getOriginal(), session);
                boolean $i$f$map = false;
                Iterable bl = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ConeKotlinType element$iv = (ConeKotlinType)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl3 = false;
                    collection2.add(TypeUtilsKt.makeConeTypeDefinitelyNotNullOrNotNull$default((ConeKotlinType)it, TypeComponentsKt.getTypeContext(session), false, false, 6, null));
                }
                collection = (List)destination$iv$iv;
            } else {
                collection = CollectionsKt.listOf((Object)$this$unwrapTypeParameterAndIntersectionTypes);
            }
            return collection;
        }

        /*
         * WARNING - void declaration
         */
        private final List<WhenExhaustivenessChecker> getCheckers(ConeKotlinType subjectType, FirSession session) {
            void $this$filterTo$iv;
            List list2;
            List $this$getCheckers_u24lambda_u246 = list2 = CollectionsKt.createListBuilder();
            boolean bl = false;
            Iterable iterable = exhaustivenessCheckers;
            Collection destination$iv = $this$getCheckers_u24lambda_u246;
            boolean $i$f$filterTo = false;
            for (Object element$iv : $this$filterTo$iv) {
                WhenExhaustivenessChecker it = (WhenExhaustivenessChecker)element$iv;
                boolean bl2 = false;
                if (!it.isApplicable(subjectType, session)) continue;
                destination$iv.add(element$iv);
            }
            if (!((Collection)$this$getCheckers_u24lambda_u246).isEmpty() && ConeTypeUtilsKt.isMarkedNullable(subjectType)) {
                $this$getCheckers_u24lambda_u246.add(WhenOnNullableExhaustivenessChecker.INSTANCE);
            }
            if ($this$getCheckers_u24lambda_u246.isEmpty()) {
                $this$getCheckers_u24lambda_u246.add(WhenSelfTypeExhaustivenessChecker.INSTANCE);
            }
            return CollectionsKt.build((List)list2);
        }

        private final void collectMissingCases(List<WhenMissingCase> $this$collectMissingCases, List<? extends WhenExhaustivenessChecker> checkers, FirWhenExpression whenExpression, ConeKotlinType subjectType, FirSession session) {
            for (WhenExhaustivenessChecker whenExhaustivenessChecker : checkers) {
                whenExhaustivenessChecker.computeMissingCases(whenExpression, subjectType, session, (Collection<WhenMissingCase>)$this$collectMissingCases);
            }
            if ($this$collectMissingCases.isEmpty() && whenExpression.getBranches().isEmpty()) {
                $this$collectMissingCases.add((WhenMissingCase)WhenMissingCase.Unknown.INSTANCE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

