/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.debugger.impl.shared;

import com.intellij.java.debugger.impl.shared.rpc.JavaDebuggerSessionDto;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.SharingStarted;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\f\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lcom/intellij/java/debugger/impl/shared/SharedJavaDebuggerSession;", "", "dto", "Lcom/intellij/java/debugger/impl/shared/rpc/JavaDebuggerSessionDto;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/java/debugger/impl/shared/rpc/JavaDebuggerSessionDto;Lkotlinx/coroutines/CoroutineScope;)V", "isAttachedFlow", "Lkotlinx/coroutines/flow/StateFlow;", "", "isAttached", "()Z", "isAsyncStacksEnabled", "isAsyncStacksEnabled$intellij_java_debugger_impl_shared", "setAsyncStacksEnabled$intellij_java_debugger_impl_shared", "(Z)V", "close", "", "intellij.java.debugger.impl.shared"})
@ApiStatus.Internal
public final class SharedJavaDebuggerSession {
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final StateFlow<Boolean> isAttachedFlow;
    private boolean isAsyncStacksEnabled;

    public SharedJavaDebuggerSession(@NotNull JavaDebuggerSessionDto dto, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.cs = cs;
        this.isAttachedFlow = FlowKt.stateIn((Flow)dto.isAttachedFlow().toFlow(), (CoroutineScope)this.cs, (SharingStarted)SharingStarted.Companion.getEagerly(), (Object)dto.isAttachedInitial());
        this.isAsyncStacksEnabled = true;
    }

    public final boolean isAttached() {
        return (Boolean)this.isAttachedFlow.getValue();
    }

    public final boolean isAsyncStacksEnabled$intellij_java_debugger_impl_shared() {
        return this.isAsyncStacksEnabled;
    }

    public final void setAsyncStacksEnabled$intellij_java_debugger_impl_shared(boolean bl) {
        this.isAsyncStacksEnabled = bl;
    }

    public final void close() {
        CoroutineScopeKt.cancel$default((CoroutineScope)this.cs, null, (int)1, null);
    }
}

