/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl;

import java.util.Objects;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.DefaultLocalPathPrefixComposerFactory;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.EnhancedLocalRepositoryManager;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.LocalPathComposer;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.LocalPathPrefixComposerFactory;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.TrackingFileManager;
import org.jetbrains.kotlin.org.eclipse.aether.repository.LocalRepository;
import org.jetbrains.kotlin.org.eclipse.aether.repository.LocalRepositoryManager;
import org.jetbrains.kotlin.org.eclipse.aether.repository.NoLocalRepositoryManagerException;
import org.jetbrains.kotlin.org.eclipse.aether.spi.localrepo.LocalRepositoryManagerFactory;
import org.jetbrains.kotlin.org.eclipse.aether.spi.locator.Service;
import org.jetbrains.kotlin.org.eclipse.aether.spi.locator.ServiceLocator;
import org.jetbrains.kotlin.org.eclipse.aether.util.ConfigUtils;

@Singleton
@Named(value="enhanced")
public class EnhancedLocalRepositoryManagerFactory
implements LocalRepositoryManagerFactory,
Service {
    private float priority = 10.0f;
    private LocalPathComposer localPathComposer;
    private TrackingFileManager trackingFileManager;
    private LocalPathPrefixComposerFactory localPathPrefixComposerFactory;

    @Deprecated
    public EnhancedLocalRepositoryManagerFactory() {
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.localPathComposer = Objects.requireNonNull(locator.getService(LocalPathComposer.class));
        this.trackingFileManager = Objects.requireNonNull(locator.getService(TrackingFileManager.class));
        this.localPathPrefixComposerFactory = new DefaultLocalPathPrefixComposerFactory();
    }

    @Override
    public LocalRepositoryManager newInstance(RepositorySystemSession session, LocalRepository repository) throws NoLocalRepositoryManagerException {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(repository, "repository cannot be null");
        String trackingFilename = ConfigUtils.getString(session, "", "aether.enhancedLocalRepository.trackingFilename");
        if (trackingFilename.isEmpty() || trackingFilename.contains("/") || trackingFilename.contains("\\") || trackingFilename.contains("..")) {
            trackingFilename = "_remote.repositories";
        }
        if ("".equals(repository.getContentType()) || "default".equals(repository.getContentType())) {
            return new EnhancedLocalRepositoryManager(repository.getBasedir(), this.localPathComposer, trackingFilename, this.trackingFileManager, this.localPathPrefixComposerFactory.createComposer(session));
        }
        throw new NoLocalRepositoryManagerException(repository);
    }

    @Override
    public float getPriority() {
        return this.priority;
    }
}

