/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io.pagecache;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class FilePageCacheStatistics {
    private final AtomicLong totalNativeBytesAllocated = new AtomicLong();
    private final AtomicLong totalNativeBytesReclaimed = new AtomicLong();
    private final AtomicLong totalHeapBytesAllocated = new AtomicLong();
    private final AtomicLong totalHeapBytesReclaimed = new AtomicLong();
    private volatile long nativeBytesCurrentlyUsed = 0L;
    private volatile long heapBytesCurrentlyUsed = 0L;
    private final AtomicInteger totalPagesAllocated = new AtomicInteger();
    private final AtomicInteger totalPagesReclaimed = new AtomicInteger();
    private final AtomicInteger totalPagesHandedOver = new AtomicInteger();
    private final AtomicLong totalBytesRead = new AtomicLong();
    private final AtomicLong totalBytesWritten = new AtomicLong();
    private final AtomicLong totalPagesWritten = new AtomicLong();
    private final AtomicLong totalPagesRequested = new AtomicLong();
    private final AtomicLong totalBytesRequested = new AtomicLong();
    private final AtomicLong totalPagesRequestsNs = new AtomicLong();
    private final AtomicLong totalPagesReadNs = new AtomicLong();
    private final AtomicLong totalPagesWriteNs = new AtomicLong();
    private final AtomicInteger pageAllocationsWaited = new AtomicInteger();
    private volatile long housekeeperTurnsDone = 0L;
    private volatile long housekeeperTurnsSkipped = 0L;
    private volatile long housekeeperTotalTimeNs = 0L;
    private volatile int totalClosedStoragesReclaimed;

    public void pageReclaimedNative(int pageSize) {
        this.totalNativeBytesReclaimed.addAndGet(pageSize);
        this.totalPagesReclaimed.incrementAndGet();
    }

    public void pageReclaimedHeap(int pageSize) {
        this.totalHeapBytesReclaimed.addAndGet(pageSize);
        this.totalPagesReclaimed.incrementAndGet();
    }

    public void cacheMaintenanceTurnDone(long timeSpentNs) {
        ++this.housekeeperTurnsDone;
        this.housekeeperTotalTimeNs += timeSpentNs;
    }

    public void cacheMaintenanceTurnSkipped(long timeSpentNs) {
        ++this.housekeeperTurnsSkipped;
        this.housekeeperTotalTimeNs += timeSpentNs;
    }

    public void closedStoragesReclaimed(int reclaimed) {
        this.totalClosedStoragesReclaimed += reclaimed;
    }

    public int totalPagesAllocated() {
        return this.totalPagesAllocated.get();
    }

    public int totalPagesReclaimed() {
        return this.totalPagesReclaimed.get();
    }

    public int totalPageAllocationsWaited() {
        return this.pageAllocationsWaited.get();
    }

    public String toString() {
        return "Statistics[pages: {requested: " + this.totalPagesRequested + ", allocated: " + this.totalPagesAllocated + ", flushed: " + this.totalPagesWritten + ", reclaimed: " + this.totalPagesReclaimed + "}, nativeBytes: {allocated: " + this.totalNativeBytesAllocated + ", reclaimed: " + this.totalNativeBytesReclaimed + ", current: " + this.nativeBytesCurrentlyUsed + "}, heapBytes: {allocated: " + this.totalHeapBytesAllocated + ", reclaimed: " + this.totalHeapBytesReclaimed + ", current: " + this.heapBytesCurrentlyUsed + "}, pages handed over: " + this.totalPagesHandedOver + ", pages allocation waited: " + this.pageAllocationsWaited + ", bytes: {requested: " + this.totalBytesRequested + ", read: " + this.totalBytesRead + ", written=" + this.totalBytesWritten + "}, housekeeperTurns: {done: " + this.housekeeperTurnsDone + ", skipped: " + this.housekeeperTurnsSkipped + "}, closedStoragesReclaimed: " + this.totalClosedStoragesReclaimed + ']';
    }
}

