"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.definitions = void 0;
const fz = __importStar(require("../converters/fromZigbee"));
const exposes = __importStar(require("../lib/exposes"));
const globalStore = __importStar(require("../lib/store"));
const e = exposes.presets;
const ea = exposes.access;
const fzLocal = {
    fireangel_co_test: {
        cluster: "ssIasZone",
        type: "commandStatusChangeNotification",
        convert: (model, msg, publish, options, meta) => {
            const zoneStatus = msg.data.zonestatus;
            const testActive = !!(zoneStatus & (1 << 5)) || !!(zoneStatus & (1 << 9));
            const lastTestTimeout = globalStore.getValue(msg.endpoint, "lastTestTimeout");
            if (lastTestTimeout)
                clearTimeout(lastTestTimeout);
            if (testActive) {
                const timeout = setTimeout(() => publish({ test: false }), 8000);
                globalStore.putValue(msg.endpoint, "lastTestTimeout", timeout);
            }
            return { test: testActive };
        },
    },
};
exports.definitions = [
    {
        zigbeeModel: ["Alarm_SD_Device"],
        model: "W2-Module",
        description: "Carbon monoxide sensor",
        vendor: "FireAngel",
        fromZigbee: [fz.W2_module_carbon_monoxide, fz.battery],
        toZigbee: [],
        exposes: [e.carbon_monoxide(), e.battery()],
    },
    {
        fingerprint: [{ modelID: "Alarm_SD_Device", manufacturerName: "Fireangel" }],
        model: "ZBCO-AE-10X-EUR",
        vendor: "FireAngel",
        description: "CO alarm",
        fromZigbee: [fz.ias_carbon_monoxide_alarm_1, fzLocal.fireangel_co_test],
        toZigbee: [],
        exposes: [
            e.binary("alarm", ea.STATE, true, false).withDescription("CO alarm active"),
            e.binary("test", ea.STATE, true, false).withDescription("Self-test in progress"),
            e.carbon_monoxide(),
            e.tamper(),
            e.battery_low(),
        ],
        configure: async (device, coordinatorEndpoint) => {
            const ep = device.getEndpoint(1);
            try {
                await ep.bind("ssIasZone", coordinatorEndpoint);
                await ep.bind("ssIasWd", coordinatorEndpoint);
            }
            catch (err) {
                console.error(`Failed to configure ${device.ieeeAddr}: ${err}`);
            }
        },
    },
];
//# sourceMappingURL=fireangel.js.map