/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.ErrorCode;
import com.google.firebase.internal.Nullable;
import com.google.firebase.remoteconfig.ConditionEvaluator;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigClient;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigException;
import com.google.firebase.remoteconfig.KeysAndValues;
import com.google.firebase.remoteconfig.Parameter;
import com.google.firebase.remoteconfig.ParameterValue;
import com.google.firebase.remoteconfig.ServerConfig;
import com.google.firebase.remoteconfig.ServerTemplate;
import com.google.firebase.remoteconfig.ServerTemplateData;
import com.google.firebase.remoteconfig.Value;
import com.google.firebase.remoteconfig.ValueSource;
import com.google.firebase.remoteconfig.internal.TemplateResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServerTemplateImpl
implements ServerTemplate {
    private final KeysAndValues defaultConfig;
    private FirebaseRemoteConfigClient client;
    private AtomicReference<ServerTemplateData> cache;
    private final AtomicReference<String> cachedTemplate;
    private static final Logger logger = LoggerFactory.getLogger(ServerTemplate.class);

    private ServerTemplateImpl(Builder builder) {
        this.defaultConfig = builder.defaultConfig;
        this.cachedTemplate = new AtomicReference<String>(builder.cachedTemplate);
        this.client = builder.client;
        this.cache = new AtomicReference<Object>(null);
        String initialTemplate = this.cachedTemplate.get();
        try {
            this.cache.set(ServerTemplateData.fromJSON(initialTemplate));
        }
        catch (FirebaseRemoteConfigException e) {
            e.printStackTrace();
        }
    }

    @Override
    public ServerConfig evaluate(@Nullable KeysAndValues context) throws FirebaseRemoteConfigException {
        ServerTemplateData cachedData = this.cache.get();
        if (cachedData == null) {
            throw new FirebaseRemoteConfigException(ErrorCode.FAILED_PRECONDITION, "No Remote Config Server template in cache. Call load() before calling evaluate().");
        }
        HashMap<String, Value> configValues = new HashMap<String, Value>();
        ImmutableMap<String, String> defaultConfigValues = this.defaultConfig.keysAndValues;
        for (String configName : defaultConfigValues.keySet()) {
            configValues.put(configName, new Value(ValueSource.DEFAULT, (String)defaultConfigValues.get((Object)configName)));
        }
        ConditionEvaluator conditionEvaluator = new ConditionEvaluator();
        ImmutableMap evaluatedCondition = ImmutableMap.copyOf(conditionEvaluator.evaluateConditions(cachedData.getServerConditions(), context));
        ImmutableMap parameters = ImmutableMap.copyOf(cachedData.getParameters());
        this.mergeDerivedConfigValues((ImmutableMap<String, Boolean>)evaluatedCondition, (ImmutableMap<String, Parameter>)parameters, configValues);
        return new ServerConfig(configValues);
    }

    @Override
    public ServerConfig evaluate() throws FirebaseRemoteConfigException {
        return this.evaluate(null);
    }

    @Override
    public ApiFuture<Void> load() throws FirebaseRemoteConfigException {
        String serverTemplate = this.client.getServerTemplate();
        this.cachedTemplate.set(serverTemplate);
        this.cache.set(ServerTemplateData.fromJSON(serverTemplate));
        return ApiFutures.immediateFuture(null);
    }

    public KeysAndValues getDefaultConfig() {
        return this.defaultConfig;
    }

    public String getCachedTemplate() {
        return this.cachedTemplate.get();
    }

    @Override
    public String toJson() {
        ServerTemplateData currentCache = this.cache.get();
        if (currentCache == null) {
            return "{}";
        }
        return currentCache.toJSON();
    }

    private void mergeDerivedConfigValues(ImmutableMap<String, Boolean> evaluatedCondition, ImmutableMap<String, Parameter> parameters, Map<String, Value> configValues) {
        for (String parameterName : parameters.keySet()) {
            Parameter parameter = (Parameter)parameters.get((Object)parameterName);
            if (parameter == null) {
                logger.warn(String.format("Parameter value is not assigned for %s", parameterName));
                continue;
            }
            ImmutableMap conditionalValues = ImmutableMap.copyOf(parameter.getConditionalValues());
            ParameterValue derivedValue = null;
            for (String conditionName : evaluatedCondition.keySet()) {
                boolean conditionEvaluation = (Boolean)evaluatedCondition.get((Object)conditionName);
                if (!conditionalValues.containsKey((Object)conditionName) || !conditionEvaluation) continue;
                derivedValue = (ParameterValue)conditionalValues.get((Object)conditionName);
                break;
            }
            if (derivedValue != null && derivedValue.toParameterValueResponse().isUseInAppDefault()) {
                logger.warn(String.format("Derived value found for %s but parameter is set to use in app default.", parameterName));
                continue;
            }
            if (derivedValue != null) {
                String parameterValue = derivedValue.toParameterValueResponse().getValue();
                Value value = new Value(ValueSource.REMOTE, parameterValue);
                configValues.put(parameterName, value);
                continue;
            }
            ParameterValue defaultValue = parameter.getDefaultValue();
            if (defaultValue == null) {
                logger.warn(String.format("Default parameter value for %s is not set.", parameterName));
                continue;
            }
            TemplateResponse.ParameterValueResponse defaultValueResponse = defaultValue.toParameterValueResponse();
            if (defaultValueResponse != null && defaultValueResponse.isUseInAppDefault()) {
                logger.info(String.format("Default value for %s is set to use in app default.", parameterName));
                continue;
            }
            String parameterDefaultValue = defaultValue.toParameterValueResponse().getValue();
            Value value = new Value(ValueSource.REMOTE, parameterDefaultValue);
            configValues.put(parameterName, value);
        }
    }

    public static class Builder
    implements ServerTemplate.Builder {
        private KeysAndValues defaultConfig;
        private String cachedTemplate;
        private FirebaseRemoteConfigClient client;

        Builder(FirebaseRemoteConfigClient remoteConfigClient) {
            this.client = remoteConfigClient;
        }

        @Override
        public Builder defaultConfig(KeysAndValues config) {
            this.defaultConfig = config;
            return this;
        }

        @Override
        public Builder cachedTemplate(String templateJson) {
            this.cachedTemplate = templateJson;
            return this;
        }

        @Override
        public ServerTemplate build() {
            return new ServerTemplateImpl(this);
        }
    }
}

