/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.ast.impl;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.ast.PyAstExpression;
import com.jetbrains.python.ast.PyAstNamedParameter;
import com.jetbrains.python.ast.PyAstStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralCoreUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class ParamHelperCore {
    private ParamHelperCore() {
    }

    @NotNull
    public static String getNameInSignature(@NotNull PyAstNamedParameter parameter) {
        if (parameter == null) {
            ParamHelperCore.$$$reportNull$$$0(0);
        }
        StringBuilder sb = new StringBuilder();
        if (parameter.isPositionalContainer()) {
            sb.append("*");
        } else if (parameter.isKeywordContainer()) {
            sb.append("**");
        }
        String name = parameter.getName();
        sb.append(name != null ? name : "...");
        String string = sb.toString();
        if (string == null) {
            ParamHelperCore.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Contract(value="null, _->null")
    @Nullable
    public static String getDefaultValuePartInSignature(@Nullable String defaultValue, boolean parameterRenderedAsTyped) {
        if (defaultValue == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(parameterRenderedAsTyped ? " = " : "=");
        Pair<String, String> quotes = PyStringLiteralCoreUtil.getQuotes(defaultValue);
        if (quotes != null) {
            String value = defaultValue.substring(((String)quotes.getFirst()).length(), defaultValue.length() - ((String)quotes.getSecond()).length());
            sb.append((String)quotes.getFirst());
            StringUtil.escapeStringCharacters((int)value.length(), (String)value, (StringBuilder)sb);
            sb.append((String)quotes.getSecond());
        } else {
            sb.append(defaultValue);
        }
        return sb.toString();
    }

    @Nullable
    public static String getDefaultValueText(@Nullable PyAstExpression defaultValue) {
        Pair<String, String> quotes;
        if (defaultValue instanceof PyAstStringLiteralExpression && (quotes = PyStringLiteralCoreUtil.getQuotes(defaultValue.getText())) != null) {
            return (String)quotes.getFirst() + ((PyAstStringLiteralExpression)defaultValue).getStringValue() + (String)quotes.getSecond();
        }
        return defaultValue == null ? null : defaultValue.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/ast/impl/ParamHelperCore";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/ast/impl/ParamHelperCore";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameInSignature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNameInSignature";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

