/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.transport;

import java.util.List;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.StepListener;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.securityanalytics.action.ValidateRulesRequest;
import org.opensearch.securityanalytics.action.ValidateRulesResponse;
import org.opensearch.securityanalytics.util.RuleValidator;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class TransportValidateRulesAction
extends HandledTransportAction<ValidateRulesRequest, ValidateRulesResponse> {
    private final RuleValidator ruleValidator;
    private final ClusterService clusterService;

    @Inject
    public TransportValidateRulesAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, Client client, NamedXContentRegistry namedXContentRegistry) {
        super("cluster:admin/opendistro/securityanalytics/rules/validate", transportService, actionFilters, ValidateRulesRequest::new);
        this.clusterService = clusterService;
        this.ruleValidator = new RuleValidator(client, namedXContentRegistry);
    }

    protected void doExecute(Task task, ValidateRulesRequest request, ActionListener<ValidateRulesResponse> actionListener) {
        IndexMetadata index = this.clusterService.state().metadata().index(request.getIndexName());
        if (index == null) {
            actionListener.onFailure((Exception)((Object)SecurityAnalyticsException.wrap((OpenSearchException)new OpenSearchStatusException("Could not find index [" + request.getIndexName() + "]", RestStatus.NOT_FOUND, new Object[0]))));
            return;
        }
        StepListener validateRulesResponseListener = new StepListener();
        validateRulesResponseListener.whenComplete(validateRulesResponse -> actionListener.onResponse((Object)new ValidateRulesResponse((List<String>)validateRulesResponse)), arg_0 -> actionListener.onFailure(arg_0));
        this.ruleValidator.validateCustomRules(request.getRules(), request.getIndexName(), (ActionListener<List<String>>)validateRulesResponseListener);
    }
}

