/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.transport;

import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.securityanalytics.action.CreateIndexMappingsRequest;
import org.opensearch.securityanalytics.mapper.MapperService;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportCreateIndexMappingsAction
extends HandledTransportAction<CreateIndexMappingsRequest, AcknowledgedResponse> {
    private MapperService mapperService;
    private ClusterService clusterService;
    private final ThreadPool threadPool;

    @Inject
    public TransportCreateIndexMappingsAction(TransportService transportService, ActionFilters actionFilters, ThreadPool threadPool, MapperService mapperService, ClusterService clusterService) {
        super("cluster:admin/opensearch/securityanalytics/mapping/create", transportService, actionFilters, CreateIndexMappingsRequest::new);
        this.clusterService = clusterService;
        this.mapperService = mapperService;
        this.threadPool = threadPool;
    }

    protected void doExecute(Task task, CreateIndexMappingsRequest request, ActionListener<AcknowledgedResponse> actionListener) {
        this.threadPool.getThreadContext().stashContext();
        this.mapperService.createMappingAction(request.getIndexName(), request.getRuleTopic(), request.getAliasMappings(), request.getPartial(), actionListener);
    }
}

