/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.chain.MonotoneChain;
import org.locationtech.jts.index.chain.MonotoneChainBuilder;
import org.locationtech.jts.index.chain.MonotoneChainOverlapAction;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.noding.NodedSegmentString;
import org.locationtech.jts.noding.SegmentIntersector;
import org.locationtech.jts.noding.SegmentString;
import org.locationtech.jts.noding.SinglePassNoder;

public class MCIndexNoder
extends SinglePassNoder {
    private List monoChains = new ArrayList();
    private SpatialIndex index = new STRtree();
    private int idCounter = 0;
    private Collection nodedSegStrings;
    private int nOverlaps = 0;

    public MCIndexNoder() {
    }

    public MCIndexNoder(SegmentIntersector si) {
        super(si);
    }

    public List getMonotoneChains() {
        return this.monoChains;
    }

    public SpatialIndex getIndex() {
        return this.index;
    }

    public Collection getNodedSubstrings() {
        return NodedSegmentString.getNodedSubstrings(this.nodedSegStrings);
    }

    public void computeNodes(Collection inputSegStrings) {
        this.nodedSegStrings = inputSegStrings;
        Iterator i = inputSegStrings.iterator();
        while (i.hasNext()) {
            this.add((SegmentString)i.next());
        }
        this.intersectChains();
    }

    private void intersectChains() {
        SegmentOverlapAction overlapAction = new SegmentOverlapAction(this.segInt);
        for (MonotoneChain queryChain : this.monoChains) {
            List overlapChains = this.index.query(queryChain.getEnvelope());
            for (MonotoneChain testChain : overlapChains) {
                if (testChain.getId() > queryChain.getId()) {
                    queryChain.computeOverlaps(testChain, overlapAction);
                    ++this.nOverlaps;
                }
                if (!this.segInt.isDone()) continue;
                return;
            }
        }
    }

    private void add(SegmentString segStr) {
        List segChains = MonotoneChainBuilder.getChains(segStr.getCoordinates(), segStr);
        for (MonotoneChain mc : segChains) {
            mc.setId(this.idCounter++);
            this.index.insert(mc.getEnvelope(), mc);
            this.monoChains.add(mc);
        }
    }

    public static class SegmentOverlapAction
    extends MonotoneChainOverlapAction {
        private SegmentIntersector si = null;

        public SegmentOverlapAction(SegmentIntersector si) {
            this.si = si;
        }

        public void overlap(MonotoneChain mc1, int start1, MonotoneChain mc2, int start2) {
            SegmentString ss1 = (SegmentString)mc1.getContext();
            SegmentString ss2 = (SegmentString)mc2.getContext();
            this.si.processIntersections(ss1, start1, ss2, start2);
        }
    }
}

