/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.commands;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.RuleStatus;
import org.openhab.core.automation.internal.commands.AutomationCommand;
import org.openhab.core.automation.internal.commands.AutomationCommandsPluggable;
import org.openhab.core.automation.internal.commands.Printer;

@NonNullByDefault
public class AutomationCommandEnableRule
extends AutomationCommand {
    private boolean enable;
    private boolean hasEnable;
    private @Nullable String uid;

    public AutomationCommandEnableRule(String command, String[] parameterValues, int providerType, AutomationCommandsPluggable autoCommands) {
        super(command, parameterValues, providerType, autoCommands);
    }

    @Override
    public String execute() {
        String uid = this.uid;
        if (!"SUCCESS".equals(this.parsingResult) || uid == null) {
            return this.parsingResult;
        }
        if (this.hasEnable) {
            this.autoCommands.setEnabled(uid, this.enable);
            return "SUCCESS";
        }
        RuleStatus status = this.autoCommands.getRuleStatus(uid);
        if (status != null) {
            return Printer.printRuleStatus(uid, status);
        }
        return "FAIL";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String parseOptionsAndParameters(String[] parameterValues) {
        String[] stringArray = parameterValues;
        int n = parameterValues.length;
        int n2 = 0;
        while (n2 < n) {
            String parameterValue = stringArray[n2];
            if (parameterValue != null) {
                if (parameterValue.charAt(0) == '-') {
                    if (!"-st".equals(parameterValue)) return String.format("Unsupported option: %s", parameterValue);
                    this.st = true;
                } else if (this.uid == null) {
                    this.uid = parameterValue;
                } else {
                    this.getEnable(parameterValue);
                    if (!this.hasEnable) {
                        if (this.uid != null) return String.format("Unsupported parameter: %s", parameterValue);
                        return "Missing required parameter: Rule UID";
                    }
                }
            }
            ++n2;
        }
        return "SUCCESS";
    }

    private void getEnable(String parameterValue) {
        if ("true".equals(parameterValue)) {
            this.enable = true;
            this.hasEnable = true;
        } else if ("false".equals(parameterValue)) {
            this.enable = false;
            this.hasEnable = true;
        } else {
            this.hasEnable = false;
        }
    }
}

