/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.compiler;

import com.igormaznitsa.jbbp.compiler.JBBPNamedFieldInfo;
import com.igormaznitsa.jbbp.exceptions.JBBPCompilationException;
import com.igormaznitsa.jbbp.utils.JBBPUtils;
import java.util.List;

public final class JBBPCompilerUtils {
    private JBBPCompilerUtils() {
    }

    public static int findIndexForFieldPath(String fieldPath, List<JBBPNamedFieldInfo> namedFields) {
        String normalized = JBBPUtils.normalizeFieldNameOrPath(fieldPath);
        int result = -1;
        for (int i = namedFields.size() - 1; i >= 0; --i) {
            JBBPNamedFieldInfo f = namedFields.get(i);
            if (!normalized.equals(f.getFieldPath())) continue;
            result = i;
            break;
        }
        return result;
    }

    public static JBBPNamedFieldInfo findForFieldPath(String fieldPath, List<JBBPNamedFieldInfo> namedFields) {
        String normalized = JBBPUtils.normalizeFieldNameOrPath(fieldPath);
        JBBPNamedFieldInfo result = null;
        for (int i = namedFields.size() - 1; i >= 0; --i) {
            JBBPNamedFieldInfo f = namedFields.get(i);
            if (!normalized.equals(f.getFieldPath())) continue;
            result = f;
            break;
        }
        return result;
    }

    public static void assertFieldIsNotArrayOrInArray(JBBPNamedFieldInfo fieldToCheck, List<JBBPNamedFieldInfo> namedFieldList, byte[] compiledScript) {
        if ((compiledScript[fieldToCheck.getFieldOffsetInCompiledBlock()] & 0x20) != 0) {
            throw new JBBPCompilationException("An Array field can't be used as array size [" + fieldToCheck.getFieldPath() + ']');
        }
        if (fieldToCheck.getFieldPath().indexOf(46) >= 0) {
            String[] splittedFieldPath = JBBPUtils.splitString(fieldToCheck.getFieldPath(), '.');
            StringBuilder fieldPath = new StringBuilder();
            for (int i = 0; i < splittedFieldPath.length - 1; ++i) {
                if (fieldPath.length() != 0) {
                    fieldPath.append('.');
                }
                fieldPath.append(splittedFieldPath[i]);
                JBBPNamedFieldInfo structureEnd = JBBPCompilerUtils.findForFieldPath(fieldPath.toString(), namedFieldList);
                if ((compiledScript[structureEnd.getFieldOffsetInCompiledBlock()] & 0x20) == 0) continue;
                throw new JBBPCompilationException("Field from structure array can't be use as array size [" + fieldToCheck.getFieldPath() + ';' + structureEnd.getFieldPath() + ']');
            }
        }
    }
}

