/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.jollyday.jackson;

import de.focus_shift.jollyday.core.HolidayType;
import de.focus_shift.jollyday.core.spi.MovingCondition;
import de.focus_shift.jollyday.core.spi.YearCycle;
import de.focus_shift.jollyday.jackson.JacksonMovingCondition;
import de.focus_shift.jollyday.jackson.XMLUtil;
import de.focus_shift.jollyday.jackson.mapping.Fixed;
import java.time.MonthDay;
import java.time.Year;
import java.util.List;
import java.util.stream.Collectors;

public class JacksonFixed
implements de.focus_shift.jollyday.core.spi.Fixed {
    private final XMLUtil xmlUtil = new XMLUtil();
    private final Fixed fixed;

    public JacksonFixed(Fixed fixed) {
        this.fixed = fixed;
    }

    public MonthDay day() {
        return MonthDay.of(this.xmlUtil.getMonth(this.fixed.getMonth()), (int)this.fixed.getDay());
    }

    public String descriptionPropertiesKey() {
        return this.fixed.getDescriptionPropertiesKey();
    }

    public HolidayType officiality() {
        return this.fixed.getLocalizedType() == null ? HolidayType.PUBLIC_HOLIDAY : HolidayType.valueOf((String)this.fixed.getLocalizedType().name());
    }

    public Year validFrom() {
        return this.fixed.getValidFrom() == null ? null : Year.of(this.fixed.getValidFrom());
    }

    public Year validTo() {
        return this.fixed.getValidTo() == null ? null : Year.of(this.fixed.getValidTo());
    }

    public YearCycle cycle() {
        return this.fixed.getEvery() == null ? YearCycle.EVERY_YEAR : YearCycle.valueOf((String)this.fixed.getEvery().name());
    }

    public List<MovingCondition> conditions() {
        return this.fixed.getMovingCondition().stream().map(JacksonMovingCondition::new).collect(Collectors.toList());
    }
}

