<?php
// This file was auto-generated from sdk-root/src/data/nova-act/2025-08-22/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2025-08-22', 'auth' => [ 'aws.auth#sigv4', ], 'endpointPrefix' => 'nova-act', 'protocol' => 'rest-json', 'protocols' => [ 'rest-json', ], 'serviceFullName' => 'Nova Act Service', 'serviceId' => 'Nova Act', 'signatureVersion' => 'v4', 'signingName' => 'nova-act', 'uid' => 'nova-act-2025-08-22', ], 'operations' => [ 'CreateAct' => [ 'name' => 'CreateAct', 'http' => [ 'method' => 'PUT', 'requestUri' => '/workflow-definitions/{workflowDefinitionName}/workflow-runs/{workflowRunId}/sessions/{sessionId}/acts', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateActRequest', ], 'output' => [ 'shape' => 'CreateActResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], ], 'idempotent' => true, ], 'CreateSession' => [ 'name' => 'CreateSession', 'http' => [ 'method' => 'PUT', 'requestUri' => '/workflow-definitions/{workflowDefinitionName}/workflow-runs/{workflowRunId}/sessions', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateSessionRequest', ], 'output' => [ 'shape' => 'CreateSessionResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], ], 'idempotent' => true, ], 'CreateWorkflowDefinition' => [ 'name' => 'CreateWorkflowDefinition', 'http' => [ 'method' => 'PUT', 'requestUri' => '/workflow-definitions', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateWorkflowDefinitionRequest', ], 'output' => [ 'shape' => 'CreateWorkflowDefinitionResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], ], 'idempotent' => true, ], 'CreateWorkflowRun' => [ 'name' => 'CreateWorkflowRun', 'http' => [ 'method' => 'PUT', 'requestUri' => '/workflow-definitions/{workflowDefinitionName}/workflow-runs', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateWorkflowRunRequest', ], 'output' => [ 'shape' => 'CreateWorkflowRunResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], ], 'idempotent' => true, ], 'DeleteWorkflowDefinition' => [ 'name' => 'DeleteWorkflowDefinition', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/workflow-definitions/{workflowDefinitionName}', 'responseCode' => 202, ], 'input' => [ 'shape' => 'DeleteWorkflowDefinitionRequest', ], 'output' => [ 'shape' => 'DeleteWorkflowDefinitionResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], ], 'idempotent' => true, ], 'DeleteWorkflowRun' => [ 'name' => 'DeleteWorkflowRun', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/workflow-definitions/{workflowDefinitionName}/workflow-runs/{workflowRunId}', 'responseCode' => 202, ], 'input' => [ 'shape' => 'DeleteWorkflowRunRequest', ], 'output' => [ 'shape' => 'DeleteWorkflowRunResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], ], 'idempotent' => true, ], 'GetWorkflowDefinition' => [ 'name' => 'GetWorkflowDefinition', 'http' => [ 'method' => 'GET', 'requestUri' => '/workflow-definitions/{workflowDefinitionName}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetWorkflowDefinitionRequest', ], 'output' => [ 'shape' => 'GetWorkflowDefinitionResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], ], 'readonly' => true, ], 'GetWorkflowRun' => [ 'name' => 'GetWorkflowRun', 'http' => [ 'method' => 'GET', 'requestUri' => '/workflow-definitions/{workflowDefinitionName}/workflow-runs/{workflowRunId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetWorkflowRunRequest', ], 'output' => [ 'shape' => 'GetWorkflowRunResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], ], 'readonly' => true, ], 'InvokeActStep' => [ 'name' => 'InvokeActStep', 'http' => [ 'method' => 'PUT', 'requestUri' => '/workflow-definitions/{workflowDefinitionName}/workflow-runs/{workflowRunId}/sessions/{sessionId}/acts/{actId}/invoke-step/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'InvokeActStepRequest', ], 'output' => [ 'shape' => 'InvokeActStepResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], ], ], 'ListActs' => [ 'name' => 'ListActs', 'http' => [ 'method' => 'POST', 'requestUri' => '/workflow-definitions/{workflowDefinitionName}/acts', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListActsRequest', ], 'output' => [ 'shape' => 'ListActsResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], ], 'readonly' => true, ], 'ListModels' => [ 'name' => 'ListModels', 'http' => [ 'method' => 'POST', 'requestUri' => '/models', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListModelsRequest', ], 'output' => [ 'shape' => 'ListModelsResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'readonly' => true, ], 'ListSessions' => [ 'name' => 'ListSessions', 'http' => [ 'method' => 'POST', 'requestUri' => '/workflow-definitions/{workflowDefinitionName}/workflow-runs/{workflowRunId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListSessionsRequest', ], 'output' => [ 'shape' => 'ListSessionsResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], ], 'readonly' => true, ], 'ListWorkflowDefinitions' => [ 'name' => 'ListWorkflowDefinitions', 'http' => [ 'method' => 'POST', 'requestUri' => '/workflow-definitions', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListWorkflowDefinitionsRequest', ], 'output' => [ 'shape' => 'ListWorkflowDefinitionsResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], ], 'readonly' => true, ], 'ListWorkflowRuns' => [ 'name' => 'ListWorkflowRuns', 'http' => [ 'method' => 'POST', 'requestUri' => '/workflow-definitions/{workflowDefinitionName}/workflow-runs', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListWorkflowRunsRequest', ], 'output' => [ 'shape' => 'ListWorkflowRunsResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], ], 'readonly' => true, ], 'UpdateAct' => [ 'name' => 'UpdateAct', 'http' => [ 'method' => 'PUT', 'requestUri' => '/workflow-definitions/{workflowDefinitionName}/workflow-runs/{workflowRunId}/sessions/{sessionId}/acts/{actId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateActRequest', ], 'output' => [ 'shape' => 'UpdateActResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], ], 'idempotent' => true, ], 'UpdateWorkflowRun' => [ 'name' => 'UpdateWorkflowRun', 'http' => [ 'method' => 'PUT', 'requestUri' => '/workflow-definitions/{workflowDefinitionName}/workflow-runs/{workflowRunId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateWorkflowRunRequest', ], 'output' => [ 'shape' => 'UpdateWorkflowRunResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], ], 'idempotent' => true, ], ], 'shapes' => [ 'AccessDeniedException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 403, 'senderFault' => true, ], 'exception' => true, ], 'ActError' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'ActErrorMessageString', ], 'type' => [ 'shape' => 'ActErrorTypeString', ], ], ], 'ActErrorMessageString' => [ 'type' => 'string', 'max' => 10000, 'min' => 1, 'sensitive' => true, ], 'ActErrorTypeString' => [ 'type' => 'string', 'max' => 100, 'min' => 1, ], 'ActStatus' => [ 'type' => 'string', 'enum' => [ 'RUNNING', 'PENDING_CLIENT_ACTION', 'PENDING_HUMAN_ACTION', 'SUCCEEDED', 'FAILED', 'TIMED_OUT', ], ], 'ActSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'ActSummary', ], ], 'ActSummary' => [ 'type' => 'structure', 'required' => [ 'workflowRunId', 'sessionId', 'actId', 'status', 'startedAt', ], 'members' => [ 'workflowRunId' => [ 'shape' => 'UuidString', ], 'sessionId' => [ 'shape' => 'UuidString', ], 'actId' => [ 'shape' => 'UuidString', ], 'status' => [ 'shape' => 'ActStatus', ], 'startedAt' => [ 'shape' => 'DateTimestamp', ], 'endedAt' => [ 'shape' => 'DateTimestamp', ], 'traceLocation' => [ 'shape' => 'TraceLocation', ], ], ], 'Call' => [ 'type' => 'structure', 'required' => [ 'callId', 'input', 'name', ], 'members' => [ 'callId' => [ 'shape' => 'CallId', ], 'input' => [ 'shape' => 'SensitiveDocument', ], 'name' => [ 'shape' => 'String', ], ], ], 'CallId' => [ 'type' => 'string', 'max' => 100, 'min' => 1, ], 'CallResult' => [ 'type' => 'structure', 'required' => [ 'content', ], 'members' => [ 'callId' => [ 'shape' => 'CallId', ], 'content' => [ 'shape' => 'CallResultContents', ], ], ], 'CallResultContent' => [ 'type' => 'structure', 'members' => [ 'text' => [ 'shape' => 'String', ], ], 'sensitive' => true, 'union' => true, ], 'CallResultContents' => [ 'type' => 'list', 'member' => [ 'shape' => 'CallResultContent', ], 'max' => 100, 'min' => 1, ], 'CallResults' => [ 'type' => 'list', 'member' => [ 'shape' => 'CallResult', ], 'max' => 100, 'min' => 1, ], 'Calls' => [ 'type' => 'list', 'member' => [ 'shape' => 'Call', ], ], 'ClientInfo' => [ 'type' => 'structure', 'required' => [ 'compatibilityVersion', ], 'members' => [ 'compatibilityVersion' => [ 'shape' => 'Integer', ], 'sdkVersion' => [ 'shape' => 'NonBlankString', ], ], ], 'ClientToken' => [ 'type' => 'string', 'max' => 256, 'min' => 33, 'pattern' => '[a-zA-Z0-9](-*[a-zA-Z0-9]){0,256}', ], 'CloudWatchLogGroupName' => [ 'type' => 'string', 'max' => 512, 'min' => 1, 'pattern' => '[a-zA-Z0-9_/.-]+', ], 'CompatibilityInformation' => [ 'type' => 'structure', 'required' => [ 'clientCompatibilityVersion', 'supportedModelIds', ], 'members' => [ 'clientCompatibilityVersion' => [ 'shape' => 'Integer', ], 'supportedModelIds' => [ 'shape' => 'ModelIdList', ], 'message' => [ 'shape' => 'NonBlankString', ], ], ], 'ConflictException' => [ 'type' => 'structure', 'required' => [ 'message', 'resourceId', 'resourceType', ], 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], 'resourceId' => [ 'shape' => 'NonBlankString', ], 'resourceType' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 409, 'senderFault' => true, ], 'exception' => true, ], 'CreateActRequest' => [ 'type' => 'structure', 'required' => [ 'workflowDefinitionName', 'workflowRunId', 'sessionId', 'task', ], 'members' => [ 'workflowDefinitionName' => [ 'shape' => 'WorkflowDefinitionName', 'location' => 'uri', 'locationName' => 'workflowDefinitionName', ], 'workflowRunId' => [ 'shape' => 'UuidString', 'location' => 'uri', 'locationName' => 'workflowRunId', ], 'sessionId' => [ 'shape' => 'UuidString', 'location' => 'uri', 'locationName' => 'sessionId', ], 'task' => [ 'shape' => 'Task', ], 'toolSpecs' => [ 'shape' => 'ToolSpecs', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], ], ], 'CreateActResponse' => [ 'type' => 'structure', 'required' => [ 'actId', 'status', ], 'members' => [ 'actId' => [ 'shape' => 'UuidString', ], 'status' => [ 'shape' => 'ActStatus', ], ], ], 'CreateSessionRequest' => [ 'type' => 'structure', 'required' => [ 'workflowDefinitionName', 'workflowRunId', ], 'members' => [ 'workflowDefinitionName' => [ 'shape' => 'WorkflowDefinitionName', 'location' => 'uri', 'locationName' => 'workflowDefinitionName', ], 'workflowRunId' => [ 'shape' => 'UuidString', 'location' => 'uri', 'locationName' => 'workflowRunId', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], ], ], 'CreateSessionResponse' => [ 'type' => 'structure', 'required' => [ 'sessionId', ], 'members' => [ 'sessionId' => [ 'shape' => 'UuidString', ], ], ], 'CreateWorkflowDefinitionRequest' => [ 'type' => 'structure', 'required' => [ 'name', ], 'members' => [ 'name' => [ 'shape' => 'WorkflowDefinitionName', ], 'description' => [ 'shape' => 'WorkflowDescription', ], 'exportConfig' => [ 'shape' => 'WorkflowExportConfig', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], ], ], 'CreateWorkflowDefinitionResponse' => [ 'type' => 'structure', 'required' => [ 'status', ], 'members' => [ 'status' => [ 'shape' => 'WorkflowDefinitionStatus', ], ], ], 'CreateWorkflowRunRequest' => [ 'type' => 'structure', 'required' => [ 'workflowDefinitionName', 'modelId', 'clientInfo', ], 'members' => [ 'workflowDefinitionName' => [ 'shape' => 'WorkflowDefinitionName', 'location' => 'uri', 'locationName' => 'workflowDefinitionName', ], 'modelId' => [ 'shape' => 'ModelId', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], 'logGroupName' => [ 'shape' => 'CloudWatchLogGroupName', ], 'clientInfo' => [ 'shape' => 'ClientInfo', ], ], ], 'CreateWorkflowRunResponse' => [ 'type' => 'structure', 'required' => [ 'workflowRunId', 'status', ], 'members' => [ 'workflowRunId' => [ 'shape' => 'UuidString', ], 'status' => [ 'shape' => 'WorkflowRunStatus', ], ], ], 'DateTimestamp' => [ 'type' => 'timestamp', 'timestampFormat' => 'iso8601', ], 'DeleteWorkflowDefinitionRequest' => [ 'type' => 'structure', 'required' => [ 'workflowDefinitionName', ], 'members' => [ 'workflowDefinitionName' => [ 'shape' => 'WorkflowDefinitionName', 'location' => 'uri', 'locationName' => 'workflowDefinitionName', ], ], ], 'DeleteWorkflowDefinitionResponse' => [ 'type' => 'structure', 'required' => [ 'status', ], 'members' => [ 'status' => [ 'shape' => 'WorkflowDefinitionStatus', ], ], ], 'DeleteWorkflowRunRequest' => [ 'type' => 'structure', 'required' => [ 'workflowDefinitionName', 'workflowRunId', ], 'members' => [ 'workflowDefinitionName' => [ 'shape' => 'WorkflowDefinitionName', 'location' => 'uri', 'locationName' => 'workflowDefinitionName', ], 'workflowRunId' => [ 'shape' => 'UuidString', 'location' => 'uri', 'locationName' => 'workflowRunId', ], ], ], 'DeleteWorkflowRunResponse' => [ 'type' => 'structure', 'required' => [ 'status', ], 'members' => [ 'status' => [ 'shape' => 'WorkflowRunStatus', ], ], ], 'GetWorkflowDefinitionRequest' => [ 'type' => 'structure', 'required' => [ 'workflowDefinitionName', ], 'members' => [ 'workflowDefinitionName' => [ 'shape' => 'WorkflowDefinitionName', 'location' => 'uri', 'locationName' => 'workflowDefinitionName', ], ], ], 'GetWorkflowDefinitionResponse' => [ 'type' => 'structure', 'required' => [ 'name', 'arn', 'createdAt', 'status', ], 'members' => [ 'name' => [ 'shape' => 'WorkflowDefinitionName', ], 'arn' => [ 'shape' => 'WorkflowDefinitionArn', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'description' => [ 'shape' => 'WorkflowDescription', ], 'exportConfig' => [ 'shape' => 'WorkflowExportConfig', ], 'status' => [ 'shape' => 'WorkflowDefinitionStatus', ], ], ], 'GetWorkflowRunRequest' => [ 'type' => 'structure', 'required' => [ 'workflowDefinitionName', 'workflowRunId', ], 'members' => [ 'workflowDefinitionName' => [ 'shape' => 'WorkflowDefinitionName', 'location' => 'uri', 'locationName' => 'workflowDefinitionName', ], 'workflowRunId' => [ 'shape' => 'UuidString', 'location' => 'uri', 'locationName' => 'workflowRunId', ], ], ], 'GetWorkflowRunResponse' => [ 'type' => 'structure', 'required' => [ 'workflowRunArn', 'workflowRunId', 'status', 'startedAt', 'modelId', ], 'members' => [ 'workflowRunArn' => [ 'shape' => 'WorkflowRunArn', ], 'workflowRunId' => [ 'shape' => 'UuidString', ], 'status' => [ 'shape' => 'WorkflowRunStatus', ], 'startedAt' => [ 'shape' => 'DateTimestamp', ], 'endedAt' => [ 'shape' => 'DateTimestamp', ], 'modelId' => [ 'shape' => 'ModelId', ], 'logGroupName' => [ 'shape' => 'CloudWatchLogGroupName', ], ], ], 'Integer' => [ 'type' => 'integer', 'box' => true, ], 'InternalServerException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], 'retryAfterSeconds' => [ 'shape' => 'Integer', 'location' => 'header', 'locationName' => 'Retry-After', ], 'reason' => [ 'shape' => 'InternalServerExceptionReason', ], ], 'error' => [ 'httpStatusCode' => 500, ], 'exception' => true, 'fault' => true, 'retryable' => [ 'throttling' => false, ], ], 'InternalServerExceptionReason' => [ 'type' => 'string', 'enum' => [ 'InvalidModelGeneration', 'RequestTokenLimitExceeded', ], ], 'InvokeActStepRequest' => [ 'type' => 'structure', 'required' => [ 'workflowDefinitionName', 'workflowRunId', 'sessionId', 'actId', 'callResults', ], 'members' => [ 'workflowDefinitionName' => [ 'shape' => 'WorkflowDefinitionName', 'location' => 'uri', 'locationName' => 'workflowDefinitionName', ], 'workflowRunId' => [ 'shape' => 'UuidString', 'location' => 'uri', 'locationName' => 'workflowRunId', ], 'sessionId' => [ 'shape' => 'UuidString', 'location' => 'uri', 'locationName' => 'sessionId', ], 'actId' => [ 'shape' => 'UuidString', 'location' => 'uri', 'locationName' => 'actId', ], 'callResults' => [ 'shape' => 'CallResults', ], 'previousStepId' => [ 'shape' => 'UuidString', ], ], ], 'InvokeActStepResponse' => [ 'type' => 'structure', 'required' => [ 'calls', 'stepId', ], 'members' => [ 'calls' => [ 'shape' => 'Calls', ], 'stepId' => [ 'shape' => 'UuidString', ], ], ], 'ListActsRequest' => [ 'type' => 'structure', 'required' => [ 'workflowDefinitionName', ], 'members' => [ 'workflowDefinitionName' => [ 'shape' => 'WorkflowDefinitionName', 'location' => 'uri', 'locationName' => 'workflowDefinitionName', ], 'workflowRunId' => [ 'shape' => 'UuidString', 'location' => 'querystring', 'locationName' => 'workflowRunId', ], 'sessionId' => [ 'shape' => 'UuidString', 'location' => 'querystring', 'locationName' => 'sessionId', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'sortOrder' => [ 'shape' => 'SortOrder', ], ], ], 'ListActsResponse' => [ 'type' => 'structure', 'required' => [ 'actSummaries', ], 'members' => [ 'actSummaries' => [ 'shape' => 'ActSummaries', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListModelsRequest' => [ 'type' => 'structure', 'required' => [ 'clientCompatibilityVersion', ], 'members' => [ 'clientCompatibilityVersion' => [ 'shape' => 'Integer', 'location' => 'querystring', 'locationName' => 'clientCompatibilityVersion', ], ], ], 'ListModelsResponse' => [ 'type' => 'structure', 'required' => [ 'modelSummaries', 'modelAliases', 'compatibilityInformation', ], 'members' => [ 'modelSummaries' => [ 'shape' => 'ModelSummaries', ], 'modelAliases' => [ 'shape' => 'ModelAliases', ], 'compatibilityInformation' => [ 'shape' => 'CompatibilityInformation', ], ], ], 'ListSessionsRequest' => [ 'type' => 'structure', 'required' => [ 'workflowDefinitionName', 'workflowRunId', ], 'members' => [ 'workflowDefinitionName' => [ 'shape' => 'WorkflowDefinitionName', 'location' => 'uri', 'locationName' => 'workflowDefinitionName', ], 'workflowRunId' => [ 'shape' => 'UuidString', 'location' => 'uri', 'locationName' => 'workflowRunId', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'sortOrder' => [ 'shape' => 'SortOrder', ], ], ], 'ListSessionsResponse' => [ 'type' => 'structure', 'required' => [ 'sessionSummaries', ], 'members' => [ 'sessionSummaries' => [ 'shape' => 'SessionSummaries', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListWorkflowDefinitionsRequest' => [ 'type' => 'structure', 'members' => [ 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'sortOrder' => [ 'shape' => 'SortOrder', ], ], ], 'ListWorkflowDefinitionsResponse' => [ 'type' => 'structure', 'required' => [ 'workflowDefinitionSummaries', ], 'members' => [ 'workflowDefinitionSummaries' => [ 'shape' => 'WorkflowDefinitionSummaries', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListWorkflowRunsRequest' => [ 'type' => 'structure', 'required' => [ 'workflowDefinitionName', ], 'members' => [ 'workflowDefinitionName' => [ 'shape' => 'WorkflowDefinitionName', 'location' => 'uri', 'locationName' => 'workflowDefinitionName', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'sortOrder' => [ 'shape' => 'SortOrder', ], ], ], 'ListWorkflowRunsResponse' => [ 'type' => 'structure', 'required' => [ 'workflowRunSummaries', ], 'members' => [ 'workflowRunSummaries' => [ 'shape' => 'WorkflowRunSummaries', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'MaxResults' => [ 'type' => 'integer', 'box' => true, 'max' => 100, 'min' => 1, ], 'ModelAlias' => [ 'type' => 'structure', 'required' => [ 'aliasName', 'latestModelId', ], 'members' => [ 'aliasName' => [ 'shape' => 'ModelId', ], 'latestModelId' => [ 'shape' => 'ModelId', ], 'resolvedModelId' => [ 'shape' => 'ModelId', ], ], ], 'ModelAliases' => [ 'type' => 'list', 'member' => [ 'shape' => 'ModelAlias', ], ], 'ModelId' => [ 'type' => 'string', 'max' => 100, 'min' => 1, ], 'ModelIdList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ModelId', ], ], 'ModelLifecycle' => [ 'type' => 'structure', 'required' => [ 'status', ], 'members' => [ 'status' => [ 'shape' => 'ModelStatus', ], ], ], 'ModelStatus' => [ 'type' => 'string', 'enum' => [ 'ACTIVE', 'LEGACY', 'DEPRECATED', 'PREVIEW', ], ], 'ModelSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'ModelSummary', ], ], 'ModelSummary' => [ 'type' => 'structure', 'required' => [ 'modelId', 'modelLifecycle', 'minimumCompatibilityVersion', ], 'members' => [ 'modelId' => [ 'shape' => 'ModelId', ], 'modelLifecycle' => [ 'shape' => 'ModelLifecycle', ], 'minimumCompatibilityVersion' => [ 'shape' => 'Integer', ], ], ], 'NextToken' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'pattern' => '\\S*', ], 'NonBlankString' => [ 'type' => 'string', 'pattern' => '[\\s\\S]+', ], 'ResourceNotFoundException' => [ 'type' => 'structure', 'required' => [ 'message', 'resourceId', 'resourceType', ], 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], 'resourceId' => [ 'shape' => 'NonBlankString', ], 'resourceType' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], 'S3BucketName' => [ 'type' => 'string', 'max' => 63, 'min' => 3, 'pattern' => '[a-z0-9][a-z0-9.-]*[a-z0-9]', ], 'S3KeyPrefix' => [ 'type' => 'string', 'max' => 100, 'min' => 1, 'pattern' => '[a-zA-Z0-9!\\-_.*\'()]+(?:/[a-zA-Z0-9!\\-_.*\'()]+)*', ], 'SensitiveDocument' => [ 'type' => 'structure', 'members' => [], 'document' => true, 'sensitive' => true, ], 'ServiceQuotaExceededException' => [ 'type' => 'structure', 'required' => [ 'message', 'resourceId', 'resourceType', 'serviceCode', 'quotaCode', ], 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], 'resourceId' => [ 'shape' => 'NonBlankString', ], 'resourceType' => [ 'shape' => 'NonBlankString', ], 'serviceCode' => [ 'shape' => 'NonBlankString', ], 'quotaCode' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 402, 'senderFault' => true, ], 'exception' => true, ], 'SessionSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'SessionSummary', ], ], 'SessionSummary' => [ 'type' => 'structure', 'required' => [ 'sessionId', ], 'members' => [ 'sessionId' => [ 'shape' => 'UuidString', ], ], ], 'SortOrder' => [ 'type' => 'string', 'enum' => [ 'Ascending', 'Descending', ], ], 'String' => [ 'type' => 'string', ], 'Task' => [ 'type' => 'string', 'max' => 10000, 'min' => 1, 'sensitive' => true, ], 'ThrottlingException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], 'serviceCode' => [ 'shape' => 'NonBlankString', ], 'quotaCode' => [ 'shape' => 'NonBlankString', ], 'retryAfterSeconds' => [ 'shape' => 'Integer', 'location' => 'header', 'locationName' => 'Retry-After', ], ], 'error' => [ 'httpStatusCode' => 429, 'senderFault' => true, ], 'exception' => true, 'retryable' => [ 'throttling' => true, ], ], 'ToolDescription' => [ 'type' => 'string', 'max' => 10000, 'min' => 1, 'sensitive' => true, ], 'ToolInputSchema' => [ 'type' => 'structure', 'members' => [ 'json' => [ 'shape' => 'ToolInputSchemaDocument', ], ], 'sensitive' => true, 'union' => true, ], 'ToolInputSchemaDocument' => [ 'type' => 'structure', 'members' => [], 'document' => true, ], 'ToolName' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '[a-zA-Z0-9_-]+', ], 'ToolSpec' => [ 'type' => 'structure', 'required' => [ 'name', 'description', 'inputSchema', ], 'members' => [ 'name' => [ 'shape' => 'ToolName', ], 'description' => [ 'shape' => 'ToolDescription', ], 'inputSchema' => [ 'shape' => 'ToolInputSchema', ], ], ], 'ToolSpecs' => [ 'type' => 'list', 'member' => [ 'shape' => 'ToolSpec', ], 'max' => 100, 'min' => 0, ], 'TraceLocation' => [ 'type' => 'structure', 'required' => [ 'locationType', 'location', ], 'members' => [ 'locationType' => [ 'shape' => 'TraceLocationType', ], 'location' => [ 'shape' => 'NonBlankString', ], ], ], 'TraceLocationType' => [ 'type' => 'string', 'enum' => [ 'S3', ], ], 'UpdateActRequest' => [ 'type' => 'structure', 'required' => [ 'workflowDefinitionName', 'workflowRunId', 'sessionId', 'actId', 'status', ], 'members' => [ 'workflowDefinitionName' => [ 'shape' => 'WorkflowDefinitionName', 'location' => 'uri', 'locationName' => 'workflowDefinitionName', ], 'workflowRunId' => [ 'shape' => 'UuidString', 'location' => 'uri', 'locationName' => 'workflowRunId', ], 'sessionId' => [ 'shape' => 'UuidString', 'location' => 'uri', 'locationName' => 'sessionId', ], 'actId' => [ 'shape' => 'UuidString', 'location' => 'uri', 'locationName' => 'actId', ], 'status' => [ 'shape' => 'ActStatus', ], 'error' => [ 'shape' => 'ActError', ], ], ], 'UpdateActResponse' => [ 'type' => 'structure', 'members' => [], ], 'UpdateWorkflowRunRequest' => [ 'type' => 'structure', 'required' => [ 'workflowDefinitionName', 'workflowRunId', 'status', ], 'members' => [ 'workflowDefinitionName' => [ 'shape' => 'WorkflowDefinitionName', 'location' => 'uri', 'locationName' => 'workflowDefinitionName', ], 'workflowRunId' => [ 'shape' => 'UuidString', 'location' => 'uri', 'locationName' => 'workflowRunId', ], 'status' => [ 'shape' => 'WorkflowRunStatus', ], ], ], 'UpdateWorkflowRunResponse' => [ 'type' => 'structure', 'members' => [], ], 'UuidString' => [ 'type' => 'string', 'pattern' => '[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', ], 'ValidationException' => [ 'type' => 'structure', 'required' => [ 'message', 'reason', ], 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], 'reason' => [ 'shape' => 'ValidationExceptionReason', ], 'fieldList' => [ 'shape' => 'ValidationExceptionFieldList', ], ], 'error' => [ 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'ValidationExceptionField' => [ 'type' => 'structure', 'required' => [ 'name', 'message', ], 'members' => [ 'name' => [ 'shape' => 'NonBlankString', ], 'message' => [ 'shape' => 'NonBlankString', ], ], ], 'ValidationExceptionFieldList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ValidationExceptionField', ], ], 'ValidationExceptionReason' => [ 'type' => 'string', 'enum' => [ 'FieldValidationFailed', 'InvalidStatus', 'GuardrailIntervened', ], ], 'WorkflowDefinitionArn' => [ 'type' => 'string', 'pattern' => 'arn:(aws|aws-cn|aws-us-gov):nova-act:[a-z0-9-]+:[0-9]{12}:workflow-definition/[a-zA-Z0-9_-]{1,40}', ], 'WorkflowDefinitionName' => [ 'type' => 'string', 'max' => 40, 'min' => 1, 'pattern' => '[a-zA-Z0-9_-]{1,40}', ], 'WorkflowDefinitionStatus' => [ 'type' => 'string', 'enum' => [ 'ACTIVE', 'DELETING', ], ], 'WorkflowDefinitionSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'WorkflowDefinitionSummary', ], ], 'WorkflowDefinitionSummary' => [ 'type' => 'structure', 'required' => [ 'workflowDefinitionArn', 'workflowDefinitionName', 'createdAt', 'status', ], 'members' => [ 'workflowDefinitionArn' => [ 'shape' => 'WorkflowDefinitionArn', ], 'workflowDefinitionName' => [ 'shape' => 'WorkflowDefinitionName', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'status' => [ 'shape' => 'WorkflowDefinitionStatus', ], ], ], 'WorkflowDescription' => [ 'type' => 'string', 'max' => 4000, 'min' => 1, 'sensitive' => true, ], 'WorkflowExportConfig' => [ 'type' => 'structure', 'required' => [ 's3BucketName', ], 'members' => [ 's3BucketName' => [ 'shape' => 'S3BucketName', ], 's3KeyPrefix' => [ 'shape' => 'S3KeyPrefix', ], ], ], 'WorkflowRunArn' => [ 'type' => 'string', 'pattern' => 'arn:(aws|aws-cn|aws-us-gov):nova-act:[a-z0-9-]+:[0-9]{12}:workflow-definition/[a-zA-Z0-9_-]{1,40}/workflow-run/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', ], 'WorkflowRunStatus' => [ 'type' => 'string', 'enum' => [ 'RUNNING', 'SUCCEEDED', 'FAILED', 'TIMED_OUT', 'DELETING', ], ], 'WorkflowRunSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'WorkflowRunSummary', ], ], 'WorkflowRunSummary' => [ 'type' => 'structure', 'required' => [ 'workflowRunArn', 'workflowRunId', 'status', 'startedAt', ], 'members' => [ 'workflowRunArn' => [ 'shape' => 'WorkflowRunArn', ], 'workflowRunId' => [ 'shape' => 'UuidString', ], 'status' => [ 'shape' => 'WorkflowRunStatus', ], 'startedAt' => [ 'shape' => 'DateTimestamp', ], 'endedAt' => [ 'shape' => 'DateTimestamp', ], 'traceLocation' => [ 'shape' => 'TraceLocation', ], ], ], ],];
