/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.grants;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.events.EventType;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.AuthenticationFlowResolver;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.protocol.oidc.grants.OAuth2GrantType;
import org.keycloak.protocol.oidc.grants.OAuth2GrantTypeBase;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.services.CorsErrorResponseException;
import org.keycloak.services.Urls;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.ResourceOwnerPasswordCredentialsContext;
import org.keycloak.services.clientpolicy.context.ResourceOwnerPasswordCredentialsResponseContext;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;
import org.keycloak.util.TokenUtil;

public class ResourceOwnerPasswordCredentialsGrantType
extends OAuth2GrantTypeBase {
    private static final Logger logger = Logger.getLogger(ResourceOwnerPasswordCredentialsGrantType.class);

    public Response process(OAuth2GrantType.Context context) {
        String scopeParam;
        this.setContext(context);
        this.event.detail("auth_method", "oauth_credentials");
        if (!this.client.isDirectAccessGrantsEnabled()) {
            String errorMessage = "Client not allowed for direct access grants";
            this.event.detail("reason", errorMessage);
            this.event.error("not_allowed");
            throw new CorsErrorResponseException(this.cors, "unauthorized_client", errorMessage, Response.Status.BAD_REQUEST);
        }
        if (this.client.isConsentRequired()) {
            String errorMessage = "Client requires user consent";
            this.event.detail("reason", errorMessage);
            this.event.error("consent_denied");
            throw new CorsErrorResponseException(this.cors, "invalid_client", errorMessage, Response.Status.BAD_REQUEST);
        }
        try {
            this.session.clientPolicy().triggerOnEvent((ClientPolicyContext)new ResourceOwnerPasswordCredentialsContext((MultivaluedMap<String, String>)this.formParams));
        }
        catch (ClientPolicyException cpe) {
            this.event.detail("reason", "client_policy_error");
            this.event.detail("client_policy_error", cpe.getError());
            this.event.detail("client_policy_error_detail", cpe.getErrorDetail());
            this.event.error(cpe.getError());
            throw new CorsErrorResponseException(this.cors, cpe.getError(), cpe.getErrorDetail(), cpe.getErrorStatus());
        }
        String scope = this.getRequestedScopes();
        RootAuthenticationSessionModel rootAuthSession = new AuthenticationSessionManager(this.session).createAuthenticationSession(this.realm, false);
        AuthenticationSessionModel authSession = rootAuthSession.createAuthenticationSession(this.client);
        authSession.setProtocol("openid-connect");
        authSession.setAction(CommonClientSessionModel.Action.AUTHENTICATE.name());
        authSession.setClientNote("iss", Urls.realmIssuer(this.session.getContext().getUri().getBaseUri(), this.realm.getName()));
        authSession.setClientNote("scope", scope);
        AuthenticationFlowModel flow = AuthenticationFlowResolver.resolveDirectGrantFlow((AuthenticationSessionModel)authSession);
        String flowId = flow.getId();
        AuthenticationProcessor processor = new AuthenticationProcessor();
        processor.setAuthenticationSession(authSession).setFlowId(flowId).setFlowPath("token").setConnection(this.clientConnection).setEventBuilder(this.event).setRealm(this.realm).setSession(this.session).setUriInfo((UriInfo)this.session.getContext().getUri()).setRequest(this.request);
        Response challenge = processor.authenticateOnly();
        if (challenge != null) {
            new AuthenticationSessionManager(this.session).removeAuthenticationSession(this.realm, authSession, false);
            this.cors.add();
            return challenge;
        }
        processor.evaluateRequiredActionTriggers();
        UserModel user = authSession.getAuthenticatedUser();
        if (user.getRequiredActionsStream().count() > 0L || authSession.getRequiredActions().size() > 0) {
            new AuthenticationSessionManager(this.session).removeAuthenticationSession(this.realm, authSession, false);
            String errorMessage = "Account is not fully set up";
            this.event.detail("reason", errorMessage);
            this.event.error("resolve_required_actions");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", errorMessage, Response.Status.BAD_REQUEST);
        }
        AuthenticationManager.setClientScopesInSession(this.session, authSession);
        ClientSessionContext clientSessionCtx = processor.attachSession();
        clientSessionCtx.setAttribute("grant_type", (Object)context.getGrantType());
        UserSessionModel userSession = processor.getUserSession();
        this.updateUserSessionFromClientAuth(userSession);
        TokenManager.AccessTokenResponseBuilder responseBuilder = this.tokenManager.responseBuilder(this.realm, this.client, this.event, this.session, userSession, clientSessionCtx).generateAccessToken();
        boolean useRefreshToken = this.clientConfig.isUseRefreshToken();
        if (useRefreshToken) {
            responseBuilder.generateRefreshToken();
            if ("Offline".equals(responseBuilder.getRefreshToken().getType())) {
                this.session.sessions().removeUserSession(this.realm, userSession);
            }
        }
        if (TokenUtil.isOIDCRequest((String)(scopeParam = clientSessionCtx.getClientSession().getNote("scope")))) {
            responseBuilder.generateIDToken().generateAccessTokenHash();
        }
        this.checkAndBindMtlsHoKToken(responseBuilder, useRefreshToken);
        try {
            this.session.clientPolicy().triggerOnEvent((ClientPolicyContext)new ResourceOwnerPasswordCredentialsResponseContext((MultivaluedMap<String, String>)this.formParams, clientSessionCtx, responseBuilder));
        }
        catch (ClientPolicyException cpe) {
            this.event.detail("reason", "client_policy_error");
            this.event.detail("client_policy_error", cpe.getError());
            this.event.detail("client_policy_error_detail", cpe.getErrorDetail());
            this.event.error(cpe.getError());
            throw new CorsErrorResponseException(this.cors, cpe.getError(), cpe.getErrorDetail(), cpe.getErrorStatus());
        }
        AccessTokenResponse res = responseBuilder.build();
        this.event.success();
        AuthenticationManager.logSuccess(this.session, authSession);
        return this.cors.add(Response.ok((Object)res, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    public EventType getEventType() {
        return EventType.LOGIN;
    }
}

