/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi.builders;

import io.smallrye.mutiny.Context;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractMulti;
import io.smallrye.mutiny.subscription.ContextSupport;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.function.Function;

public class DeferredMultiWithContext<T>
extends AbstractMulti<T> {
    private final Function<Context, Multi<? extends T>> mapper;

    public DeferredMultiWithContext(Function<Context, Multi<? extends T>> mapper) {
        this.mapper = mapper;
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> downstream) {
        Multi<? super T> multi;
        Context context = downstream instanceof ContextSupport ? ((ContextSupport)((Object)downstream)).context() : Context.empty();
        try {
            multi = this.mapper.apply(context);
            if (multi == null) {
                throw new NullPointerException("The mapper returned `null`");
            }
        }
        catch (Throwable failure) {
            Subscriptions.fail(downstream, failure);
            return;
        }
        multi.subscribe(Infrastructure.onMultiSubscription(multi, downstream));
    }
}

