/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.hierarchy;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.ide.hierarchy.type.JavaTypeHierarchyProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.RootKindFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.SourceKindFilterUtils;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.stubindex.KotlinClassShortNameIndex;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J$\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/hierarchy/KotlinTypeHierarchyProvider;", "Lcom/intellij/ide/hierarchy/type/JavaTypeHierarchyProvider;", "<init>", "()V", "getOriginalPsiClassOrCreateLightClass", "Lcom/intellij/psi/PsiClass;", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "module", "Lcom/intellij/openapi/module/Module;", "getTargetByReference", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getTargetByContainingElement", "file", "Lcom/intellij/psi/PsiFile;", "getTarget", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nKotlinTypeHierarchyProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinTypeHierarchyProvider.kt\norg/jetbrains/kotlin/idea/hierarchy/KotlinTypeHierarchyProvider\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,93:1\n253#2:94\n*S KotlinDebug\n*F\n+ 1 KotlinTypeHierarchyProvider.kt\norg/jetbrains/kotlin/idea/hierarchy/KotlinTypeHierarchyProvider\n*L\n68#1:94\n*E\n"})
public final class KotlinTypeHierarchyProvider
extends JavaTypeHierarchyProvider {
    private final PsiClass getOriginalPsiClassOrCreateLightClass(KtClassOrObject classOrObject, Module module) {
        FqName fqName2 = classOrObject.getFqName();
        if (fqName2 != null) {
            ClassId javaClassId;
            Module module2 = module;
            if (JvmPlatformKt.isJvm((TargetPlatform)(module2 != null ? TargetPlatformDetectorUtils.getPlatform(module2) : null)) && (javaClassId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(fqName2.toUnsafe())) != null) {
                return JavaPsiFacade.getInstance((Project)classOrObject.getProject()).findClass(javaClassId.asSingleFqName().asString(), GlobalSearchScope.allScope((Project)classOrObject.getProject()));
            }
        }
        KtLightClass ktLightClass = LightClassUtilsKt.toLightClass((KtClassOrObject)classOrObject);
        return ktLightClass != null ? (PsiClass)ktLightClass : (PsiClass)LightClassUtilsKt.toFakeLightClass((KtClassOrObject)classOrObject);
    }

    private final PsiClass getTargetByReference(Project project, Editor editor, Module module) {
        PsiClass psiClass;
        PsiElement target = TargetElementUtil.findTargetElement((Editor)editor, (int)TargetElementUtil.getInstance().getAllAccepted());
        if (target instanceof PsiClass) {
            psiClass = (PsiClass)target;
        } else if (target instanceof KtConstructor) {
            psiClass = this.getOriginalPsiClassOrCreateLightClass(((KtConstructor)target).getContainingClassOrObject(), module);
        } else if (target instanceof KtClassOrObject) {
            psiClass = this.getOriginalPsiClassOrCreateLightClass((KtClassOrObject)target, module);
        } else if (target instanceof KtNamedFunction) {
            String returnTypeText;
            String string = ((KtNamedFunction)target).getName();
            if (string == null) {
                return null;
            }
            String functionName = string;
            KtTypeReference ktTypeReference = ((KtNamedFunction)target).getTypeReference();
            String string2 = returnTypeText = ktTypeReference != null ? ktTypeReference.getText() : null;
            if (!Intrinsics.areEqual(string2 != null ? StringsKt.substringAfter$default((String)string2, (String)".", null, (int)2, null) : null, (Object)functionName)) {
                return null;
            }
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
            KtClassOrObject ktClassOrObject = (KtClassOrObject)CollectionsKt.singleOrNull((Iterable)KotlinClassShortNameIndex.Helper.get(functionName, project, globalSearchScope));
            if (ktClassOrObject == null) {
                return null;
            }
            KtClassOrObject classOrObject = ktClassOrObject;
            psiClass = this.getOriginalPsiClassOrCreateLightClass(classOrObject, module);
        } else {
            psiClass = null;
        }
        return psiClass;
    }

    private final PsiClass getTargetByContainingElement(Editor editor, PsiFile file) {
        PsiElement element;
        int offset = editor.getCaretModel().getOffset();
        PsiElement psiElement = file.findElementAt(offset);
        if (psiElement == null) {
            return null;
        }
        PsiElement $this$getNonStrictParentOfType$iv = element = psiElement;
        boolean $i$f$getNonStrictParentOfType = false;
        KtClassOrObject ktClassOrObject = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtClassOrObject.class, (boolean)false);
        if (ktClassOrObject == null) {
            return null;
        }
        KtClassOrObject classOrObject = ktClassOrObject;
        return this.getOriginalPsiClassOrCreateLightClass(classOrObject, GenericPsiUtils.getModule((PsiElement)file));
    }

    @Nullable
    public PsiClass getTarget(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return null;
        }
        Project project2 = project;
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        if (editor != null) {
            PsiClass psiElement;
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
            if (psiFile == null) {
                return null;
            }
            PsiFile file = psiFile;
            if (!SourceKindFilterUtils.matches(RootKindFilter.projectAndLibrarySources, (PsiElement)file)) {
                return null;
            }
            PsiClass psiClass = this.getTargetByReference(project2, editor, GenericPsiUtils.getModule((PsiElement)file));
            if (psiClass == null) {
                psiClass = this.getTargetByContainingElement(editor, file);
            }
            if ((psiElement = psiClass) instanceof PsiNamedElement && psiElement.getName() == null) {
                return null;
            }
            return psiElement;
        }
        PsiElement element = (PsiElement)LangDataKeys.PSI_ELEMENT.getData(dataContext);
        if (element instanceof KtClassOrObject) {
            return this.getOriginalPsiClassOrCreateLightClass((KtClassOrObject)element, GenericPsiUtils.getModule(element));
        }
        return null;
    }
}

