/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.maven.plugin;

import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.jboss.galleon.maven.plugin.ChannelDescription;
import org.jboss.galleon.maven.plugin.util.MavenArtifactRepositoryManager;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenProducerInstaller;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.galleon.universe.maven.repo.SimplisticMavenRepoManager;

@Mojo(name="create-producer")
public class CreateProducerMojo
extends AbstractMojo {
    @Component
    protected RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    protected RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> repositories;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(required=true)
    private String name;
    @Parameter(required=true, defaultValue="${project.groupId}")
    private String groupId;
    @Parameter(required=true, defaultValue="${project.artifactId}")
    private String artifactId;
    @Parameter(required=true, defaultValue="${project.version}")
    private String version;
    @Parameter(required=true, alias="feature-pack-groupId")
    private String featurePackGroupId;
    @Parameter(required=true, alias="feature-pack-artifactId")
    private String featurePackArtifactId;
    @Parameter(required=true)
    private List<String> frequencies = Collections.emptyList();
    @Parameter(required=true)
    private List<ChannelDescription> channels = Collections.emptyList();
    @Parameter(defaultValue="false", property="galleon.skip")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping the create-producer goal.");
            return;
        }
        try {
            this.createProducer();
        }
        catch (MavenUniverseException e) {
            throw new MojoExecutionException("Failed to create producer artifact", (Exception)e);
        }
    }

    private void createProducer() throws MavenUniverseException, MojoExecutionException {
        MavenArtifact producerArtifact = new MavenArtifact().setGroupId(this.groupId).setArtifactId(this.artifactId).setVersion(this.version);
        MavenProducerInstaller installer = new MavenProducerInstaller(this.name, SimplisticMavenRepoManager.getInstance(Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve("local-repo"), new MavenArtifactRepositoryManager(this.repoSystem, this.repoSession, this.repositories)), producerArtifact, this.featurePackGroupId, this.featurePackArtifactId);
        for (String string : this.frequencies) {
            installer.addFrequency(string);
        }
        HashSet<String> names = new HashSet<String>(this.channels.size());
        for (ChannelDescription channel : this.channels) {
            if (!names.add(channel.name)) {
                throw new MojoExecutionException("Duplicate channel " + channel.name);
            }
            try {
                installer.addChannel(channel.name, channel.versionRange);
            }
            catch (MavenUniverseException e) {
                throw new MojoExecutionException("Failed to add channel " + channel.name, (Exception)e);
            }
        }
        try {
            installer.install();
        }
        catch (MavenUniverseException mavenUniverseException) {
            throw new MojoExecutionException("Failed to create producer", (Exception)mavenUniverseException);
        }
        this.projectHelper.attachArtifact(this.project, "jar", producerArtifact.getPath().toFile());
    }
}

