/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.repository.internal;

import java.io.File;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.artifact.ArtifactCoordinate;
import org.apache.maven.shared.repository.RepositoryManager;
import org.apache.maven.shared.repository.RepositoryManagerException;
import org.apache.maven.shared.repository.internal.Invoker;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.aether.DefaultRepositoryCache;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.metadata.DefaultMetadata;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;

@Component(role=RepositoryManager.class, hint="maven31")
public class Maven31RepositoryManager
implements RepositoryManager {
    @Requirement
    private RepositorySystem repositorySystem;
    @Requirement
    private ArtifactHandlerManager artifactHandlerManager;

    @Override
    public String getPathForLocalArtifact(ProjectBuildingRequest buildingRequest, org.apache.maven.artifact.Artifact mavenArtifact) {
        RepositorySystemSession session;
        Artifact aetherArtifact;
        try {
            aetherArtifact = (Artifact)Invoker.invoke(RepositoryUtils.class, "toArtifact", org.apache.maven.artifact.Artifact.class, (Object)mavenArtifact);
            session = (RepositorySystemSession)Invoker.invoke(buildingRequest, "getRepositorySession");
        }
        catch (RepositoryManagerException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return session.getLocalRepositoryManager().getPathForLocalArtifact(aetherArtifact);
    }

    @Override
    public String getPathForLocalArtifact(ProjectBuildingRequest buildingRequest, ArtifactCoordinate coordinate) {
        RepositorySystemSession session;
        Artifact aetherArtifact;
        try {
            aetherArtifact = this.toArtifact(coordinate);
            session = (RepositorySystemSession)Invoker.invoke(buildingRequest, "getRepositorySession");
        }
        catch (RepositoryManagerException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return session.getLocalRepositoryManager().getPathForLocalArtifact(aetherArtifact);
    }

    @Override
    public String getPathForLocalMetadata(ProjectBuildingRequest buildingRequest, ArtifactMetadata metadata) {
        RepositorySystemSession session;
        DefaultMetadata aetherMetadata = new DefaultMetadata(metadata.getGroupId(), metadata.storedInGroupDirectory() ? null : metadata.getArtifactId(), metadata.storedInArtifactVersionDirectory() ? metadata.getBaseVersion() : null, "maven-metadata.xml", Metadata.Nature.RELEASE_OR_SNAPSHOT);
        try {
            session = (RepositorySystemSession)Invoker.invoke(buildingRequest, "getRepositorySession");
        }
        catch (RepositoryManagerException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return session.getLocalRepositoryManager().getPathForLocalMetadata(aetherMetadata);
    }

    @Override
    public ProjectBuildingRequest setLocalRepositoryBasedir(ProjectBuildingRequest buildingRequest, File basedir) {
        RepositorySystemSession session;
        DefaultProjectBuildingRequest newRequest = new DefaultProjectBuildingRequest(buildingRequest);
        try {
            session = (RepositorySystemSession)Invoker.invoke(buildingRequest, "getRepositorySession");
        }
        catch (RepositoryManagerException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        DefaultRepositorySystemSession newSession = new DefaultRepositorySystemSession(session);
        newSession.setCache(new DefaultRepositoryCache());
        String repositoryType = this.resolveRepositoryType(session.getLocalRepository());
        LocalRepositoryManager localRepositoryManager = this.repositorySystem.newLocalRepositoryManager(newSession, new LocalRepository(basedir, repositoryType));
        newSession.setLocalRepositoryManager(localRepositoryManager);
        try {
            Invoker.invoke(newRequest, "setRepositorySession", RepositorySystemSession.class, (Object)newSession);
        }
        catch (RepositoryManagerException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return newRequest;
    }

    @Override
    public File getLocalRepositoryBasedir(ProjectBuildingRequest buildingRequest) {
        RepositorySystemSession session;
        try {
            session = (RepositorySystemSession)Invoker.invoke(buildingRequest, "getRepositorySession");
        }
        catch (RepositoryManagerException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return session.getLocalRepository().getBasedir();
    }

    protected String resolveRepositoryType(LocalRepository localRepository) {
        String repositoryType = "enhanced".equals(localRepository.getContentType()) ? "default" : localRepository.getContentType();
        return repositoryType;
    }

    protected Artifact toArtifact(ArtifactCoordinate coordinate) {
        if (coordinate == null) {
            return null;
        }
        DefaultArtifact result = new DefaultArtifact(coordinate.getGroupId(), coordinate.getArtifactId(), coordinate.getClassifier(), coordinate.getExtension(), coordinate.getVersion());
        return result;
    }
}

