/*
 * Decompiled with CFR 0.152.
 */
package tr.view.projects;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.action.Action;
import tr.model.project.Project;
import tr.view.Window;
import tr.view.action.ActionPanel;
import tr.view.project.ProjectPanel;
import tr.view.projects.ActionNode;
import tr.view.projects.ProjectNode;

public final class EditorTopComponent
extends Window
implements Lookup.Provider {
    private static final Logger LOG = Logger.getLogger("tr.view.projects");
    private static final String PREFERRED_ID = "EditorTopComponent";
    private static EditorTopComponent instance;
    private final InstanceContent content = new InstanceContent();
    private final Lookup lookup = new AbstractLookup((AbstractLookup.Content)this.content);
    private boolean initialised;
    private ActionPanel actionPanel;
    private ProjectPanel projectPanel;
    private Action viewAction;
    private JPanel emptyPanel;
    private JScrollPane scrollPane;
    private final PropertyChangeListener actionStateListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof Action) {
                EditorTopComponent.this.refreshIcon((Action)evt.getSource());
            }
        }
    };

    private EditorTopComponent() {
        this.initComponents();
    }

    private void initialise() {
        if (this.initialised) {
            return;
        }
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            LOG.severe("Data model could not be found.");
            return;
        }
        this.projectPanel = new ProjectPanel();
        this.actionPanel = new ActionPanel();
        this.initialised = true;
    }

    protected void componentOpened() {
        super.componentOpened();
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data != null) {
            this.view(data.getRootProjects());
        }
    }

    public boolean isViewing(Action action) {
        if (action == null) {
            return false;
        }
        if (this.actionPanel == null) {
            return false;
        }
        if (this.actionPanel != this.scrollPane.getViewport().getView()) {
            return false;
        }
        return action.equals((Object)this.actionPanel.getModel());
    }

    public boolean isViewing(Project project) {
        if (project == null) {
            return false;
        }
        if (this.projectPanel == null) {
            return false;
        }
        if (this.projectPanel != this.scrollPane.getViewport().getView()) {
            return false;
        }
        return project.equals((Object)this.projectPanel.getModel());
    }

    private void initComponents() {
        this.emptyPanel = new JPanel();
        this.scrollPane = new JScrollPane();
        this.setLayout(new BorderLayout());
        this.scrollPane.setBorder(null);
        this.add(this.scrollPane, "Center");
    }

    public static synchronized EditorTopComponent getDefault() {
        if (instance == null) {
            instance = new EditorTopComponent();
            instance.initialise();
        }
        return instance;
    }

    public static synchronized EditorTopComponent findInstance() {
        return EditorTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 2;
    }

    public String preferredID() {
        return PREFERRED_ID;
    }

    public void edit(ActionNode actionNode) {
        if (this.actionPanel == null) {
            return;
        }
        this.requestActive();
        this.view((Node)actionNode);
        this.actionPanel.edit();
    }

    public void edit(ProjectNode projectNode) {
        if (this.projectPanel == null) {
            return;
        }
        this.requestActive();
        this.view((Node)projectNode);
        this.projectPanel.edit();
    }

    public void view(Node node) {
        if (node instanceof ActionNode) {
            ActionNode actionNode = (ActionNode)node;
            this.view(actionNode.action);
            this.content.set(Collections.singleton(actionNode), null);
        }
        if (node instanceof ProjectNode) {
            ProjectNode projectNode = (ProjectNode)node;
            this.view(projectNode.project);
            this.content.set(Collections.singleton(projectNode), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void view(Project project) {
        assert (project != null);
        if (!this.isOpened()) {
            return;
        }
        if (this.isViewing(project)) {
            return;
        }
        if (this.viewAction != null) {
            this.viewAction.removePropertyChangeListenter("State", this.actionStateListener);
        }
        this.viewAction = null;
        EditorTopComponent editorTopComponent = this;
        synchronized (editorTopComponent) {
            this.setName(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_ProjectTopComponent"));
            this.setToolTipText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TTT_ProjectTopComponent"));
            this.setIcon(project.getIcon(false).getImage());
            if (project.isEditable()) {
                this.projectPanel.initModel(project);
                this.scrollPane.setViewportView((Component)this.projectPanel);
            } else {
                this.setName(project.getDescription());
                this.scrollPane.setViewportView(this.emptyPanel);
            }
            this.revalidate();
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void view(Action action) {
        if (!this.isOpened()) {
            return;
        }
        if (this.isViewing(action)) {
            return;
        }
        if (this.viewAction != null) {
            this.viewAction.removePropertyChangeListenter("State", this.actionStateListener);
        }
        this.viewAction = action;
        action.addPropertyChangeListenter("State", this.actionStateListener);
        EditorTopComponent editorTopComponent = this;
        synchronized (editorTopComponent) {
            this.setName(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_ActionTopComponent"));
            this.setToolTipText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TTT_ActionTopComponent"));
            this.setIcon(action.getIcon(false).getImage());
            if (action != null && action.isEditable()) {
                this.actionPanel.initModel(action);
                this.scrollPane.setViewportView((Component)this.actionPanel);
            } else {
                this.scrollPane.setViewportView(this.emptyPanel);
            }
            this.revalidate();
            this.repaint();
        }
    }

    private void refreshIcon(final Action action) {
        if (action != null) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    EditorTopComponent.this.setIcon(action.getIcon(false).getImage());
                }
            });
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("tr.view.projects");
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public void takeFocus() {
        ActionNode actionNode = (ActionNode)this.lookup.lookup(ActionNode.class);
        if (actionNode != null) {
            this.actionPanel.requestFocusInWindow();
        } else {
            ProjectNode projectNode = (ProjectNode)this.lookup.lookup(ProjectNode.class);
            if (projectNode != null) {
                this.projectPanel.requestFocusInWindow();
            }
        }
    }
}

