/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cryptlib.CryptlibObjectIdentifiers;
import org.bouncycastle.bcpg.AEADEncDataPacket;
import org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedAsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.RawAgreement;
import org.bouncycastle.crypto.Wrapper;
import org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.bouncycastle.crypto.agreement.X25519Agreement;
import org.bouncycastle.crypto.agreement.X448Agreement;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.X25519PublicKeyParameters;
import org.bouncycastle.crypto.params.X448PublicKeyParameters;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.PGPPad;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.RFC6637Utils;
import org.bouncycastle.openpgp.operator.bc.BcAEADUtil;
import org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPKeyConverter;
import org.bouncycastle.openpgp.operator.bc.BcUtil;
import org.bouncycastle.openpgp.operator.bc.RFC6637KDFCalculator;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;

public class BcPublicKeyDataDecryptorFactory
implements PublicKeyDataDecryptorFactory {
    private static final BcPGPKeyConverter KEY_CONVERTER = new BcPGPKeyConverter();
    private final PGPPrivateKey pgpPrivKey;

    public BcPublicKeyDataDecryptorFactory(PGPPrivateKey pGPPrivateKey) {
        this.pgpPrivKey = pGPPrivateKey;
    }

    @Override
    public byte[] recoverSessionData(int n, byte[][] byArray) throws PGPException {
        try {
            AsymmetricKeyParameter asymmetricKeyParameter = KEY_CONVERTER.getPrivateKey(this.pgpPrivKey);
            if (n == 25) {
                return this.getSessionData(byArray[0], asymmetricKeyParameter, 32, 8, 7, (RawAgreement)new X25519Agreement(), "X25519", new PublicKeyParametersOperation(){

                    @Override
                    public AsymmetricKeyParameter getPublicKeyParameters(byte[] byArray, int n) {
                        return new X25519PublicKeyParameters(byArray, 0);
                    }
                });
            }
            if (n == 26) {
                return this.getSessionData(byArray[0], asymmetricKeyParameter, 56, 10, 9, (RawAgreement)new X448Agreement(), "X448", new PublicKeyParametersOperation(){

                    @Override
                    public AsymmetricKeyParameter getPublicKeyParameters(byte[] byArray, int n) {
                        return new X448PublicKeyParameters(byArray, 0);
                    }
                });
            }
            if (n == 18) {
                ECDomainParameters eCDomainParameters;
                byte[] byArray2;
                byte[] byArray3 = byArray[0];
                int n2 = (((byArray3[0] & 0xFF) << 8) + (byArray3[1] & 0xFF) + 7) / 8;
                BcPublicKeyDataDecryptorFactory.assertOutOfRange(2 + n2 + 1, byArray3);
                byte[] byArray4 = new byte[n2];
                System.arraycopy(byArray3, 2, byArray4, 0, n2);
                int n3 = byArray3[n2 + 2] & 0xFF;
                BcPublicKeyDataDecryptorFactory.assertOutOfRange(2 + n2 + 1 + n3, byArray3);
                byte[] byArray5 = new byte[n3];
                System.arraycopy(byArray3, 2 + n2 + 1, byArray5, 0, n3);
                ECDHPublicBCPGKey eCDHPublicBCPGKey = (ECDHPublicBCPGKey)this.pgpPrivKey.getPublicKeyPacket().getKey();
                if (eCDHPublicBCPGKey.getCurveOID().equals((ASN1Primitive)CryptlibObjectIdentifiers.curvey25519)) {
                    if (byArray4.length != 33 || 64 != byArray4[0]) {
                        throw new IllegalArgumentException("Invalid Curve25519 public key");
                    }
                    byArray2 = BcUtil.getSecret((RawAgreement)new X25519Agreement(), asymmetricKeyParameter, (AsymmetricKeyParameter)new X25519PublicKeyParameters(byArray4, 1));
                } else {
                    eCDomainParameters = ((ECPrivateKeyParameters)asymmetricKeyParameter).getParameters();
                    ECPublicKeyParameters eCPublicKeyParameters = new ECPublicKeyParameters(eCDomainParameters.getCurve().decodePoint(byArray4), eCDomainParameters);
                    ECDHBasicAgreement eCDHBasicAgreement = new ECDHBasicAgreement();
                    eCDHBasicAgreement.init((CipherParameters)asymmetricKeyParameter);
                    BigInteger bigInteger = eCDHBasicAgreement.calculateAgreement((CipherParameters)eCPublicKeyParameters);
                    byArray2 = BigIntegers.asUnsignedByteArray((int)eCDHBasicAgreement.getFieldSize(), (BigInteger)bigInteger);
                }
                byte by = eCDHPublicBCPGKey.getHashAlgorithm();
                byte by2 = eCDHPublicBCPGKey.getSymmetricKeyAlgorithm();
                byte[] byArray6 = RFC6637Utils.createUserKeyingMaterial(this.pgpPrivKey.getPublicKeyPacket(), new BcKeyFingerprintCalculator());
                RFC6637KDFCalculator rFC6637KDFCalculator = new RFC6637KDFCalculator(new BcPGPDigestCalculatorProvider().get(by), by2);
                eCDomainParameters = new KeyParameter(rFC6637KDFCalculator.createKey(byArray2, byArray6));
                return PGPPad.unpadSessionData(BcPublicKeyDataDecryptorFactory.unwrapSessionData(byArray5, by2, (KeyParameter)eCDomainParameters));
            }
            AsymmetricBlockCipher asymmetricBlockCipher = BcImplProvider.createPublicKeyCipher(n);
            BufferedAsymmetricBlockCipher bufferedAsymmetricBlockCipher = new BufferedAsymmetricBlockCipher(asymmetricBlockCipher);
            bufferedAsymmetricBlockCipher.init(false, (CipherParameters)asymmetricKeyParameter);
            if (n == 2 || n == 1) {
                byte[] byArray7 = byArray[0];
                bufferedAsymmetricBlockCipher.processBytes(byArray7, 2, byArray7.length - 2);
            } else {
                ElGamalPrivateKeyParameters elGamalPrivateKeyParameters = (ElGamalPrivateKeyParameters)asymmetricKeyParameter;
                int n4 = (elGamalPrivateKeyParameters.getParameters().getP().bitLength() + 7) / 8;
                byte[] byArray8 = new byte[n4];
                byte[] byArray9 = byArray[0];
                if (byArray9.length - 2 > n4) {
                    bufferedAsymmetricBlockCipher.processBytes(byArray9, 3, byArray9.length - 3);
                } else {
                    System.arraycopy(byArray9, 2, byArray8, byArray8.length - (byArray9.length - 2), byArray9.length - 2);
                    bufferedAsymmetricBlockCipher.processBytes(byArray8, 0, byArray8.length);
                }
                byArray9 = byArray[1];
                Arrays.fill((byte[])byArray8, (byte)0);
                if (byArray9.length - 2 > n4) {
                    bufferedAsymmetricBlockCipher.processBytes(byArray9, 3, byArray9.length - 3);
                } else {
                    System.arraycopy(byArray9, 2, byArray8, byArray8.length - (byArray9.length - 2), byArray9.length - 2);
                    bufferedAsymmetricBlockCipher.processBytes(byArray8, 0, byArray8.length);
                }
            }
            return bufferedAsymmetricBlockCipher.doFinal();
        }
        catch (IOException iOException) {
            throw new PGPException("exception creating user keying material: " + iOException.getMessage(), iOException);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new PGPException("exception decrypting session info: " + invalidCipherTextException.getMessage(), (Exception)((Object)invalidCipherTextException));
        }
    }

    @Override
    public PGPDataDecryptor createDataDecryptor(boolean bl, int n, byte[] byArray) throws PGPException {
        BlockCipher blockCipher = BcImplProvider.createBlockCipher(n);
        return BcUtil.createDataDecryptor(bl, blockCipher, byArray);
    }

    @Override
    public PGPDataDecryptor createDataDecryptor(AEADEncDataPacket aEADEncDataPacket, PGPSessionKey pGPSessionKey) throws PGPException {
        return BcAEADUtil.createOpenPgpV5DataDecryptor(aEADEncDataPacket, pGPSessionKey);
    }

    @Override
    public PGPDataDecryptor createDataDecryptor(SymmetricEncIntegrityPacket symmetricEncIntegrityPacket, PGPSessionKey pGPSessionKey) throws PGPException {
        return BcAEADUtil.createOpenPgpV6DataDecryptor(symmetricEncIntegrityPacket, pGPSessionKey);
    }

    private byte[] getSessionData(byte[] byArray, AsymmetricKeyParameter asymmetricKeyParameter, int n, int n2, int n3, RawAgreement rawAgreement, String string, PublicKeyParametersOperation publicKeyParametersOperation) throws PGPException, InvalidCipherTextException {
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        int n4 = byArray[n] & 0xFF;
        BcPublicKeyDataDecryptorFactory.assertOutOfRange(n + 1 + n4, byArray);
        byte[] byArray3 = new byte[n4 - 1];
        System.arraycopy(byArray, n + 2, byArray3, 0, byArray3.length);
        byte[] byArray4 = BcUtil.getSecret(rawAgreement, asymmetricKeyParameter, publicKeyParametersOperation.getPublicKeyParameters(byArray2, 0));
        KeyParameter keyParameter = new KeyParameter(RFC6637KDFCalculator.createKey(n2, n3, Arrays.concatenate((byte[])byArray2, (byte[])this.pgpPrivKey.getPublicKeyPacket().getKey().getEncoded(), (byte[])byArray4), "OpenPGP " + string));
        return Arrays.concatenate((byte[])new byte[]{byArray[n + 1]}, (byte[])BcPublicKeyDataDecryptorFactory.unwrapSessionData(byArray3, n3, keyParameter));
    }

    private static byte[] unwrapSessionData(byte[] byArray, int n, KeyParameter keyParameter) throws PGPException, InvalidCipherTextException {
        Wrapper wrapper = BcImplProvider.createWrapper(n);
        wrapper.init(false, (CipherParameters)keyParameter);
        return wrapper.unwrap(byArray, 0, byArray.length);
    }

    private static void assertOutOfRange(int n, byte[] byArray) throws PGPException {
        if (n > byArray.length) {
            throw new PGPException("encoded length out of range");
        }
    }

    @FunctionalInterface
    private static interface PublicKeyParametersOperation {
        public AsymmetricKeyParameter getPublicKeyParameters(byte[] var1, int var2);
    }
}

