/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.validation;

import ca.sqlpower.validation.Status;

public class ValidateResult {
    private static final ValidateResult SHARED_OK_RESULT = new ValidateResult(Status.OK, "");
    private Status status;
    private String message;

    private ValidateResult(Status status, String message) {
        if (status == null) {
            throw new IllegalArgumentException("Status may not be null");
        }
        this.status = status;
        this.message = message;
    }

    public static ValidateResult createValidateResult(Status status, String message) {
        if (status == Status.OK && (message == null || message.length() == 0)) {
            return SHARED_OK_RESULT;
        }
        return new ValidateResult(status, message);
    }

    public String getMessage() {
        return this.message;
    }

    public Status getStatus() {
        return this.status;
    }

    public String toString() {
        return "ValidateResult@" + System.identityHashCode(this) + ": status=" + (Object)((Object)this.status) + "; message=" + this.message;
    }
}

