/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.item.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.registry.AbstractProvider;
import org.openhab.core.config.core.Configuration;
import org.openhab.core.items.ActiveItem;
import org.openhab.core.items.GenericItem;
import org.openhab.core.items.GroupFunction;
import org.openhab.core.items.GroupItem;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemFactory;
import org.openhab.core.items.ItemProvider;
import org.openhab.core.items.ItemUtil;
import org.openhab.core.items.dto.GroupFunctionDTO;
import org.openhab.core.items.dto.ItemDTOMapper;
import org.openhab.core.model.core.EventType;
import org.openhab.core.model.core.ModelRepository;
import org.openhab.core.model.core.ModelRepositoryChangeListener;
import org.openhab.core.model.item.BindingConfigParseException;
import org.openhab.core.model.item.BindingConfigReader;
import org.openhab.core.model.item.internal.GenericMetadataProvider;
import org.openhab.core.model.items.ItemModel;
import org.openhab.core.model.items.ModelBinding;
import org.openhab.core.model.items.ModelGroupFunction;
import org.openhab.core.model.items.ModelGroupItem;
import org.openhab.core.model.items.ModelItem;
import org.openhab.core.model.items.ModelNormalItem;
import org.openhab.core.types.StateDescriptionFragment;
import org.openhab.core.types.StateDescriptionFragmentBuilder;
import org.openhab.core.types.StateDescriptionFragmentProvider;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={ItemProvider.class, StateDescriptionFragmentProvider.class}, immediate=true)
public class GenericItemProvider
extends AbstractProvider<Item>
implements ModelRepositoryChangeListener,
ItemProvider,
StateDescriptionFragmentProvider {
    private final Logger logger = LoggerFactory.getLogger(GenericItemProvider.class);
    private final Map<String, BindingConfigReader> bindingConfigReaders = new HashMap<String, BindingConfigReader>();
    private final ModelRepository modelRepository;
    private final GenericMetadataProvider genericMetaDataProvider;
    private final Map<String, Collection<Item>> itemsMap = new ConcurrentHashMap<String, Collection<Item>>();
    private final Collection<ItemFactory> itemFactorys = new ArrayList<ItemFactory>();
    private final Map<String, StateDescriptionFragment> stateDescriptionFragments = new ConcurrentHashMap<String, StateDescriptionFragment>();
    private Integer rank;

    /*
     * WARNING - void declaration
     */
    @Activate
    public GenericItemProvider(@Reference ModelRepository modelRepository, @Reference GenericMetadataProvider genericMetadataProvider, Map<String, Object> properties) {
        Object serviceRanking;
        this.modelRepository = modelRepository;
        this.genericMetaDataProvider = genericMetadataProvider;
        Object object = serviceRanking = properties.get("service.ranking");
        if (object instanceof Integer) {
            void integerValue;
            Integer n = (Integer)object;
            Integer cfr_ignored_0 = (Integer)object;
            this.rank = integerValue;
        } else {
            this.rank = 0;
        }
        this.itemFactorys.forEach(itemFactory -> this.dispatchBindingsPerItemType(itemFactory.getSupportedItemTypes()));
        for (String modelName : modelRepository.getAllModelNamesOfType("items")) {
            this.modelChanged(modelName, EventType.ADDED);
        }
        modelRepository.addModelRepositoryChangeListener((ModelRepositoryChangeListener)this);
    }

    @Deactivate
    protected void deactivate() {
        this.modelRepository.removeModelRepositoryChangeListener((ModelRepositoryChangeListener)this);
    }

    public Integer getRank() {
        return this.rank;
    }

    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC)
    public void addItemFactory(ItemFactory factory) {
        this.itemFactorys.add(factory);
        this.dispatchBindingsPerItemType(factory.getSupportedItemTypes());
    }

    public void removeItemFactory(ItemFactory factory) {
        this.itemFactorys.remove(factory);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addBindingConfigReader(BindingConfigReader reader) {
        if (!this.bindingConfigReaders.containsKey(reader.getBindingType())) {
            this.bindingConfigReaders.put(reader.getBindingType(), reader);
            this.genericMetaDataProvider.removeMetadataByNamespace(reader.getBindingType());
            this.dispatchBindingsPerType(reader, new String[]{reader.getBindingType()});
        } else {
            this.logger.warn("Attempted to register a second BindingConfigReader of type '{}'. The previous reader will remain active!", (Object)reader.getBindingType());
        }
    }

    public void removeBindingConfigReader(BindingConfigReader reader) {
        if (this.bindingConfigReaders.get(reader.getBindingType()).equals(reader)) {
            this.bindingConfigReaders.remove(reader.getBindingType());
        }
    }

    public Collection<Item> getAll() {
        ArrayList<Item> items = new ArrayList<Item>();
        this.stateDescriptionFragments.clear();
        for (String name : this.modelRepository.getAllModelNamesOfType("items")) {
            items.addAll(this.getItemsFromModel(name));
        }
        return items;
    }

    private Collection<Item> getItemsFromModel(String modelName) {
        this.logger.debug("Read items from model '{}'", (Object)modelName);
        ArrayList<Item> items = new ArrayList<Item>();
        ItemModel model = (ItemModel)this.modelRepository.getModel(modelName);
        if (model != null) {
            for (ModelItem modelItem : model.getItems()) {
                Item item = this.createItemFromModelItem(modelItem);
                if (item == null) continue;
                for (String groupName : modelItem.getGroups()) {
                    ((GenericItem)item).addGroupName(groupName);
                }
                items.add(item);
            }
        }
        return items;
    }

    private void processBindingConfigsFromModel(String modelName, EventType type) {
        this.logger.debug("Processing binding configs for items from model '{}'", (Object)modelName);
        ItemModel model = (ItemModel)this.modelRepository.getModel(modelName);
        if (model == null) {
            return;
        }
        for (BindingConfigReader reader : this.bindingConfigReaders.values()) {
            reader.startConfigurationUpdate(modelName);
        }
        if (!EventType.REMOVED.equals((Object)type)) {
            for (ModelItem modelItem : model.getItems()) {
                this.genericMetaDataProvider.removeMetadataByItemName(modelItem.getName());
                Item item = this.createItemFromModelItem(modelItem);
                if (item == null) continue;
                this.internalDispatchBindings(modelName, item, modelItem.getBindings());
            }
        }
        for (BindingConfigReader reader : this.bindingConfigReaders.values()) {
            reader.stopConfigurationUpdate(modelName);
        }
    }

    /*
     * WARNING - void declaration
     */
    private @Nullable Item createItemFromModelItem(ModelItem modelItem) {
        ModelNormalItem normalItem;
        Item item;
        ModelItem modelItem2 = modelItem;
        if (modelItem2 instanceof ModelGroupItem) {
            Item baseItem;
            void modelGroupItem;
            ModelGroupItem modelGroupItem2 = (ModelGroupItem)modelItem2;
            ModelGroupItem cfr_ignored_0 = (ModelGroupItem)modelItem2;
            try {
                baseItem = this.createItemOfType(modelGroupItem.getType(), modelGroupItem.getName());
            }
            catch (IllegalArgumentException e) {
                this.logger.debug("Error creating base item for group item '{}', item will be ignored: {}", (Object)modelGroupItem.getName(), (Object)e.getMessage());
                return null;
            }
            if (baseItem != null) {
                ModelGroupFunction function = modelGroupItem.getFunction();
                item = this.applyGroupFunction(baseItem, (ModelGroupItem)modelGroupItem, function);
            } else {
                item = new GroupItem(modelGroupItem.getName());
            }
        } else {
            normalItem = (ModelNormalItem)modelItem;
            try {
                item = this.createItemOfType(normalItem.getType(), normalItem.getName());
            }
            catch (IllegalArgumentException e) {
                this.logger.debug("Error creating item '{}', item will be ignored: {}", (Object)normalItem.getName(), (Object)e.getMessage());
                return null;
            }
        }
        Item item2 = item;
        if (item2 instanceof ActiveItem) {
            void activeItem;
            normalItem = (ActiveItem)item2;
            ActiveItem cfr_ignored_1 = (ActiveItem)item2;
            String label = modelItem.getLabel();
            String format = this.extractFormat(label);
            if (format != null) {
                label = label.substring(0, label.indexOf("[")).trim();
                this.stateDescriptionFragments.put(modelItem.getName(), StateDescriptionFragmentBuilder.create().withPattern(format).build());
            } else {
                this.stateDescriptionFragments.remove(modelItem.getName());
            }
            activeItem.setLabel(label);
            activeItem.setCategory(modelItem.getIcon());
            this.assignTags(modelItem, (ActiveItem)activeItem);
            return item;
        }
        return null;
    }

    private @Nullable String extractFormat(@Nullable String label) {
        if (label == null) {
            return null;
        }
        String format = null;
        if (label.contains("[") && label.contains("]")) {
            format = label.substring(label.indexOf("[") + 1, label.lastIndexOf("]"));
        }
        return format;
    }

    private void assignTags(ModelItem modelItem, ActiveItem item) {
        EList<String> tags = modelItem.getTags();
        for (String tag : tags) {
            item.addTag(tag);
        }
    }

    private GroupItem applyGroupFunction(Item baseItem, ModelGroupItem modelGroupItem, ModelGroupFunction function) {
        GroupFunctionDTO dto = new GroupFunctionDTO();
        dto.name = function.getName();
        dto.params = (String[])modelGroupItem.getArgs().toArray((Object[])new String[0]);
        GroupFunction groupFunction = ItemDTOMapper.mapFunction((Item)baseItem, (GroupFunctionDTO)dto);
        return new GroupItem(modelGroupItem.getName(), baseItem, groupFunction);
    }

    private void dispatchBindingsPerItemType(String[] itemTypes) {
        for (String modelName : this.modelRepository.getAllModelNamesOfType("items")) {
            ItemModel model = (ItemModel)this.modelRepository.getModel(modelName);
            if (model != null) {
                for (ModelItem modelItem : model.getItems()) {
                    String[] stringArray = itemTypes;
                    int n = itemTypes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Item item;
                        String itemType = stringArray[n2];
                        String type = modelItem.getType();
                        if (type != null && itemType.equals(ItemUtil.getMainItemType((String)type)) && (item = this.createItemFromModelItem(modelItem)) != null) {
                            this.internalDispatchBindings(null, modelName, item, modelItem.getBindings());
                        }
                        ++n2;
                    }
                }
                continue;
            }
            this.logger.debug("Model repository returned NULL for model named '{}'", (Object)modelName);
        }
    }

    private void dispatchBindingsPerType(BindingConfigReader reader, String[] bindingTypes) {
        for (String modelName : this.modelRepository.getAllModelNamesOfType("items")) {
            ItemModel model = (ItemModel)this.modelRepository.getModel(modelName);
            if (model != null) {
                for (ModelItem modelItem : model.getItems()) {
                    for (ModelBinding modelBinding : modelItem.getBindings()) {
                        String[] stringArray = bindingTypes;
                        int n = bindingTypes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Item item;
                            String bindingType = stringArray[n2];
                            if (bindingType.equals(modelBinding.getType()) && (item = this.createItemFromModelItem(modelItem)) != null) {
                                this.internalDispatchBindings(reader, modelName, item, modelItem.getBindings());
                            }
                            ++n2;
                        }
                    }
                }
                continue;
            }
            this.logger.debug("Model repository returned NULL for model named '{}'", (Object)modelName);
        }
    }

    private void internalDispatchBindings(String modelName, Item item, EList<ModelBinding> bindings) {
        this.internalDispatchBindings(null, modelName, item, bindings);
    }

    private void internalDispatchBindings(@Nullable BindingConfigReader reader, String modelName, Item item, EList<ModelBinding> bindings) {
        for (ModelBinding binding : bindings) {
            String bindingType = binding.getType();
            String config = binding.getConfiguration();
            Configuration configuration = new Configuration();
            binding.getProperties().forEach(p -> {
                Object value = p.getValue();
                EList<Object> eList = value;
                if (eList instanceof List) {
                    void listValue;
                    List list = (List)eList;
                    List cfr_ignored_0 = (List)eList;
                    if (listValue.size() == 1) {
                        value = listValue.get(0);
                    }
                }
                configuration.put(p.getKey(), value);
            });
            BindingConfigReader localReader = reader;
            if (reader == null) {
                this.logger.trace("Given binding config reader is null > query cache to find appropriate reader!");
                localReader = this.bindingConfigReaders.get(bindingType);
            } else {
                if (!localReader.getBindingType().equals(binding.getType())) {
                    this.logger.trace("The Readers' binding type '{}' and the Bindings' type '{}' doesn't match > continue processing next binding.", (Object)localReader.getBindingType(), (Object)binding.getType());
                    continue;
                }
                this.logger.debug("Start processing binding configuration of Item '{}' with '{}' reader.", (Object)item, (Object)localReader.getClass().getSimpleName());
            }
            if (localReader != null) {
                try {
                    localReader.validateItemType(item.getType(), config);
                    localReader.processBindingConfiguration(modelName, item.getType(), item.getName(), config, configuration);
                }
                catch (BindingConfigParseException e) {
                    this.logger.error("Binding configuration of type '{}' of item '{}' could not be parsed correctly.", new Object[]{bindingType, item.getName(), e});
                }
                catch (Exception e) {
                    this.logger.error("Binding configuration of type '{}' of item '{}' could not be parsed correctly.", new Object[]{bindingType, item.getName(), e});
                }
                continue;
            }
            this.genericMetaDataProvider.addMetadata(bindingType, item.getName(), config, configuration.getProperties());
        }
    }

    public void modelChanged(String modelName, EventType type) {
        if (modelName.endsWith("items")) {
            switch (type) {
                case ADDED: 
                case MODIFIED: {
                    Map<String, Item> oldItems = this.toItemMap(this.itemsMap.get(modelName));
                    Map<String, Item> newItems = this.toItemMap(this.getItemsFromModel(modelName));
                    this.itemsMap.put(modelName, newItems.values());
                    for (Item newItem : newItems.values()) {
                        Item oldItem = oldItems.get(newItem.getName());
                        if (oldItem != null) {
                            if (!this.hasItemChanged(oldItem, newItem)) continue;
                            this.notifyListenersAboutUpdatedElement(oldItem, newItem);
                            continue;
                        }
                        this.notifyListenersAboutAddedElement(newItem);
                    }
                    this.processBindingConfigsFromModel(modelName, type);
                    for (Item oldItem : oldItems.values()) {
                        if (newItems.containsKey(oldItem.getName())) continue;
                        this.notifyAndCleanup(oldItem);
                    }
                    break;
                }
                case REMOVED: {
                    this.processBindingConfigsFromModel(modelName, type);
                    Collection<Item> itemsFromModel = this.getItemsFromModel(modelName);
                    this.itemsMap.remove(modelName);
                    for (Item item : itemsFromModel) {
                        this.notifyAndCleanup(item);
                    }
                    break;
                }
            }
        }
    }

    private void notifyAndCleanup(Item oldItem) {
        this.notifyListenersAboutRemovedElement(oldItem);
        this.stateDescriptionFragments.remove(oldItem.getName());
        this.genericMetaDataProvider.removeMetadataByItemName(oldItem.getName());
    }

    protected boolean hasItemChanged(Item item1, Item item2) {
        return !Objects.equals(item1.getClass(), item2.getClass()) || !Objects.equals(item1.getName(), item2.getName()) || !Objects.equals(item1.getCategory(), item2.getCategory()) || !Objects.equals(item1.getGroupNames(), item2.getGroupNames()) || !Objects.equals(item1.getLabel(), item2.getLabel()) || !Objects.equals(item1.getTags(), item2.getTags()) || !Objects.equals(item1.getType(), item2.getType()) || this.hasGroupItemChanged(item1, item2);
    }

    /*
     * WARNING - void declaration
     */
    private boolean hasGroupItemChanged(Item item1, Item item2) {
        Item item;
        Object gItem1 = null;
        Object gItem2 = null;
        Item item3 = item1;
        if (item3 instanceof GroupItem) {
            void item4;
            GroupItem groupItem = (GroupItem)item3;
            GroupItem cfr_ignored_0 = (GroupItem)item3;
            gItem1 = item4;
        }
        if ((item = item2) instanceof GroupItem) {
            void item5;
            GroupItem groupItem = (GroupItem)item;
            GroupItem cfr_ignored_1 = (GroupItem)item;
            gItem2 = item5;
        }
        if (gItem1 == null && gItem2 == null) {
            return false;
        }
        if (gItem1 == null || gItem2 == null) {
            return true;
        }
        boolean sameBaseItemClass = Objects.equals(gItem1.getBaseItem(), gItem2.getBaseItem());
        boolean sameFunction = false;
        GroupFunction gf1 = gItem1.getFunction();
        GroupFunction gf2 = gItem2.getFunction();
        if (gf1 != null && gf2 != null) {
            if (Objects.equals(gf1.getClass(), gf2.getClass())) {
                sameFunction = Arrays.equals(gf1.getParameters(), gf2.getParameters());
            }
        } else if (gf1 == null && gf2 == null) {
            sameFunction = true;
        }
        return !sameBaseItemClass || !sameFunction;
    }

    private Map<String, Item> toItemMap(@Nullable Collection<Item> items) {
        if (items == null || items.isEmpty()) {
            return Map.of();
        }
        LinkedHashMap<String, Item> ret = new LinkedHashMap<String, Item>();
        for (Item item : items) {
            ret.put(item.getName(), item);
        }
        return ret;
    }

    private @Nullable Item createItemOfType(@Nullable String itemType, String itemName) {
        if (itemType == null) {
            return null;
        }
        for (ItemFactory factory : this.itemFactorys) {
            Item item = factory.createItem(itemType, itemName);
            if (item == null) continue;
            this.logger.trace("Created item '{}' of type '{}'", (Object)itemName, (Object)itemType);
            return item;
        }
        this.logger.debug("Couldn't find ItemFactory for item '{}' of type '{}'", (Object)itemName, (Object)itemType);
        return null;
    }

    public @Nullable StateDescriptionFragment getStateDescriptionFragment(String itemName, @Nullable Locale locale) {
        return this.stateDescriptionFragments.get(itemName);
    }
}

