/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.manager.api;

import com.sun.tools.ws.processor.model.java.JavaMethod;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlOperation;
import org.netbeans.modules.websvc.manager.model.WebServiceData;

public class WebServiceMetaDataTransfer {
    public static final DataFlavor PORT_FLAVOR;
    public static final DataFlavor METHOD_FLAVOR;
    public static final DataFlavor METHOD_NODE_FLAVOR;
    protected static final DataFlavor PORT_NODE_FLAVOR;

    static {
        try {
            PORT_FLAVOR = new DataFlavor("application/x-java-netbeans-websvcmgr-port;class=org.netbeans.modules.websvc.manager.api.WebServiceMetaDataTransfer$Port");
            PORT_NODE_FLAVOR = new DataFlavor("application/x-java-netbeans-websvcmgr-port;class=org.openide.nodes.Node");
            METHOD_FLAVOR = new DataFlavor("application/x-java-netbeans-websvcmgr-method;class=org.netbeans.modules.websvc.manager.api.WebServiceMetaDataTransfer$Method");
            METHOD_NODE_FLAVOR = new DataFlavor("application/x-java-netbeans-websvcmgr-method;class=org.openide.nodes.Node");
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static final class PortTransferable
    implements Transferable {
        private static final DataFlavor[] SUPPORTED_FLAVORS = new DataFlavor[]{PORT_FLAVOR, PORT_NODE_FLAVOR};
        private final Port transferData;

        public PortTransferable(Port transferData) {
            this.transferData = transferData;
        }

        public PortTransferable(Method method) {
            WebServiceData wsData = method.getWebServiceData();
            String portName = method.getPortName();
            this.transferData = new Port(wsData, portName);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return SUPPORTED_FLAVORS;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor == SUPPORTED_FLAVORS[0] || flavor == SUPPORTED_FLAVORS[1];
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.transferData;
        }
    }

    public static final class MethodTransferable
    implements Transferable {
        private static final DataFlavor[] SUPPORTED_FLAVORS = new DataFlavor[]{METHOD_FLAVOR, METHOD_NODE_FLAVOR};
        private final Method transferData;

        public MethodTransferable(Method transferData) {
            this.transferData = transferData;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return SUPPORTED_FLAVORS;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor == SUPPORTED_FLAVORS[0] || flavor == SUPPORTED_FLAVORS[1];
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.transferData;
        }
    }

    public static final class Method {
        private final WebServiceData wsData;
        private final JavaMethod method;
        private final String portName;
        private final WsdlOperation operation;

        public Method(WebServiceData wsData, JavaMethod method, String portName, WsdlOperation operation) {
            this.wsData = wsData;
            this.method = method;
            this.portName = portName;
            this.operation = operation;
        }

        public WebServiceData getWebServiceData() {
            return this.wsData;
        }

        public JavaMethod getMethod() {
            return this.method;
        }

        public String getPortName() {
            return this.portName;
        }

        public WsdlOperation getOperation() {
            return this.operation;
        }
    }

    public static final class Port {
        private final WebServiceData wsData;
        private final String portName;

        public Port(WebServiceData wsData, String portName) {
            this.wsData = wsData;
            this.portName = portName;
        }

        public WebServiceData getWebServiceData() {
            return this.wsData;
        }

        public String getPortName() {
            return this.portName;
        }
    }
}

