/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mylyn.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentHandler;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentSource;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.netbeans.modules.mylyn.util.BugtrackingCommand;

public class PostAttachmentCommand
extends BugtrackingCommand {
    private final TaskAttribute attAttribute;
    private final TaskRepository taskRepository;
    private final AbstractRepositoryConnector repositoryConnector;
    private String stringValue;
    private final ITask task;
    private final AbstractTaskAttachmentSource taskAttachmentSource;
    private final String comment;

    public PostAttachmentCommand(AbstractRepositoryConnector repositoryConnector, TaskRepository taskRepository, ITask task, TaskAttribute ta, AbstractTaskAttachmentSource taskAttachmentSource, String comment) {
        this.attAttribute = ta;
        this.task = task;
        this.taskRepository = taskRepository;
        this.repositoryConnector = repositoryConnector;
        this.taskAttachmentSource = taskAttachmentSource;
        this.comment = comment;
    }

    @Override
    public void execute() throws CoreException, IOException, MalformedURLException {
        AbstractTaskAttachmentHandler taskAttachmentHandler;
        Logger log = Logger.getLogger(this.getClass().getName());
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "executing PostTaskDataCommand for task: {0}", this.task.getTaskId());
        }
        if (!(taskAttachmentHandler = this.repositoryConnector.getTaskAttachmentHandler()).canPostContent(this.taskRepository, this.task)) {
            throw new IOException("Cannot post attachment for task with id: " + this.task.getTaskId());
        }
        taskAttachmentHandler.postContent(this.taskRepository, this.task, this.taskAttachmentSource, this.comment, this.attAttribute, (IProgressMonitor)new NullProgressMonitor());
    }

    public String toString() {
        if (this.stringValue == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("PostAttachmentCommand [repository=");
            sb.append(this.taskRepository.getUrl());
            sb.append(",id=");
            sb.append(this.task.getTaskId());
            sb.append(",comment=");
            sb.append(this.comment);
            sb.append(",attachment=");
            sb.append(this.taskAttachmentSource.getName());
            sb.append(",desc=");
            TaskAttribute ta = this.attAttribute.getMappedAttribute("task.common.attachment.description");
            sb.append(ta != null ? ta.getValue() : "");
            sb.append(",filename=");
            ta = this.attAttribute.getMappedAttribute("filename");
            sb.append(ta != null ? ta.getValue() : "");
            sb.append(",contentType=");
            ta = this.attAttribute.getMappedAttribute("task.common.attachment.ctype");
            sb.append(ta != null ? ta.getValue() : "");
            sb.append("]");
            this.stringValue = sb.toString();
        }
        return this.stringValue;
    }
}

