/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.gsf.testrunner.plugin.CommonPlugin;
import org.netbeans.modules.junit.AbstractTestGenerator;
import org.netbeans.modules.junit.JUnit3TestGenerator;
import org.netbeans.modules.junit.JUnit4TestGenerator;
import org.netbeans.modules.junit.JUnit5TestGenerator;
import org.netbeans.modules.junit.TestGeneratorSetup;
import org.netbeans.modules.junit.TestabilityJudge;
import org.netbeans.modules.junit.TestabilityResult;
import org.netbeans.modules.junit.api.JUnitTestUtil;
import org.netbeans.modules.junit.api.JUnitVersion;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class TestCreator
implements TestabilityJudge {
    static final Set<Modifier> ACCESS_MODIFIERS = EnumSet.of(Modifier.PUBLIC, Modifier.PROTECTED, Modifier.PRIVATE);
    private final TestGeneratorSetup setup;
    private final JUnitVersion junitVersion;

    TestCreator(boolean loadDefaults, JUnitVersion junitVersion) {
        this.setup = new TestGeneratorSetup(loadDefaults);
        this.junitVersion = junitVersion;
    }

    TestCreator(Map<CommonPlugin.CreateTestParam, Object> params, JUnitVersion junitVersion) {
        this.setup = new TestGeneratorSetup(params);
        this.junitVersion = junitVersion;
    }

    public void createEmptyTest(FileObject testFileObj) throws IOException {
        AbstractTestGenerator testGenerator;
        switch (this.junitVersion) {
            case JUNIT3: {
                testGenerator = new JUnit3TestGenerator(this.setup, JUnitTestUtil.getSourceLevel(testFileObj));
                break;
            }
            case JUNIT4: {
                testGenerator = new JUnit4TestGenerator(this.setup);
                break;
            }
            case JUNIT5: {
                testGenerator = new JUnit5TestGenerator(this.setup);
                break;
            }
            default: {
                throw new IllegalStateException("junit version not set");
            }
        }
        this.doModifications(testFileObj, testGenerator);
    }

    public void createSimpleTest(ElementHandle<TypeElement> topClassToTest, FileObject testFileObj, boolean isNewTestClass) throws IOException {
        AbstractTestGenerator testGenerator;
        switch (this.junitVersion) {
            case JUNIT3: {
                testGenerator = new JUnit3TestGenerator(this.setup, Collections.singletonList(topClassToTest), null, isNewTestClass, JUnitTestUtil.getSourceLevel(testFileObj));
                break;
            }
            case JUNIT4: {
                testGenerator = new JUnit4TestGenerator(this.setup, Collections.singletonList(topClassToTest), null, isNewTestClass);
                break;
            }
            case JUNIT5: {
                testGenerator = new JUnit5TestGenerator(this.setup, Collections.singletonList(topClassToTest), null, isNewTestClass);
                break;
            }
            default: {
                throw new IllegalStateException("junit version not set");
            }
        }
        this.doModifications(testFileObj, testGenerator);
    }

    public List<String> createTestSuite(List<String> suiteMembers, FileObject testFileObj, boolean isNewTestClass) throws IOException {
        AbstractTestGenerator testGenerator;
        switch (this.junitVersion) {
            case JUNIT3: {
                testGenerator = new JUnit3TestGenerator(this.setup, null, suiteMembers, isNewTestClass, JUnitTestUtil.getSourceLevel(testFileObj));
                break;
            }
            case JUNIT4: {
                testGenerator = new JUnit4TestGenerator(this.setup, null, suiteMembers, isNewTestClass);
                break;
            }
            case JUNIT5: {
                testGenerator = new JUnit5TestGenerator(this.setup, null, suiteMembers, isNewTestClass);
                String message = NbBundle.getMessage(this.getClass(), (String)"MSG_using_junit5_for_test_suites");
                JUnitTestUtil.notifyUser(message, 1);
                break;
            }
            default: {
                throw new IllegalStateException("junit version not set");
            }
        }
        this.doModifications(testFileObj, testGenerator);
        return testGenerator.getProcessedClassNames();
    }

    private void doModifications(FileObject testFileObj, final AbstractTestGenerator testGenerator) throws IOException {
        final JavaSource javaSource = JavaSource.forFileObject((FileObject)testFileObj);
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController parameter) throws Exception {
                ModificationResult result = javaSource.runModificationTask((Task)testGenerator);
                result.commit();
            }
        }, true);
    }

    @Override
    public TestabilityResult isClassTestable(CompilationInfo compInfo, TypeElement classElem, long skipTestabilityResultMask) {
        return this.setup.isClassTestable(compInfo, classElem, skipTestabilityResultMask);
    }

    @Override
    public boolean isMethodTestable(ExecutableElement method) {
        return this.setup.isMethodTestable(method);
    }
}

