/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.commit;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseListener;
import org.netbeans.modules.git.ui.commit.MessageArea;
import org.netbeans.modules.versioning.util.common.CommitMessageMouseAdapter;

public class MessageAreaBuilder {
    private String accessibleName;
    private String accessibleDesc;
    private int numberOfChars;
    private int numberOfTitleChars;

    public MessageArea build() {
        MessageArea messageTextArea = new MessageArea();
        if (this.numberOfChars > 0 || this.numberOfTitleChars > 0) {
            Font orig = messageTextArea.getFont();
            Font f = Font.decode("Monospaced").deriveFont(orig.getStyle(), orig.getSize());
            messageTextArea.setFont(f);
        }
        messageTextArea.setColumns(60);
        messageTextArea.setLineWrap(true);
        messageTextArea.setRows(4);
        messageTextArea.setTabSize(4);
        messageTextArea.setWrapStyleWord(true);
        messageTextArea.setMinimumSize(new Dimension(100, 18));
        if (this.accessibleName != null) {
            messageTextArea.getAccessibleContext().setAccessibleName(this.accessibleName);
        }
        messageTextArea.getAccessibleContext().setAccessibleDescription(this.accessibleDesc);
        messageTextArea.addMouseListener((MouseListener)new CommitMessageMouseAdapter());
        messageTextArea.setNumberOfTitleChars(this.numberOfTitleChars);
        messageTextArea.setNumberOfChars(this.numberOfChars);
        return messageTextArea;
    }

    public MessageAreaBuilder setAccessibleName(String acsn) {
        this.accessibleName = acsn;
        return this;
    }

    public MessageAreaBuilder setAccessibleDescription(String acsd) {
        this.accessibleDesc = acsd;
        return this;
    }

    public MessageAreaBuilder setWraplineHint(int numberOfChars) {
        this.numberOfChars = numberOfChars;
        return this;
    }

    public MessageAreaBuilder setTitleHint(int numberOfTitleChars) {
        this.numberOfTitleChars = numberOfTitleChars;
        return this;
    }
}

