/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.completion.util;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Document;
import org.netbeans.modules.xml.schema.completion.spi.CompletionContext;
import org.netbeans.modules.xml.schema.completion.spi.CompletionModelProvider;
import org.netbeans.modules.xml.schema.completion.util.CompletionContextImpl;
import org.netbeans.modules.xml.schema.completion.util.CompletionModelEx;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.openide.util.lookup.Lookups;

public class MetaSchemaModelProvider
extends CompletionModelProvider {
    private CompletionContextImpl context;

    @Override
    public List<CompletionModelProvider.CompletionModel> getModels(CompletionContext context) {
        if (context == null || context.getPrimaryFile() == null || context.getPrimaryFile().getExt() == null || !"xsd".equals(context.getPrimaryFile().getExt())) {
            return null;
        }
        SchemaModel sm = this.createMetaSchemaModel();
        if (sm == null) {
            return null;
        }
        CompletionModelEx cm = new CompletionModelEx((CompletionContextImpl)context, "xsd", sm);
        ArrayList<CompletionModelProvider.CompletionModel> models = new ArrayList<CompletionModelProvider.CompletionModel>();
        models.add(cm);
        return models;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SchemaModel createMetaSchemaModel() {
        SchemaModel schemaModel;
        InputStream in = this.getClass().getResourceAsStream("XMLSchema.xsd");
        try {
            Document d = AbstractDocumentModel.getAccessProvider().loadSwingDocument(in);
            ModelSource ms = new ModelSource(Lookups.singleton((Object)d), false);
            SchemaModel m = (SchemaModel)SchemaModelFactory.getDefault().createFreshModel(ms);
            m.sync();
            schemaModel = m;
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (Exception exception) {
                return null;
            }
        }
        in.close();
        return schemaModel;
    }
}

