/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.env;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import jdk.jshell.JShell;
import jdk.jshell.spi.ExecutionControlProvider;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.project.Project;
import org.netbeans.modules.jshell.env.ConfigurableClasspath;
import org.netbeans.modules.jshell.env.ShellEvent;
import org.netbeans.modules.jshell.env.ShellListener;
import org.netbeans.modules.jshell.env.ShellRegistry;
import org.netbeans.modules.jshell.env.ShellStatus;
import org.netbeans.modules.jshell.env.WriterOutputStream;
import org.netbeans.modules.jshell.model.ConsoleEvent;
import org.netbeans.modules.jshell.model.ConsoleListener;
import org.netbeans.modules.jshell.project.ShellProjectUtils;
import org.netbeans.modules.jshell.support.ShellSession;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Pair;
import org.openide.util.Task;
import org.openide.util.WeakListeners;
import org.openide.util.io.ReaderInputStream;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class JShellEnvironment {
    public static final String PROP_DOCUMENT = "document";
    private FileObject workRoot;
    private FileObject consoleFile;
    private ShellSession shellSession;
    private final Project project;
    private ClasspathInfo classpathInfo;
    private JavaPlatform platform;
    private String displayName;
    private ConfigurableClasspath userClassPathImpl = new ConfigurableClasspath();
    private ClassPath userLibraryPath = ClassPathFactory.createClassPath((ClassPathImplementation)this.userClassPathImpl);
    private ClassPath snippetClassPath;
    private InputOutput inputOutput;
    private boolean controlsIO;
    private boolean closed;
    private List<ShellListener> shellListeners = new ArrayList<ShellListener>();
    private Lookup envLookup;
    private final ShellL shellL = new ShellL();
    private Document document;
    private L inst;
    private PrintStream outStream;
    private PrintStream errStream;
    private volatile boolean starting;
    private List<String> requiredModules;

    protected JShellEnvironment(Project project, String displayName) {
        this.project = project;
        this.displayName = displayName;
    }

    public void appendClassPath(FileObject f) {
        this.userClassPathImpl.append(f);
    }

    public Project getProject() {
        return this.project;
    }

    public JavaPlatform getPlatform() {
        return this.platform;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    void init(FileObject workRoot) throws IOException {
        this.workRoot = workRoot;
        workRoot.setAttribute("jshell.scratch", (Object)true);
        this.consoleFile = workRoot.createData("console.jsh");
        EditorCookie.Observable eob = (EditorCookie.Observable)this.consoleFile.getLookup().lookup(EditorCookie.Observable.class);
        this.inst = new L();
        eob.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.inst, (Object)eob));
        this.platform = ShellProjectUtils.findPlatform(this.project);
    }

    protected InputOutput createInputOutput() {
        return null;
    }

    public InputStream getInputStream() throws IOException {
        if (this.inputOutput == null) {
            throw new IllegalStateException("not started");
        }
        return new ReaderInputStream((Reader)new FilterReader(this.inputOutput.getIn()){

            @Override
            public void close() throws IOException {
            }
        }, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lookup getLookup() {
        JShellEnvironment jShellEnvironment = this;
        synchronized (jShellEnvironment) {
            if (this.envLookup == null) {
                this.envLookup = new ProxyLookup(new Lookup[]{this.consoleFile.getLookup(), this.project == null ? Lookup.getDefault() : this.project.getLookup()});
            }
        }
        return this.envLookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintStream getOutputStream() throws IOException {
        if (this.inputOutput == null) {
            throw new IllegalStateException("not started");
        }
        JShellEnvironment jShellEnvironment = this;
        synchronized (jShellEnvironment) {
            if (this.outStream == null) {
                this.outStream = new PrintStream(new WriterOutputStream((Writer)this.inputOutput.getOut())){

                    @Override
                    public void close() {
                    }
                };
            }
        }
        return this.outStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintStream getErrorStream() throws IOException {
        if (this.inputOutput == null) {
            throw new IllegalStateException("not started");
        }
        JShellEnvironment jShellEnvironment = this;
        synchronized (jShellEnvironment) {
            if (this.errStream == null) {
                this.errStream = new PrintStream(new WriterOutputStream((Writer)this.inputOutput.getOut())){

                    @Override
                    public void close() {
                    }
                };
            }
        }
        return this.errStream;
    }

    public SpecificationVersion getSourceLevel() {
        Project p = this.getProject();
        if (p == null) {
            return this.getTargetLevel();
        }
        SourceLevelQuery.Result r = SourceLevelQuery.getSourceLevel2((FileObject)p.getProjectDirectory());
        String s = r.getSourceLevel();
        if (s != null) {
            return new SpecificationVersion(s);
        }
        return this.getTargetLevel();
    }

    public SpecificationVersion getTargetLevel() {
        return this.getPlatform().getSpecification().getVersion();
    }

    public List<String> getCompilerRequiredModules() {
        return this.requiredModules;
    }

    public JShell.Builder customizeJShell(JShell.Builder b) {
        if (ShellProjectUtils.isModularProject(this.project)) {
            if (this.requiredModules != null) {
                b.compilerOptions("--add-modules", String.join((CharSequence)",", this.requiredModules));
            }
            List<String> opts = ShellProjectUtils.launchVMOptions(this.project);
            b.remoteVMOptions((String[])opts.toArray(String[]::new));
            String modPath = this.addRoots("", ShellProjectUtils.projectRuntimeModulePath(this.project));
            if (!modPath.isEmpty()) {
                b.remoteVMOptions("--module-path", modPath);
            }
        }
        return b;
    }

    public ClassPath getVMClassPath() {
        return ShellProjectUtils.projecRuntimeClassPath(this.project);
    }

    public ClassPath getCompilerClasspath() {
        if (ShellProjectUtils.isModularProject(this.project)) {
            return this.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.MODULE_COMPILE);
        }
        return this.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.COMPILE);
    }

    private String addRoots(String prev, ClassPath cp) {
        FileObject[] roots = cp.getRoots();
        StringBuilder sb = new StringBuilder(prev);
        for (FileObject r : roots) {
            File f;
            FileObject ar = FileUtil.getArchiveFile((FileObject)r);
            if (ar == null) {
                ar = r;
            }
            if ((f = FileUtil.toFile((FileObject)ar)) == null) continue;
            if (sb.length() > 0) {
                sb.append(File.pathSeparatorChar);
            }
            sb.append(f.getPath());
        }
        return sb.toString();
    }

    public synchronized void start() throws IOException {
        ClasspathInfo cpi;
        assert (this.workRoot != null);
        if (this.shellSession != null) {
            return;
        }
        this.inputOutput = this.createInputOutput();
        if (this.inputOutput == null) {
            this.inputOutput = IOProvider.getDefault().getIO(this.displayName, false);
            this.controlsIO = true;
        }
        JavaPlatform platformTemp = this.getPlatform();
        ArrayList<URL> roots = new ArrayList<URL>();
        FileObject root = ShellProjectUtils.findProjectRoots(this.getProject(), roots);
        this.snippetClassPath = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{this.workRoot});
        if (root != null) {
            ArrayList<String> sortedModules;
            ClassPath modCompile;
            ClassPath modClass;
            boolean modular = ShellProjectUtils.isModularProject(this.project);
            ClasspathInfo projectInfo = ClasspathInfo.create((FileObject)root);
            ClasspathInfo.Builder bld = new ClasspathInfo.Builder(projectInfo.getClassPath(ClasspathInfo.PathKind.BOOT));
            ClassPath classesFromProject = ClassPathSupport.createClassPath((URL[])((URL[])roots.toArray(URL[]::new)));
            ClassPath modBoot = projectInfo.getClassPath(ClasspathInfo.PathKind.MODULE_BOOT);
            ClassPath modClassRaw = projectInfo.getClassPath(ClasspathInfo.PathKind.MODULE_CLASS);
            ClassPath modCompileRaw = projectInfo.getClassPath(ClasspathInfo.PathKind.MODULE_COMPILE);
            ClassPath compile = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{classesFromProject, this.userLibraryPath, projectInfo.getClassPath(ClasspathInfo.PathKind.COMPILE)});
            if (modular) {
                modClass = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{classesFromProject, this.userLibraryPath, modClassRaw});
                modCompile = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{classesFromProject, modCompileRaw});
            } else {
                modClass = modClassRaw;
                modCompile = modCompileRaw;
            }
            bld.setClassPath(compile);
            bld.setModuleBootPath(modBoot).setModuleClassPath(modClass).setModuleCompilePath(modCompile);
            cpi = bld.build();
            if (ShellProjectUtils.isModularProject(this.project) && !(sortedModules = new ArrayList<String>(ShellProjectUtils.findProjectImportedModules(this.project, null))).isEmpty()) {
                Collections.sort(sortedModules);
                this.requiredModules = sortedModules;
            }
        } else {
            ClasspathInfo.Builder bld = new ClasspathInfo.Builder(platformTemp.getBootstrapLibraries());
            bld.setClassPath(platformTemp.getStandardLibraries());
            if (ShellProjectUtils.isModularJDK(platformTemp)) {
                bld.setModuleBootPath(platformTemp.getBootstrapLibraries());
            }
            cpi = bld.build();
        }
        this.classpathInfo = cpi;
        this.forceOpenDocument();
        this.doStartAndFire(ShellSession.createSession(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireShellStatus(ShellEvent event) {
        ArrayList<ShellListener> ll;
        JShellEnvironment jShellEnvironment = this;
        synchronized (jShellEnvironment) {
            ll = new ArrayList<ShellListener>(this.shellListeners);
        }
        if (ll.isEmpty()) {
            return;
        }
        ll.stream().forEach(l -> l.shellStatusChanged(event));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireShellStarted(ShellEvent event) {
        ArrayList<ShellListener> ll;
        JShellEnvironment jShellEnvironment = this;
        synchronized (jShellEnvironment) {
            ll = new ArrayList<ShellListener>(this.shellListeners);
        }
        if (ll.isEmpty()) {
            return;
        }
        ShellEvent e = event == null ? new ShellEvent(this) : event;
        ll.stream().forEach(l -> l.shellStarted(e));
    }

    public boolean canReset() {
        return true;
    }

    public void reset() {
        assert (this.workRoot != null);
        this.doStartAndFire(ShellSession.createSession(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireExecuting(ShellSession session, boolean start) {
        ArrayList<ShellListener> ll;
        JShellEnvironment jShellEnvironment = this;
        synchronized (jShellEnvironment) {
            ll = new ArrayList<ShellListener>(this.shellListeners);
        }
        if (ll.isEmpty()) {
            return;
        }
        ShellEvent e = new ShellEvent(this, session, start ? ShellStatus.EXECUTE : ShellStatus.READY, false);
        ll.stream().forEach(l -> l.shellStatusChanged(e));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStartAndFire(final ShellSession nss) {
        JShellEnvironment jShellEnvironment = this;
        synchronized (jShellEnvironment) {
            this.shellSession = nss;
            this.starting = true;
        }
        Pair<ShellSession, Task> res = nss.start();
        nss.getModel().addConsoleListener(new ConsoleListener(){

            @Override
            public void executing(ConsoleEvent e) {
                JShellEnvironment.this.fireExecuting(nss, e.isStart());
            }

            @Override
            public void sectionCreated(ConsoleEvent e) {
            }

            @Override
            public void sectionUpdated(ConsoleEvent e) {
            }

            @Override
            public void closed(ConsoleEvent e) {
            }
        });
        ShellSession previous = (ShellSession)res.first();
        if (previous != null) {
            previous.removePropertyChangeListener(this.shellL);
        }
        nss.addPropertyChangeListener(this.shellL);
        ShellEvent event = new ShellEvent(this, nss, previous);
        this.fireShellStatus(event);
        ((Task)res.second()).addTaskListener(e -> {
            JShellEnvironment jShellEnvironment = this;
            synchronized (jShellEnvironment) {
                this.starting = false;
                if (this.shellSession != nss) {
                    return;
                }
            }
            if (nss.isValid() && nss.isActive()) {
                this.fireShellStarted(event);
            }
            this.fireShellStatus(event);
        });
    }

    public synchronized ShellStatus getStatus() {
        ShellSession session = this.shellSession;
        if (session == null) {
            return ShellStatus.INIT;
        }
        if (this.starting) {
            return ShellStatus.STARTING;
        }
        if (this.closed) {
            return ShellStatus.SHUTDOWN;
        }
        if (session.getModel().isExecute()) {
            return ShellStatus.EXECUTE;
        }
        if (session.isValid()) {
            return ShellStatus.READY;
        }
        return ShellStatus.DISCONNECTED;
    }

    public ShellSession getSession() {
        return this.shellSession;
    }

    public ClasspathInfo getClasspathInfo() {
        return this.classpathInfo;
    }

    public FileObject getWorkRoot() {
        return this.workRoot;
    }

    public FileObject getConsoleFile() {
        return this.consoleFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document forceOpenDocument() throws IOException {
        EditorCookie cake = (EditorCookie)this.consoleFile.getLookup().lookup(EditorCookie.class);
        if (cake == null) {
            return null;
        }
        StyledDocument d = cake.openDocument();
        JShellEnvironment jShellEnvironment = this;
        synchronized (jShellEnvironment) {
            this.document = d;
        }
        return d;
    }

    public synchronized Document getConsoleDocument() {
        return this.document;
    }

    public ClassPath getSnippetClassPath() {
        return this.snippetClassPath;
    }

    public ClassPath getUserLibraryPath() {
        return this.userLibraryPath;
    }

    public Task shutdown() throws IOException {
        Task t = this.shellSession.closeSession();
        t.addTaskListener(e -> this.postCloseCleanup());
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postCloseCleanup() {
        try {
            DataObject d = DataObject.find((FileObject)this.getConsoleFile());
            EditorCookie cake = (EditorCookie)d.getLookup().lookup(EditorCookie.class);
            cake.close();
            JShellEnvironment jShellEnvironment = this;
            synchronized (jShellEnvironment) {
                if (this.document == null) {
                    return;
                }
                this.document = null;
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (this.controlsIO) {
            this.inputOutput.closeInputOutput();
        }
        ShellRegistry.get().closed(this);
    }

    public void open() throws IOException {
        assert (this.workRoot != null);
        DataObject d = DataObject.find((FileObject)this.getConsoleFile());
        EditorCookie cake = (EditorCookie)d.getLookup().lookup(EditorCookie.class);
        if (this.shellSession != null) {
            cake.open();
            this.document = cake.openDocument();
            return;
        }
        this.start();
        cake.open();
        if (this.inputOutput != null) {
            this.inputOutput.select();
        }
        EditorCookie.Observable oo = (EditorCookie.Observable)d.getLookup().lookup(EditorCookie.Observable.class);
        assert (oo != null);
        oo.addPropertyChangeListener(e -> {
            if ("openedPanes".equals(e.getPropertyName()) && cake.getOpenedPanes() == null) {
                try {
                    this.shutdown();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
        this.inputOutput.select();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyDisconnected(ShellSession old, boolean remoteClose) {
        ArrayList<ShellListener> ll;
        ShellSession s;
        JShellEnvironment jShellEnvironment = this;
        synchronized (jShellEnvironment) {
            s = this.shellSession;
            if (s == null || this.closed) {
                return;
            }
            ll = new ArrayList<ShellListener>(this.shellListeners);
        }
        old.notifyClosed(this, remoteClose);
        ShellEvent e = new ShellEvent(this, s, ShellStatus.DISCONNECTED, remoteClose);
        ll.stream().forEach(l -> l.shellStatusChanged(e));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyShutdown(boolean remote) {
        ShellSession s;
        ArrayList<ShellListener> ll;
        JShellEnvironment jShellEnvironment = this;
        synchronized (jShellEnvironment) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            ll = new ArrayList<ShellListener>(this.shellListeners);
            s = this.shellSession;
        }
        if (s != null) {
            s.notifyClosed(this, remote);
        }
        ShellEvent e = new ShellEvent(this);
        ll.stream().forEach(l -> l.shellShutdown(e));
        if (this.controlsIO && this.inputOutput != null) {
            try {
                this.inputOutput.getIn().close();
                this.inputOutput.getOut().close();
                this.inputOutput.getErr().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addShellListener(ShellListener l) {
        JShellEnvironment jShellEnvironment = this;
        synchronized (jShellEnvironment) {
            this.shellListeners.add(l);
            if (!this.closed) {
                return;
            }
        }
        l.shellShutdown(new ShellEvent(this));
    }

    public synchronized void removeShellListener(ShellListener l) {
        this.shellListeners.remove(l);
    }

    public ExecutionControlProvider createExecutionEnv() {
        return null;
    }

    public boolean closeDeadEditor() {
        if (this.getStatus() == ShellStatus.SHUTDOWN) {
            return this.closeEditor();
        }
        return false;
    }

    public boolean closeEditor() {
        EditorCookie cake = (EditorCookie)this.getConsoleFile().getLookup().lookup(EditorCookie.class);
        if (cake == null) {
            return true;
        }
        return cake.close();
    }

    public String getMode() {
        return "launch";
    }

    public JShell getShell() {
        ShellSession s = this.shellSession;
        return s == null ? null : s.getShell();
    }

    private class ShellL
    implements PropertyChangeListener {
        private ShellL() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ShellSession s;
            if ("active".equals(evt.getPropertyName()) && (s = JShellEnvironment.this.shellSession) != null && s.isValid() && s.isActive()) {
                ShellEvent ev = new ShellEvent(JShellEnvironment.this, JShellEnvironment.this.shellSession, JShellEnvironment.this.shellSession);
                JShellEnvironment.this.fireShellStarted(ev);
            }
        }
    }

    private class L
    implements PropertyChangeListener {
        private L() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (JShellEnvironment.PROP_DOCUMENT.equals(evt.getPropertyName())) {
                // empty if block
            }
        }
    }
}

