/*
 * Decompiled with CFR 0.152.
 */
package javax.tools;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.tools.JavaFileManager;

public enum StandardLocation implements JavaFileManager.Location
{
    CLASS_OUTPUT,
    SOURCE_OUTPUT,
    CLASS_PATH,
    SOURCE_PATH,
    ANNOTATION_PROCESSOR_PATH,
    ANNOTATION_PROCESSOR_MODULE_PATH,
    PLATFORM_CLASS_PATH,
    NATIVE_HEADER_OUTPUT,
    MODULE_SOURCE_PATH,
    UPGRADE_MODULE_PATH,
    SYSTEM_MODULES,
    MODULE_PATH,
    PATCH_MODULE_PATH;

    private static final ConcurrentHashMap<String, JavaFileManager.Location> LOCATIONS;

    static final boolean computeIsModuleOrientedLocation(String name) {
        return LazyPatternHolder.MODULE_WORD_PATTERN.matcher(name).matches();
    }

    public static JavaFileManager.Location locationFor(final String name) {
        JavaFileManager.Location exist;
        Objects.requireNonNull(name, "name");
        JavaFileManager.Location loc = LOCATIONS.get(name);
        if (loc != null) {
            return loc;
        }
        JavaFileManager.Location newLoc = null;
        for (StandardLocation location : StandardLocation.values()) {
            if (!location.getName().equals(name)) continue;
            newLoc = location;
            break;
        }
        if (newLoc == null) {
            final boolean isOutputLocation = name.endsWith("_OUTPUT");
            final boolean isModuleOrientedLocation = StandardLocation.computeIsModuleOrientedLocation(name);
            newLoc = new JavaFileManager.Location(){

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public boolean isOutputLocation() {
                    return isOutputLocation;
                }

                @Override
                public boolean isModuleOrientedLocation() {
                    return isModuleOrientedLocation;
                }
            };
        }
        return (exist = (JavaFileManager.Location)LOCATIONS.putIfAbsent(name, newLoc)) != null ? exist : newLoc;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public boolean isOutputLocation() {
        switch (this.ordinal()) {
            case 0: 
            case 1: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isModuleOrientedLocation() {
        switch (this.ordinal()) {
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    static {
        LOCATIONS = new ConcurrentHashMap();
    }

    private static class LazyPatternHolder {
        static final Pattern MODULE_WORD_PATTERN = Pattern.compile("\\bMODULE\\b");

        private LazyPatternHolder() {
        }
    }
}

