/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.identity.model.Tag;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ListTagsRequest
extends BmcRequest<Void> {
    private String tagNamespaceId;
    private String page;
    private Integer limit;
    private Tag.LifecycleState lifecycleState;

    public String getTagNamespaceId() {
        return this.tagNamespaceId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Tag.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Builder toBuilder() {
        return new Builder().tagNamespaceId(this.tagNamespaceId).page(this.page).limit(this.limit).lifecycleState(this.lifecycleState);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",tagNamespaceId=").append(String.valueOf(this.tagNamespaceId));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListTagsRequest)) {
            return false;
        }
        ListTagsRequest other = (ListTagsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.tagNamespaceId, other.tagNamespaceId) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.tagNamespaceId == null ? 43 : this.tagNamespaceId.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListTagsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String tagNamespaceId = null;
        private String page = null;
        private Integer limit = null;
        private Tag.LifecycleState lifecycleState = null;

        public Builder tagNamespaceId(String tagNamespaceId) {
            this.tagNamespaceId = tagNamespaceId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder lifecycleState(Tag.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListTagsRequest o) {
            this.tagNamespaceId(o.getTagNamespaceId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.lifecycleState(o.getLifecycleState());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListTagsRequest build() {
            ListTagsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListTagsRequest buildWithoutInvocationCallback() {
            ListTagsRequest request = new ListTagsRequest();
            request.tagNamespaceId = this.tagNamespaceId;
            request.page = this.page;
            request.limit = this.limit;
            request.lifecycleState = this.lifecycleState;
            return request;
        }
    }
}

