/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui.querypen;

import ca.sqlpower.object.SPVariableHelper;
import ca.sqlpower.query.Container;
import ca.sqlpower.query.ContainerChildEvent;
import ca.sqlpower.query.ContainerChildListener;
import ca.sqlpower.query.Item;
import ca.sqlpower.swingui.querypen.CleanupPNode;
import ca.sqlpower.swingui.querypen.EditStyledTextListener;
import ca.sqlpower.swingui.querypen.EditablePStyledText;
import ca.sqlpower.swingui.querypen.QueryPen;
import ca.sqlpower.swingui.querypen.UnmodifiableItemPNode;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PDragSequenceEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPickPath;
import edu.umd.cs.piccolox.event.PNotification;
import edu.umd.cs.piccolox.event.PNotificationCenter;
import edu.umd.cs.piccolox.nodes.PClip;
import edu.umd.cs.piccolox.nodes.PStyledText;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import org.apache.log4j.Logger;

public class ContainerPane
extends PNode
implements CleanupPNode {
    private static Logger logger = Logger.getLogger(ContainerPane.class);
    private static final boolean MAC_OS_X = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    private static final ImageIcon CLOSE_ICON = new ImageIcon(ContainerPane.class.getResource("close-16.png"));
    private static final int BORDER_SIZE = 5;
    private static final int SEPARATOR_SIZE = 5;
    private static final float STROKE_SIZE = 2.0f;
    private final Container model;
    private PPath outerRect;
    private QueryPen queryPen;
    private PCanvas canvas;
    private PStyledText whereHeader;
    private PSwing swingCheckBox;
    private List<UnmodifiableItemPNode> containedItems;
    private List<PPath> separatorLines;
    private final Collection<PropertyChangeListener> queryChangeListeners;
    private EditStyledTextListener editingTextListener = new EditStyledTextListener(){
        private boolean editing = false;

        @Override
        public void editingStopping() {
            if (this.editing) {
                ContainerPane.this.createAliasName();
            }
            this.editing = false;
        }

        @Override
        public void editingStarting() {
            this.editing = true;
            if (ContainerPane.this.model.getAlias() != null && ContainerPane.this.model.getAlias().length() > 0) {
                ContainerPane.this.modelNameText.getEditorPane().setText(ContainerPane.this.model.getAlias());
                logger.debug((Object)("Setting editor text to " + ContainerPane.this.model.getAlias()));
            }
        }
    };
    private PropertyChangeListener guiItemChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            for (PropertyChangeListener l : ContainerPane.this.queryChangeListeners) {
                l.propertyChange(evt);
            }
        }
    };
    private PropertyChangeListener resizeOnEditChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ContainerPane.this.repositionWhereAndResize();
        }
    };
    private final PropertyChangeListener containerChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("position")) {
                ContainerPane.this.translate(ContainerPane.this.model.getPosition().getX() - ContainerPane.this.getGlobalBounds().getX(), ContainerPane.this.model.getPosition().getY() - ContainerPane.this.getGlobalBounds().getY());
            } else if (evt.getPropertyName().equals("alias")) {
                ContainerPane.this.setVisibleAliasText();
            }
            if (evt.getPropertyName().equals("alias")) {
                for (PropertyChangeListener l : ContainerPane.this.queryChangeListeners) {
                    l.propertyChange(evt);
                }
            }
        }
    };
    private final ContainerChildListener containerChildListener = new ContainerChildListener(){

        @Override
        public void containerChildAdded(ContainerChildEvent evt) {
            ContainerPane.this.addItem(evt.getChild());
            logger.debug((Object)("Added " + evt.getChild().getName() + " to the container pane."));
        }

        @Override
        public void containerChildRemoved(ContainerChildEvent evt) {
            ContainerPane.this.removeItem(evt.getChild());
        }
    };
    private EditablePStyledText modelNameText;
    private final PNode header;
    private PStyledText columnNameHeader;
    private PClip headerBackClip;
    private PPath headerBackground;
    private PNode whereBackground;
    private final PSwing closeButton;
    private final SPVariableHelper variablesHelper;

    private void createAliasName() {
        JEditorPane nameEditor = this.modelNameText.getEditorPane();
        String name = this.model.getName();
        if (nameEditor.getText() != null && nameEditor.getText().length() > 0 && !nameEditor.getText().equals(name)) {
            this.model.setAlias(nameEditor.getText());
        } else {
            logger.debug((Object)("item name is " + name));
            this.model.setAlias("");
        }
        this.setVisibleAliasText();
        logger.debug((Object)("editor has text " + nameEditor.getText() + " alias is " + this.model.getAlias()));
    }

    public ContainerPane(QueryPen pen, PCanvas canvas, Container newModel) {
        this(pen, canvas, newModel, null);
    }

    public ContainerPane(QueryPen pen, PCanvas canvas, Container newModel, SPVariableHelper variables) {
        this.model = newModel;
        this.variablesHelper = variables;
        logger.debug((Object)("Container alias is " + this.model.getAlias()));
        this.model.addPropertyChangeListener(this.containerChangeListener);
        this.model.addChildListener(this.containerChildListener);
        this.queryChangeListeners = new ArrayList<PropertyChangeListener>();
        this.queryPen = pen;
        this.canvas = canvas;
        this.containedItems = new ArrayList<UnmodifiableItemPNode>();
        this.separatorLines = new ArrayList<PPath>();
        logger.debug((Object)("Model name is " + this.model.getName()));
        this.modelNameText = new EditablePStyledText(this.model.getName(), pen, canvas);
        this.modelNameText.addEditStyledTextListener(this.editingTextListener);
        this.modelNameText.addPropertyChangeListener("bounds", this.resizeOnEditChangeListener);
        this.modelNameText.addInputEventListener((PInputEventListener)new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent event) {
                if (!ContainerPane.this.queryPen.getMultipleSelectEventHandler().isSelected(ContainerPane.this)) {
                    ContainerPane.this.queryPen.getMultipleSelectEventHandler().unselectAll();
                }
                ContainerPane.this.queryPen.getMultipleSelectEventHandler().select(ContainerPane.this);
            }
        });
        this.addChild((PNode)this.modelNameText);
        this.header = this.createColumnHeader();
        this.header.translate(0.0, this.modelNameText.getHeight() + 5.0);
        this.addChild(this.header);
        int yLoc = 2;
        for (Item item : this.model.getItems()) {
            UnmodifiableItemPNode newText = this.createTextLine(item);
            newText.translate(0.0, (this.modelNameText.getHeight() + 5.0) * (double)yLoc + 5.0);
            this.addChild(newText);
            this.containedItems.add(newText);
            ++yLoc;
        }
        this.repositionWhereClauses();
        PBounds fullBounds = this.getFullBounds();
        this.outerRect = PPath.createRoundRectangle((float)((float)fullBounds.x - 5.0f), (float)((float)fullBounds.y - 5.0f), (float)((float)fullBounds.width + 10.0f), (float)((float)fullBounds.height + 10.0f), (float)8.0f, (float)8.0f);
        this.outerRect.setStroke((Stroke)new BasicStroke(2.0f));
        this.headerBackground = PPath.createRoundRectangle((float)-5.0f, (float)-5.0f, (float)((float)this.outerRect.getWidth() - 1.0f), (float)((float)(this.modelNameText.getHeight() + 5.0) * 2.0f + 5.0f + 8.0f), (float)8.0f, (float)8.0f);
        this.headerBackground.setStrokePaint((Paint)new Color(0xFFFFFF, true));
        this.headerBackClip = new PClip();
        this.headerBackClip.addChild((PNode)this.headerBackground);
        float headerClipHeight = (float)(this.modelNameText.getHeight() + 5.0) * 2.0f + 10.0f;
        this.headerBackClip.setPathToRectangle((float)this.outerRect.getX(), (float)this.outerRect.getY(), (float)this.outerRect.getWidth(), headerClipHeight);
        this.headerBackClip.setStrokePaint((Paint)new Color(0xFFFFFF, true));
        this.whereBackground = new PNode();
        this.whereBackground.translate(this.outerRect.getX() + this.whereHeader.getFullBounds().getX() + 5.0, this.outerRect.getY() + (double)headerClipHeight);
        this.whereBackground.setWidth(this.outerRect.getWidth() - this.whereHeader.getFullBounds().getX() - 2.0 - 5.0 - 1.0);
        this.whereBackground.setHeight(this.outerRect.getHeight() - (double)headerClipHeight - 2.0 - 1.0);
        this.whereBackground.setPaint((Paint)QueryPen.WHERE_BACKGROUND_COLOUR);
        this.addChild(this.whereBackground);
        this.addChild((PNode)this.headerBackClip);
        this.addChild((PNode)this.outerRect);
        this.whereBackground.moveToBack();
        this.headerBackClip.moveToBack();
        this.outerRect.moveToBack();
        this.setBounds((Rectangle2D)this.outerRect.getBounds());
        this.translate(-this.getGlobalBounds().getX(), -this.getGlobalBounds().getY());
        this.translate(this.model.getPosition().getX(), this.model.getPosition().getY());
        this.closeButton = new PSwing((JComponent)new JLabel(CLOSE_ICON));
        this.addChild((PNode)this.closeButton);
        if (MAC_OS_X) {
            this.closeButton.translate((double)(-(5 + CLOSE_ICON.getIconWidth() / 2)), (double)(-(5 + CLOSE_ICON.getIconHeight() / 2)));
        } else {
            this.closeButton.translate(this.headerBackClip.getWidth() - 5.0 - (double)(CLOSE_ICON.getIconWidth() / 2), (double)(-(5 + CLOSE_ICON.getIconHeight() / 2)));
        }
        this.closeButton.addInputEventListener((PInputEventListener)new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent event) {
                ContainerPane.this.queryPen.deleteContainer(ContainerPane.this);
            }
        });
        this.closeButton.setTransparency(0.0f);
        this.addInputEventListener((PInputEventListener)new PDragSequenceEventHandler(){

            protected void endDrag(PInputEvent e) {
                super.endDrag(e);
                ContainerPane.this.model.setPosition(new Point2D.Double(ContainerPane.this.getGlobalBounds().getX(), ContainerPane.this.getGlobalBounds().getY()));
                logger.debug((Object)("Setting position " + ContainerPane.this.getGlobalBounds().getX() + ", " + ContainerPane.this.getGlobalBounds().getY()));
            }
        });
        this.setVisibleAliasText();
        PNotificationCenter.defaultCenter().addListener((Object)this, "setFocusAppearance", "SELECTION_CHANGED_NOTIFICATION", null);
        this.setFocusAppearance(new PNotification(null, null, null));
    }

    private UnmodifiableItemPNode createTextLine(Item item) {
        UnmodifiableItemPNode modelNameText = new UnmodifiableItemPNode(this.queryPen, this.canvas, item, this.variablesHelper);
        modelNameText.getItemText().addPropertyChangeListener("bounds", this.resizeOnEditChangeListener);
        modelNameText.getWherePStyledText().addPropertyChangeListener("bounds", this.resizeOnEditChangeListener);
        modelNameText.addQueryChangeListener(this.guiItemChangeListener);
        return modelNameText;
    }

    private PNode createColumnHeader() {
        PNode itemHeader = new PNode();
        final JCheckBox allCheckBox = new JCheckBox();
        allCheckBox.setOpaque(false);
        allCheckBox.addActionListener(new AbstractAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String editMessage = allCheckBox.isSelected() ? "Setting all columns in the table " + ContainerPane.this.getModel().getName() + " to be selected" : "Setting all columns in the table " + ContainerPane.this.getModel().getName() + " to be un-selected";
                    ContainerPane.this.queryPen.getModel().startCompoundEdit(editMessage);
                    for (UnmodifiableItemPNode itemNode : ContainerPane.this.containedItems) {
                        if (itemNode.isInSelect() == ((JCheckBox)e.getSource()).isSelected()) continue;
                        itemNode.setInSelected(((JCheckBox)e.getSource()).isSelected());
                    }
                }
                finally {
                    ContainerPane.this.queryPen.getModel().endCompoundEdit();
                }
            }
        });
        allCheckBox.setSelected(true);
        this.swingCheckBox = new PSwing((JComponent)allCheckBox);
        itemHeader.addChild((PNode)this.swingCheckBox);
        this.columnNameHeader = new EditablePStyledText("select all/none", this.queryPen, this.canvas);
        double textYTranslation = (this.swingCheckBox.getFullBounds().height - this.columnNameHeader.getFullBounds().height) / 2.0;
        this.columnNameHeader.translate(this.swingCheckBox.getFullBounds().width, textYTranslation);
        itemHeader.addChild((PNode)this.columnNameHeader);
        this.whereHeader = new EditablePStyledText("where:", this.queryPen, this.canvas);
        this.whereHeader.translate(0.0, textYTranslation);
        itemHeader.addChild((PNode)this.whereHeader);
        return itemHeader;
    }

    public Container getModel() {
        return this.model;
    }

    public String getModelTextName() {
        return this.model.getName();
    }

    public UnmodifiableItemPNode getItemPNode(Object item) {
        Item itemInModel = this.model.getItem(item);
        if (itemInModel == null) {
            logger.debug((Object)("Item " + item + " not in model."));
            return null;
        }
        for (UnmodifiableItemPNode itemNode : this.containedItems) {
            if (itemInModel.getItem() != itemNode.getItem().getItem()) continue;
            return itemNode;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fullPick(PPickPath pickPath) {
        int animationLength = 200;
        if (super.fullPick(pickPath)) {
            try {
                PNode picked = pickPath.getPickedNode();
                for (UnmodifiableItemPNode node : this.containedItems) {
                    if (!node.getAllNodes().contains(picked)) continue;
                    boolean bl = true;
                    return bl;
                }
                if (picked == this.swingCheckBox || picked == this.modelNameText || picked == this.closeButton) {
                    boolean bl = true;
                    return bl;
                }
                while (picked != this) {
                    pickPath.popTransform(picked.getTransformReference(false));
                    pickPath.popNode(picked);
                    picked = pickPath.getPickedNode();
                }
                boolean bl = true;
                return bl;
            }
            finally {
                if (this.closeButton.getTransparency() == 0.0f) {
                    this.closeButton.animateToTransparency(1.0f, 200L);
                }
            }
        }
        if (this.closeButton.getTransparency() == 1.0f) {
            this.closeButton.animateToTransparency(0.0f, 200L);
        }
        return false;
    }

    public void setFocusAppearance(PNotification notification) {
        boolean hasFocus = this.queryPen.getMultipleSelectEventHandler().getSelection().contains(this);
        if (hasFocus) {
            this.outerRect.setStrokePaint((Paint)QueryPen.SELECTED_CONTAINER_COLOUR);
            for (PPath line : this.separatorLines) {
                line.setStrokePaint((Paint)QueryPen.SELECTED_CONTAINER_COLOUR);
            }
            this.headerBackground.setPaint((Paint)QueryPen.SELECTED_CONTAINER_COLOUR);
            this.moveToFront();
        } else {
            this.outerRect.setStrokePaint((Paint)QueryPen.UNSELECTED_CONTAINER_COLOUR);
            for (PPath line : this.separatorLines) {
                line.setStrokePaint((Paint)QueryPen.UNSELECTED_CONTAINER_COLOUR);
            }
            this.headerBackground.setPaint((Paint)QueryPen.UNSELECTED_CONTAINER_GRADIENT_COLOUR);
        }
    }

    public void addQueryChangeListener(PropertyChangeListener l) {
        this.queryChangeListeners.add(l);
    }

    public void removeQueryChangeListener(PropertyChangeListener l) {
        this.queryChangeListeners.remove(l);
    }

    private double repositionWhereClauses() {
        double maxXPos = this.swingCheckBox.getFullBounds().width + 5.0 + this.columnNameHeader.getWidth() + 5.0;
        for (UnmodifiableItemPNode itemNode : this.containedItems) {
            maxXPos = Math.max(maxXPos, itemNode.getDistanceForWhere());
        }
        this.whereHeader.translate(maxXPos - this.whereHeader.getXOffset(), 0.0);
        for (UnmodifiableItemPNode itemNode : this.containedItems) {
            itemNode.positionWhere(maxXPos);
        }
        return maxXPos;
    }

    public List<UnmodifiableItemPNode> getContainedItems() {
        return Collections.unmodifiableList(this.containedItems);
    }

    private void addItem(Item item) {
        UnmodifiableItemPNode itemNode = this.createTextLine(item);
        itemNode.translate(0.0, (this.modelNameText.getHeight() + 5.0) * (double)(2 + this.containedItems.size()) + 5.0);
        this.addChild(itemNode);
        this.containedItems.add(itemNode);
        this.repositionWhereAndResize();
    }

    private void removeItem(Item item) {
        UnmodifiableItemPNode itemNode = this.getItemPNode(item.getItem());
        if (itemNode != null) {
            int containedItemsLocation = this.containedItems.indexOf(itemNode);
            this.removeChild(itemNode);
            this.containedItems.remove(itemNode);
            itemNode.getItemText().removePropertyChangeListener("bounds", this.resizeOnEditChangeListener);
            itemNode.getWherePStyledText().removePropertyChangeListener("bounds", this.resizeOnEditChangeListener);
            itemNode.removeQueryChangeListener(this.guiItemChangeListener);
            for (int i = containedItemsLocation; i < this.containedItems.size(); ++i) {
                this.containedItems.get(i).translate(0.0, -this.modelNameText.getHeight() - 5.0);
            }
            this.repositionWhereAndResize();
        }
    }

    private void repositionWhereAndResize() {
        double maxWhereXPos = this.repositionWhereClauses();
        if (this.outerRect != null) {
            double maxWidth = Math.max(this.header.getFullBounds().getWidth(), this.modelNameText.getFullBounds().getWidth());
            logger.debug((Object)("Header width is " + this.header.getFullBounds().getWidth() + " and the container name has width " + this.modelNameText.getFullBounds().getWidth()));
            for (UnmodifiableItemPNode node : this.containedItems) {
                maxWidth = Math.max(maxWidth, node.getFullBounds().getWidth());
            }
            logger.debug((Object)("Max width of the container pane is " + maxWidth));
            this.outerRect.setWidth(maxWidth += 10.0);
            for (PPath line : this.separatorLines) {
                line.setWidth(maxWidth);
            }
            int numStaticRows = 2;
            this.outerRect.setHeight((this.modelNameText.getHeight() + 5.0) * (double)(numStaticRows + this.containedItems.size()) + 15.0);
            this.headerBackground.setWidth(maxWidth);
            this.headerBackClip.setWidth(maxWidth);
            this.whereBackground.translate(maxWhereXPos - this.whereBackground.getXOffset(), 0.0);
            this.whereBackground.setWidth(this.outerRect.getWidth() - this.whereBackground.getFullBounds().getX() - 2.0 - 5.0 - 1.0);
            this.whereBackground.setHeight(this.outerRect.getHeight() - this.whereBackground.getFullBounds().getY() - 2.0 - 5.0 - 1.0);
            this.setBounds((Rectangle2D)this.outerRect.getBounds());
        }
    }

    private void setVisibleAliasText() {
        JEditorPane nameEditor = this.modelNameText.getEditorPane();
        if (this.model.getAlias() == null || this.model.getAlias().trim().length() <= 0) {
            nameEditor.setText(this.model.getName());
        } else {
            nameEditor.setText(this.model.getAlias() + " (" + this.model.getName() + ")");
        }
        this.modelNameText.syncWithDocument();
    }

    public void setContainerAlias(String newAlias) {
        this.modelNameText.getEditorPane().setText(newAlias);
        this.createAliasName();
    }

    @Override
    public void cleanup() {
        this.model.removePropertyChangeListener(this.containerChangeListener);
        this.model.removeChildListener(this.containerChildListener);
        for (Object o : this.getAllNodes()) {
            if (!(o instanceof CleanupPNode) || o == this) continue;
            ((CleanupPNode)o).cleanup();
        }
        PNotificationCenter.defaultCenter().removeListener((Object)this);
    }
}

