/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;

public class MatchCostQuery
extends Query {
    private final Query delegate;
    private final float matchCost;

    public MatchCostQuery(Query delegate, float matchCost) {
        this.delegate = delegate;
        this.matchCost = matchCost;
        assert (matchCost >= 0.0f);
    }

    public String toString(String field) {
        return this.delegate.toString(field);
    }

    public void visit(QueryVisitor visitor) {
        this.delegate.visit(visitor);
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && Objects.equals(this.delegate, ((MatchCostQuery)((Object)other)).delegate);
    }

    public int hashCode() {
        return 31 * this.classHash() + this.delegate.hashCode();
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query rewrite = this.delegate.rewrite(reader);
        if (this.delegate.equals((Object)rewrite)) {
            return this;
        }
        return new MatchCostQuery(rewrite, this.matchCost);
    }

    public Weight createWeight(final IndexSearcher searcher, final ScoreMode scoreMode, final float boost) throws IOException {
        return new Weight(this){
            final Weight weight;
            {
                super(arg0);
                this.weight = MatchCostQuery.this.delegate.createWeight(searcher, scoreMode, boost);
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return this.weight.isCacheable(ctx);
            }

            public Matches matches(LeafReaderContext context, int doc) throws IOException {
                return this.weight.matches(context, doc);
            }

            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                return this.weight.explain(context, doc);
            }

            public Scorer scorer(LeafReaderContext context) throws IOException {
                final Scorer scorer = this.weight.scorer(context);
                if (scorer == null) {
                    return null;
                }
                final TwoPhaseIterator tpi = scorer.twoPhaseIterator();
                if (tpi == null || tpi.matchCost() == MatchCostQuery.this.matchCost) {
                    return scorer;
                }
                return new Scorer(this.weight){

                    public TwoPhaseIterator twoPhaseIterator() {
                        return new TwoPhaseIterator(tpi.approximation()){

                            public boolean matches() throws IOException {
                                return tpi.matches();
                            }

                            public float matchCost() {
                                return MatchCostQuery.this.matchCost;
                            }
                        };
                    }

                    public DocIdSetIterator iterator() {
                        return scorer.iterator();
                    }

                    public float getMaxScore(int upTo) throws IOException {
                        return scorer.getMaxScore(upTo);
                    }

                    public float score() throws IOException {
                        return scorer.score();
                    }

                    public int docID() {
                        return scorer.docID();
                    }
                };
            }

            public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
                return this.weight.bulkScorer(context);
            }
        };
    }
}

