/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricsContext;
import org.apache.solr.security.HttpClientBuilderPlugin;
import org.apache.solr.update.UpdateShardHandlerConfig;
import org.apache.solr.util.stats.InstrumentedHttpListenerFactory;

final class HttpSolrClientProvider
implements AutoCloseable {
    static final String METRIC_SCOPE_NAME = "defaultHttpSolrClientProvider";
    private final Http2SolrClient httpSolrClient;
    private final InstrumentedHttpListenerFactory trackHttpSolrMetrics;

    HttpSolrClientProvider(UpdateShardHandlerConfig cfg, SolrMetricsContext parentContext) {
        this.trackHttpSolrMetrics = new InstrumentedHttpListenerFactory(this.getNameStrategy(cfg));
        this.initializeMetrics(parentContext);
        Http2SolrClient.Builder httpClientBuilder = new Http2SolrClient.Builder().withListenerFactory(List.of(this.trackHttpSolrMetrics));
        if (cfg != null) {
            ((Http2SolrClient.Builder)((Http2SolrClient.Builder)httpClientBuilder.withConnectionTimeout((long)cfg.getDistributedConnectionTimeout(), TimeUnit.MILLISECONDS)).withIdleTimeout((long)cfg.getDistributedSocketTimeout(), TimeUnit.MILLISECONDS)).withMaxConnectionsPerHost(cfg.getMaxUpdateConnectionsPerHost());
        }
        this.httpSolrClient = httpClientBuilder.build();
    }

    private InstrumentedHttpListenerFactory.NameStrategy getNameStrategy(UpdateShardHandlerConfig cfg) {
        String metricNameStrategy = cfg != null && cfg.getMetricNameStrategy() != null ? cfg.getMetricNameStrategy() : "queryLessURLAndMethod";
        return InstrumentedHttpListenerFactory.getNameStrategy(metricNameStrategy);
    }

    private void initializeMetrics(SolrMetricsContext parentContext) {
        SolrMetricsContext solrMetricsContext = parentContext.getChildContext(this);
        String expandedScope = SolrMetricManager.mkName(METRIC_SCOPE_NAME, SolrInfoBean.Category.HTTP.name());
        this.trackHttpSolrMetrics.initializeMetrics(solrMetricsContext, expandedScope);
    }

    Http2SolrClient getSolrClient() {
        return this.httpSolrClient;
    }

    void setSecurityBuilder(HttpClientBuilderPlugin builder) {
        builder.setup(this.httpSolrClient);
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((AutoCloseable)this.httpSolrClient);
        IOUtils.closeQuietly((AutoCloseable)this.trackHttpSolrMetrics);
    }
}

