/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import java.io.Serializable;
import kafka.utils.Logging;
import kafka.utils.PasswordEncoder;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZkMigrationClient;
import kafka.zk.migration.ZkAclMigrationClient;
import kafka.zk.migration.ZkConfigMigrationClient;
import kafka.zk.migration.ZkDelegationTokenMigrationClient;
import kafka.zk.migration.ZkTopicMigrationClient;
import org.apache.kafka.metadata.migration.MigrationClientAuthException;
import org.apache.kafka.metadata.migration.MigrationClientException;
import org.apache.zookeeper.KeeperException;
import scala.Function0;

public final class ZkMigrationClient$ {
    public static final ZkMigrationClient$ MODULE$ = new ZkMigrationClient$();
    private static final int MaxBatchSize = 100;

    public int MaxBatchSize() {
        return MaxBatchSize;
    }

    public ZkMigrationClient apply(KafkaZkClient zkClient, PasswordEncoder zkConfigEncoder) {
        ZkTopicMigrationClient topicClient = new ZkTopicMigrationClient(zkClient);
        ZkConfigMigrationClient configClient = new ZkConfigMigrationClient(zkClient, zkConfigEncoder);
        ZkAclMigrationClient aclClient = new ZkAclMigrationClient(zkClient);
        ZkDelegationTokenMigrationClient delegationTokenClient = new ZkDelegationTokenMigrationClient(zkClient);
        return new ZkMigrationClient(zkClient, topicClient, configClient, aclClient, delegationTokenClient);
    }

    public <T> T wrapZkException(Function0<T> fn) throws MigrationClientException {
        try {
            return (T)fn.apply();
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public <T> T logAndRethrow(Logging logger, String msg, Function0<T> fn) throws MigrationClientException {
        try {
            return (T)fn.apply();
        }
        catch (Throwable e) {
            logger.error((Function0<String>)(Function0 & Serializable)() -> msg, (Function0<Throwable>)(Function0 & Serializable)() -> e);
            throw e;
        }
    }

    private ZkMigrationClient$() {
    }
}

