/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * asin(-1.0) => -1.5707964
 * asin(-0.33333334) => -0.33983693
 * asin(0.33333334) => 0.33983693
 * asin(1.0) => 1.5707964
 */
#version 150

void main()
{
  float[distance(asin(-1.0), -1.5707964) <= 0.0015707964 ? 1 : -1] array0;
  float[distance(asin(-0.33333334), -0.33983693) <= 0.00033983693 ? 1 : -1] array1;
  float[distance(asin(0.33333334), 0.33983693) <= 0.00033983693 ? 1 : -1] array2;
  float[distance(asin(1.0), 1.5707964) <= 0.0015707964 ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
