/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.internal.function.simplify;

import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;

final class CompositionTaskArrayAdapter<T> {
    private final T[] array;

    public static <T> CompositionTaskArrayAdapter<T> of(T[] array) {
        return new CompositionTaskArrayAdapter<T>(array);
    }

    private CompositionTaskArrayAdapter(T[] array) {
        this.array = array;
    }

    public void visitSequentialPairs(BiConsumer<T, T> visitor) {
        if (this.array.length < 2) {
            return;
        }
        for (int i = 1; i < this.array.length; ++i) {
            visitor.accept(this.array[i - 1], this.array[i]);
        }
    }

    public int visitSequentialPairsAndSimplify(BinaryOperator<T> visitor) {
        if (this.array.length < 2) {
            return 0;
        }
        int simplificationCount = 0;
        for (int i = 1; i < this.array.length; ++i) {
            Object simplification;
            if (this.array[i - 1] == null || (simplification = visitor.apply(this.array[i - 1], this.array[i])) == null) continue;
            this.array[i - 1] = simplification;
            this.array[i] = null;
            ++simplificationCount;
        }
        return simplificationCount;
    }

    public T[] removeNulls(int nullCount) {
        T[] result = Arrays.copyOf(this.array, this.array.length - nullCount);
        int j = 0;
        for (int i = 0; i < this.array.length; ++i) {
            if (this.array[i] == null) continue;
            result[j++] = this.array[i];
        }
        return result;
    }
}

