/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath.transforms;

import com.google.common.collect.ImmutableList;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.vmplugin.v7.IndyInterface;
import org.gradle.api.file.RelativePath;
import org.gradle.internal.Pair;
import org.gradle.internal.classpath.CallInterceptionClosureInstrumentingClassVisitor;
import org.gradle.internal.classpath.ClassData;
import org.gradle.internal.classpath.ClasspathEntryVisitor;
import org.gradle.internal.classpath.Instrumented;
import org.gradle.internal.classpath.intercept.CallInterceptorRegistry;
import org.gradle.internal.classpath.intercept.JvmBytecodeInterceptorSet;
import org.gradle.internal.classpath.transforms.AdhocInterceptors;
import org.gradle.internal.classpath.transforms.ClassTransform;
import org.gradle.internal.classpath.transforms.CommonTypes;
import org.gradle.internal.classpath.transforms.InstrumentingBackwardsCompatibilityVisitor;
import org.gradle.internal.classpath.transforms.LambdaSerializationTransformer;
import org.gradle.internal.classpath.types.InstrumentationTypeRegistry;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.instrumentation.api.jvmbytecode.BridgeMethodBuilder;
import org.gradle.internal.instrumentation.api.jvmbytecode.JvmBytecodeCallInterceptor;
import org.gradle.internal.instrumentation.api.metadata.InstrumentationMetadata;
import org.gradle.internal.instrumentation.api.types.BytecodeInterceptorFilter;
import org.gradle.internal.instrumentation.api.types.FilterableBytecodeInterceptor;
import org.gradle.internal.instrumentation.reporting.listener.MethodInterceptionListener;
import org.gradle.internal.lazy.Lazy;
import org.gradle.model.internal.asm.MethodVisitorScope;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodNode;

public class InstrumentingClassTransform
implements ClassTransform {
    private static final int DECORATION_FORMAT = 38;
    private static final Type INSTRUMENTED_TYPE = Type.getType(Instrumented.class);
    private static final Type BYTECODE_INTERCEPTOR_FILTER_TYPE = Type.getType(BytecodeInterceptorFilter.class);
    private static final String RETURN_CALL_SITE_ARRAY = Type.getMethodDescriptor((Type)Type.getType(CallSiteArray.class), (Type[])new Type[0]);
    private static final String RETURN_VOID_FROM_CALL_SITE_ARRAY_BYTECODE_INTERCEPTOR = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(CallSiteArray.class), BYTECODE_INTERCEPTOR_FILTER_TYPE});
    private static final String GROOVY_INDY_INTERFACE_TYPE = Type.getType(org.codehaus.groovy.vmplugin.v8.IndyInterface.class).getInternalName();
    private static final String GROOVY_INDY_INTERFACE_V7_TYPE = Type.getType(IndyInterface.class).getInternalName();
    private static final String GROOVY_INDY_INTERFACE_BOOTSTRAP_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.getType(CallSite.class), (Type[])new Type[]{Type.getType(MethodHandles.Lookup.class), CommonTypes.STRING_TYPE, Type.getType(MethodType.class), CommonTypes.STRING_TYPE, Type.INT_TYPE});
    private static final String INSTRUMENTED_GROOVY_INDY_INTERFACE_BOOTSTRAP_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.getType(CallSite.class), (Type[])new Type[]{Type.getType(MethodHandles.Lookup.class), CommonTypes.STRING_TYPE, Type.getType(MethodType.class), CommonTypes.STRING_TYPE, Type.INT_TYPE, CommonTypes.STRING_TYPE});
    private static final String INSTRUMENTED_CALL_SITE_METHOD = "$instrumentedCallSiteArray";
    private static final String CREATE_CALL_SITE_ARRAY_METHOD = "$createCallSiteArray";
    private static final String LAMBDA_METAFACTORY_TYPE = Type.getType(LambdaMetafactory.class).getInternalName();
    private static final AdhocInterceptors ADHOC_INTERCEPTORS = new AdhocInterceptors();
    private final JvmBytecodeInterceptorSet externalInterceptors;
    private final MethodInterceptionListener methodInterceptionListener;
    private final InstrumentationMetadata instrumentationMetadata;

    @Override
    public void applyConfigurationTo(Hasher hasher) {
        hasher.putString((CharSequence)InstrumentingClassTransform.class.getSimpleName());
        hasher.putInt(38);
    }

    public InstrumentingClassTransform() {
        this(BytecodeInterceptorFilter.INSTRUMENTATION_ONLY, InstrumentationTypeRegistry.EMPTY);
    }

    public InstrumentingClassTransform(BytecodeInterceptorFilter interceptorFilter, InstrumentationTypeRegistry typeRegistry) {
        this(interceptorFilter, typeRegistry, MethodInterceptionListener.NO_OP);
    }

    public InstrumentingClassTransform(BytecodeInterceptorFilter interceptorFilter, InstrumentationTypeRegistry typeRegistry, MethodInterceptionListener methodInterceptionListener) {
        this.externalInterceptors = CallInterceptorRegistry.getJvmBytecodeInterceptors(interceptorFilter);
        this.methodInterceptionListener = methodInterceptionListener;
        this.instrumentationMetadata = (type, superType) -> typeRegistry.getSuperTypes(type).contains(superType);
    }

    private BytecodeInterceptorFilter interceptorFilter() {
        return this.externalInterceptors.getOriginalFilter();
    }

    private List<JvmBytecodeCallInterceptor> buildInterceptors(InstrumentationMetadata metadata) {
        return this.externalInterceptors.getInterceptors(metadata);
    }

    @Override
    public Pair<RelativePath, ClassVisitor> apply(ClasspathEntryVisitor.Entry entry, ClassVisitor visitor, ClassData classData) {
        ImmutableList interceptors = this.buildInterceptors(this.instrumentationMetadata);
        if (this.interceptorFilter().matches((FilterableBytecodeInterceptor)ADHOC_INTERCEPTORS)) {
            interceptors = ImmutableList.builderWithExpectedSize((int)(interceptors.size() + 1)).add((Object)ADHOC_INTERCEPTORS).addAll(interceptors).build();
        }
        return Pair.of((Object)entry.getPath(), (Object)((Object)new InstrumentingVisitor(new CallInterceptionClosureInstrumentingClassVisitor(new LambdaSerializationTransformer(new InstrumentingBackwardsCompatibilityVisitor(visitor)), this.interceptorFilter()), classData, (List<JvmBytecodeCallInterceptor>)interceptors, this.interceptorFilter(), this.methodInterceptionListener)));
    }

    private static class InstrumentingVisitor
    extends ClassVisitor {
        private final ClassData classData;
        private final List<JvmBytecodeCallInterceptor> interceptors;
        private final BytecodeInterceptorFilter interceptorFilter;
        private final Map<Handle, BridgeMethod> bridgeMethods = new LinkedHashMap<Handle, BridgeMethod>();
        private final MethodInterceptionListener methodInterceptionListener;
        private int nextBridgeMethodIndex;
        private boolean isInterface;
        private String className;
        private String sourceFileName;
        private boolean hasGroovyCallSites;

        public InstrumentingVisitor(ClassVisitor visitor, ClassData classData, List<JvmBytecodeCallInterceptor> interceptors, BytecodeInterceptorFilter interceptorFilter, MethodInterceptionListener methodInterceptionListener) {
            super(589824, visitor);
            this.classData = classData;
            this.interceptors = interceptors;
            this.interceptorFilter = interceptorFilter;
            this.methodInterceptionListener = methodInterceptionListener;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            this.isInterface = (access & 0x200) != 0;
            this.className = name;
        }

        public void visitSource(String source, String debug) {
            this.sourceFileName = source;
            super.visitSource(source, debug);
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            if (name.equals(InstrumentingClassTransform.CREATE_CALL_SITE_ARRAY_METHOD) && descriptor.equals(RETURN_CALL_SITE_ARRAY)) {
                this.hasGroovyCallSites = true;
            }
            MethodVisitor methodVisitor = super.visitMethod(access, name, descriptor, signature, exceptions);
            Lazy asMethodNode = Lazy.unsafe().of(() -> {
                Optional<MethodNode> methodNode = this.classData.readClassAsNode().methods.stream().filter(method -> Objects.equals(method.name, name) && Objects.equals(method.desc, descriptor) && Objects.equals(method.signature, signature)).findFirst();
                return methodNode.orElseThrow(() -> new IllegalStateException("could not find method " + name + " with descriptor " + descriptor));
            });
            return new InstrumentingMethodVisitor(this, methodVisitor, (Lazy<MethodNode>)asMethodNode);
        }

        public void visitEnd() {
            if (this.hasGroovyCallSites) {
                this.generateCallSiteFactoryMethod();
            }
            this.bridgeMethods.values().forEach(this::generateBridgeMethod);
            super.visitEnd();
        }

        private void generateCallSiteFactoryMethod() {
            new MethodVisitorScope(this.visitStaticPrivateMethod(InstrumentingClassTransform.INSTRUMENTED_CALL_SITE_METHOD, RETURN_CALL_SITE_ARRAY)){
                {
                    super(methodVisitor);
                    this._INVOKESTATIC(className, InstrumentingClassTransform.CREATE_CALL_SITE_ARRAY_METHOD, RETURN_CALL_SITE_ARRAY);
                    this._DUP();
                    this._GETSTATIC(BYTECODE_INTERCEPTOR_FILTER_TYPE, interceptorFilter.name(), BYTECODE_INTERCEPTOR_FILTER_TYPE.getDescriptor());
                    this._INVOKESTATIC(INSTRUMENTED_TYPE, "groovyCallSites", RETURN_VOID_FROM_CALL_SITE_ARRAY_BYTECODE_INTERCEPTOR);
                    this._ARETURN();
                    this.visitMaxs(2, 0);
                    this.visitEnd();
                }
            };
        }

        private void generateBridgeMethod(BridgeMethod bridgeMethod) {
            bridgeMethod.bridgeMethodBuilder.buildBridgeMethod(this.visitStaticPrivateMethod(bridgeMethod.bridgeMethodHandle.getName(), bridgeMethod.bridgeMethodHandle.getDesc()));
        }

        private MethodVisitor visitStaticPrivateMethod(String name, String descriptor) {
            return super.visitMethod(4106, name, descriptor, null, CommonTypes.NO_EXCEPTIONS);
        }

        @Nullable
        public BridgeMethod findBridgeMethodFor(Type factoryMethodType, Handle originalHandle) {
            Type exactReceiverType;
            Handle targetHandle = originalHandle;
            if (!(originalHandle.getTag() != 5 && originalHandle.getTag() != 9 || factoryMethodType.getArgumentCount() <= 0 || (exactReceiverType = factoryMethodType.getArgumentTypes()[0]).equals((Object)Type.getObjectType((String)originalHandle.getOwner())))) {
                targetHandle = new Handle(originalHandle.getTag(), exactReceiverType.getInternalName(), originalHandle.getName(), originalHandle.getDesc(), originalHandle.isInterface());
            }
            String targetOwner = targetHandle.getOwner();
            return this.bridgeMethods.computeIfAbsent(targetHandle, unused -> this.maybeBuildBridgeMethod(targetOwner, originalHandle));
        }

        @Nullable
        private BridgeMethod maybeBuildBridgeMethod(String targetOwner, Handle interceptedHandle) {
            for (JvmBytecodeCallInterceptor interceptor : this.interceptors) {
                BridgeMethodBuilder methodBuilder = interceptor.findBridgeMethodBuilder(this.className, interceptedHandle.getTag(), interceptedHandle.getOwner(), interceptedHandle.getName(), interceptedHandle.getDesc());
                if (methodBuilder == null) continue;
                if (!targetOwner.equals(interceptedHandle.getOwner())) {
                    methodBuilder = methodBuilder.withReceiverType(targetOwner);
                }
                return new BridgeMethod(this.makeBridgeMethodHandle(this.makeBridgeMethodName(interceptedHandle), methodBuilder.getBridgeMethodDescriptor()), methodBuilder);
            }
            return null;
        }

        private String makeBridgeMethodName(Handle originalHandle) {
            int index = this.nextBridgeMethodIndex++;
            String mangledOwner = originalHandle.getOwner().replace("/", "$");
            String safeName = originalHandle.getName().replace("<", "_").replace(">", "_");
            return "gradle$intercept$$" + mangledOwner + "$$" + safeName + "$" + index;
        }

        private Handle makeBridgeMethodHandle(String name, String desc) {
            return new Handle(6, this.className, name, desc, this.isInterface);
        }
    }

    private static class InstrumentingMethodVisitor
    extends MethodVisitorScope {
        private final InstrumentingVisitor owner;
        private final String className;
        private final Lazy<MethodNode> asNode;
        private final Collection<JvmBytecodeCallInterceptor> interceptors;
        private final BytecodeInterceptorFilter interceptorFilter;
        private final MethodInterceptionListener methodInterceptionListener;
        private final String sourceFileName;
        private int methodInsLineNumber;

        public InstrumentingMethodVisitor(InstrumentingVisitor owner, MethodVisitor methodVisitor, Lazy<MethodNode> asNode) {
            super(methodVisitor);
            this.owner = owner;
            this.className = owner.className;
            this.sourceFileName = owner.sourceFileName;
            this.asNode = asNode;
            this.interceptors = owner.interceptors;
            this.interceptorFilter = owner.interceptorFilter;
            this.methodInterceptionListener = owner.methodInterceptionListener;
        }

        public void visitLineNumber(int line, Label start) {
            this.methodInsLineNumber = line;
            super.visitLineNumber(line, start);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            if (opcode == 184 && this.visitINVOKESTATIC(owner, name, descriptor)) {
                return;
            }
            for (JvmBytecodeCallInterceptor interceptor : this.interceptors) {
                if (!interceptor.visitMethodInsn((MethodVisitorScope)this, this.className, opcode, owner, name, descriptor, isInterface, this.asNode)) continue;
                this.methodInterceptionListener.onInterceptedMethodInstruction(interceptor.getType(), this.sourceFileName, this.className, owner, name, descriptor, this.methodInsLineNumber);
                return;
            }
            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        }

        private boolean visitINVOKESTATIC(String owner, String name, String descriptor) {
            if (owner.equals(this.className) && name.equals(InstrumentingClassTransform.CREATE_CALL_SITE_ARRAY_METHOD) && descriptor.equals(RETURN_CALL_SITE_ARRAY)) {
                this._INVOKESTATIC(this.className, InstrumentingClassTransform.INSTRUMENTED_CALL_SITE_METHOD, RETURN_CALL_SITE_ARRAY);
                return true;
            }
            return false;
        }

        public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
            if (this.isGroovyIndyCallsite(bootstrapMethodHandle)) {
                Handle interceptor = new Handle(6, INSTRUMENTED_TYPE.getInternalName(), "bootstrap", INSTRUMENTED_GROOVY_INDY_INTERFACE_BOOTSTRAP_METHOD_DESCRIPTOR, false);
                bootstrapMethodArguments = ArrayUtils.add((Object[])bootstrapMethodArguments, (Object)this.interceptorFilter.name());
                super.visitInvokeDynamicInsn(name, descriptor, interceptor, bootstrapMethodArguments);
            } else if (this.isLambdaMetafactoryCallsite(bootstrapMethodHandle, bootstrapMethodArguments)) {
                bootstrapMethodArguments[1] = this.maybeInstrumentMethodReference(Type.getMethodType((String)descriptor), (Handle)bootstrapMethodArguments[1]);
                super.visitInvokeDynamicInsn(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
            } else {
                super.visitInvokeDynamicInsn(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
            }
        }

        private boolean isGroovyIndyCallsite(Handle bootstrapMethodHandle) {
            return (bootstrapMethodHandle.getOwner().equals(GROOVY_INDY_INTERFACE_TYPE) || bootstrapMethodHandle.getOwner().equals(GROOVY_INDY_INTERFACE_V7_TYPE)) && bootstrapMethodHandle.getName().equals("bootstrap") && bootstrapMethodHandle.getDesc().equals(GROOVY_INDY_INTERFACE_BOOTSTRAP_METHOD_DESCRIPTOR);
        }

        private boolean isLambdaMetafactoryCallsite(Handle bootstrapMethodHandle, Object[] bootstrapMethodArguments) {
            return bootstrapMethodHandle.getOwner().equals(LAMBDA_METAFACTORY_TYPE) && (bootstrapMethodHandle.getName().equals("metafactory") || bootstrapMethodHandle.getName().equals("altMetafactory")) && bootstrapMethodArguments.length >= 3 && bootstrapMethodArguments[1] instanceof Handle;
        }

        private Handle maybeInstrumentMethodReference(Type factoryMethodType, Handle handle) {
            BridgeMethod bridgeMethod = this.owner.findBridgeMethodFor(factoryMethodType, handle);
            if (bridgeMethod != null) {
                return bridgeMethod.bridgeMethodHandle;
            }
            return handle;
        }
    }

    private static class BridgeMethod {
        final Handle bridgeMethodHandle;
        final BridgeMethodBuilder bridgeMethodBuilder;

        private BridgeMethod(Handle bridgeMethodHandle, BridgeMethodBuilder bridgeMethodBuilder) {
            this.bridgeMethodHandle = bridgeMethodHandle;
            this.bridgeMethodBuilder = bridgeMethodBuilder;
        }
    }
}

