/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analyzer;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/analyzer/DiagnoseUnknownModuleInfoReporter;", "", "<init>", "()V", "report", "", "name", "", "infos", "", "Lorg/jetbrains/kotlin/analyzer/ModuleInfo;", "allModules", "", "errorInSdkResolver", "Lorg/jetbrains/kotlin/utils/KotlinExceptionWithAttachments;", "message", "errorInLibrariesResolver", "errorInModulesResolver", "errorInModulesResolverWithEmptyInfos", "errorInModulesResolverWithScriptDependencies", "errorInModulesResolverWithLibraryInfo", "errorInScriptDependenciesInfoResolver", "errorInScriptModuleInfoResolver", "errorInSpecialModuleInfoResolver", "otherError", "frontend"})
final class DiagnoseUnknownModuleInfoReporter {
    @NotNull
    public static final DiagnoseUnknownModuleInfoReporter INSTANCE = new DiagnoseUnknownModuleInfoReporter();

    private DiagnoseUnknownModuleInfoReporter() {
    }

    @NotNull
    public final Void report(@NotNull String name2, @NotNull List<? extends ModuleInfo> infos, @NotNull Collection<? extends ModuleInfo> allModules) {
        KotlinExceptionWithAttachments kotlinExceptionWithAttachments;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(infos, (String)"infos");
        Intrinsics.checkNotNullParameter(allModules, (String)"allModules");
        String message = name2 + " does not know how to resolve";
        if (StringsKt.contains$default((CharSequence)name2, (CharSequence)"sdk", (boolean)false, (int)2, null)) {
            kotlinExceptionWithAttachments = this.errorInSdkResolver(message);
        } else if (StringsKt.contains$default((CharSequence)name2, (CharSequence)"project libraries", (boolean)false, (int)2, null)) {
            kotlinExceptionWithAttachments = this.errorInLibrariesResolver(message);
        } else if (StringsKt.contains$default((CharSequence)name2, (CharSequence)"project source roots and libraries", (boolean)false, (int)2, null)) {
            if (infos.isEmpty()) {
                kotlinExceptionWithAttachments = this.errorInModulesResolverWithEmptyInfos(message);
            } else if (infos.size() == 1) {
                String infoAsString = CollectionsKt.single(infos).toString();
                kotlinExceptionWithAttachments = StringsKt.contains$default((CharSequence)infoAsString, (CharSequence)"ScriptDependencies", (boolean)false, (int)2, null) ? this.errorInModulesResolverWithScriptDependencies(message) : (StringsKt.contains$default((CharSequence)infoAsString, (CharSequence)"Library", (boolean)false, (int)2, null) ? this.errorInModulesResolverWithLibraryInfo(message) : this.errorInModulesResolver(message));
            } else {
                kotlinExceptionWithAttachments = this.errorInModulesResolver(message);
            }
        } else {
            kotlinExceptionWithAttachments = StringsKt.contains$default((CharSequence)name2, (CharSequence)"dependencies of scripts", (boolean)false, (int)2, null) ? this.errorInScriptDependenciesInfoResolver(message) : (StringsKt.contains$default((CharSequence)name2, (CharSequence)"completion/highlighting in ", (boolean)false, (int)2, null) ? (StringsKt.contains$default((CharSequence)name2, (CharSequence)"ScriptModuleInfo", (boolean)false, (int)2, null) ? this.errorInScriptModuleInfoResolver(message) : this.errorInSpecialModuleInfoResolver(message)) : this.otherError(message));
        }
        KotlinExceptionWithAttachments error = kotlinExceptionWithAttachments;
        throw error.withAttachment("infos.txt", infos).withAttachment("allModules.txt", allModules);
    }

    private final KotlinExceptionWithAttachments errorInSdkResolver(String message) {
        return new KotlinExceptionWithAttachments(message);
    }

    private final KotlinExceptionWithAttachments errorInLibrariesResolver(String message) {
        return new KotlinExceptionWithAttachments(message);
    }

    private final KotlinExceptionWithAttachments errorInModulesResolver(String message) {
        return new KotlinExceptionWithAttachments(message);
    }

    private final KotlinExceptionWithAttachments errorInModulesResolverWithEmptyInfos(String message) {
        return new KotlinExceptionWithAttachments(message);
    }

    private final KotlinExceptionWithAttachments errorInModulesResolverWithScriptDependencies(String message) {
        return new KotlinExceptionWithAttachments(message);
    }

    private final KotlinExceptionWithAttachments errorInModulesResolverWithLibraryInfo(String message) {
        return new KotlinExceptionWithAttachments(message);
    }

    private final KotlinExceptionWithAttachments errorInScriptDependenciesInfoResolver(String message) {
        return new KotlinExceptionWithAttachments(message);
    }

    private final KotlinExceptionWithAttachments errorInScriptModuleInfoResolver(String message) {
        return new KotlinExceptionWithAttachments(message);
    }

    private final KotlinExceptionWithAttachments errorInSpecialModuleInfoResolver(String message) {
        return new KotlinExceptionWithAttachments(message);
    }

    private final KotlinExceptionWithAttachments otherError(String message) {
        return new KotlinExceptionWithAttachments(message);
    }
}

