/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SystemErrErrorHandler
implements ErrorHandler {
    private Writer out;
    private boolean inError = false;

    public SystemErrErrorHandler() {
        try {
            this.out = new OutputStreamWriter((OutputStream)System.err, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private void emitMessage(SAXParseException e, String messageType) throws SAXException {
        try {
            String systemId = e.getSystemId();
            this.out.write(systemId == null ? "" : '\"' + systemId + '\"');
            this.out.write(":");
            this.out.write(Integer.toString(e.getLineNumber()));
            this.out.write(":");
            this.out.write(Integer.toString(e.getColumnNumber()));
            this.out.write(": ");
            this.out.write(messageType);
            this.out.write(": ");
            this.out.write(e.getMessage());
            this.out.write("\n");
            this.out.flush();
        }
        catch (IOException e1) {
            throw new SAXException(e1);
        }
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.emitMessage(e, "warning");
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.inError = true;
        this.emitMessage(e, "error");
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.inError = true;
        this.emitMessage(e, "fatal error");
    }

    public boolean isInError() {
        return this.inError;
    }

    public void reset() {
        this.inError = false;
    }
}

