/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.salvation.directiveValues;

import com.shapesecurity.salvation.Constants;
import com.shapesecurity.salvation.data.GUID;
import com.shapesecurity.salvation.data.Origin;
import com.shapesecurity.salvation.data.SchemeHostPortTriple;
import com.shapesecurity.salvation.data.URI;
import com.shapesecurity.salvation.directiveValues.AncestorSource;
import com.shapesecurity.salvation.directiveValues.SourceExpression;
import com.shapesecurity.salvation.interfaces.MatchesSource;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HostSource
implements SourceExpression,
AncestorSource,
MatchesSource {
    public static final HostSource WILDCARD = new HostSource(null, "*", -1, null);
    private static final int WILDCARD_HASHCODE = -1622262038;
    @Nullable
    private final String scheme;
    @Nonnull
    private final String host;
    private final int port;
    @Nullable
    private final String path;

    public boolean hasPath() {
        return this.path != null && !this.path.isEmpty();
    }

    public HostSource(@Nullable String scheme, @Nonnull String host, int port, @Nullable String path) {
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.path = path != null ? path.replaceAll(";", "%3B").replaceAll(",", "%2C") : null;
    }

    public boolean equals(@Nullable Object other) {
        if (other == null || !(other instanceof HostSource)) {
            return false;
        }
        HostSource otherPrime = (HostSource)other;
        if (this.isWildcard() && otherPrime.isWildcard()) {
            return true;
        }
        return Objects.equals(this.scheme != null ? this.scheme.toLowerCase() : null, otherPrime.scheme != null ? otherPrime.scheme.toLowerCase() : null) && Objects.equals(this.host != null ? this.host.toLowerCase() : null, otherPrime.host != null ? otherPrime.host.toLowerCase() : null) && this.port == otherPrime.port && Objects.equals(this.path, otherPrime.path);
    }

    public int hashCode() {
        int h = 0;
        if (this.scheme != null) {
            h ^= this.scheme.toLowerCase().hashCode() ^ 0xA303EFA3;
        }
        h ^= this.host.toLowerCase().hashCode() ^ 0xFB2290B2;
        h ^= this.port ^ 0xB54E99F3;
        if (this.path != null) {
            h ^= this.path.hashCode() ^ 0x13324C0E;
        }
        return h;
    }

    public boolean isWildcard() {
        return this.host.equals("*") && this.scheme == null && this.port == -1 && this.path == null;
    }

    public static boolean hostMatches(@Nonnull String hostA, @Nonnull String hostB) {
        if (hostA.startsWith("*")) {
            String remaining = hostA.substring(1);
            return hostB.toLowerCase().endsWith(remaining.toLowerCase());
        }
        if (!hostA.equalsIgnoreCase(hostB)) {
            return false;
        }
        Matcher IPv4Matcher = Constants.IPv4address.matcher(hostA);
        Matcher IPv6Matcher = Constants.IPv6addressWithOptionalBracket.matcher(hostA);
        Matcher IPv6LoopbackMatcher = Constants.IPV6loopback.matcher(hostA);
        return (!IPv4Matcher.find() || hostA.equals("127.0.0.1")) && !IPv6Matcher.find() && !IPv6LoopbackMatcher.find();
    }

    @Override
    public boolean matchesSource(@Nonnull Origin origin, @Nonnull GUID resource) {
        String originScheme = null;
        if (origin instanceof GUID) {
            originScheme = ((GUID)origin).scheme();
        }
        String resourceScheme = resource.scheme();
        if (origin instanceof GUID && originScheme != null && resourceScheme != null) {
            return originScheme.equalsIgnoreCase(resourceScheme);
        }
        return false;
    }

    @Override
    public boolean matchesSource(@Nonnull Origin origin, @Nonnull URI resource) {
        boolean thisUsesDefaultPort;
        if (origin instanceof GUID) {
            return this.isWildcard() && resource.isNetworkScheme();
        }
        if (!(origin instanceof SchemeHostPortTriple)) {
            return false;
        }
        SchemeHostPortTriple shpOrigin = (SchemeHostPortTriple)origin;
        if (this.isWildcard()) {
            return resource.isNetworkScheme() || shpOrigin.scheme.matches(resource.scheme);
        }
        boolean schemeMatches = this.scheme == null ? SchemeHostPortTriple.matchesSecureScheme(shpOrigin.scheme, resource.scheme) : SchemeHostPortTriple.matchesSecureScheme(this.scheme, resource.scheme);
        boolean hostMatches = HostSource.hostMatches(this.host, resource.host);
        boolean uriUsesDefaultPort = resource.port == -1 || SchemeHostPortTriple.defaultPortForProtocol(resource.scheme) == resource.port;
        boolean bl = thisUsesDefaultPort = this.scheme != null && (this.port == -1 || SchemeHostPortTriple.defaultPortForProtocol(this.scheme) == this.port);
        boolean portMatches = this.port == -200 || thisUsesDefaultPort && uriUsesDefaultPort || (this.port == -1 ? uriUsesDefaultPort : (resource.port == -1 ? thisUsesDefaultPort : this.port == resource.port));
        boolean pathMatches = HostSource.pathMatches(this.path, resource.path);
        return schemeMatches && hostMatches && portMatches && pathMatches;
    }

    public boolean matchesOnlyOrigin(@Nonnull SchemeHostPortTriple origin) {
        boolean thisUsesDefaultPort;
        boolean schemeMatches = this.scheme != null && this.scheme.equalsIgnoreCase(origin.scheme);
        boolean hostMatches = this.host.equalsIgnoreCase(origin.host);
        boolean originUsesDefaultPort = origin.port == -1 || SchemeHostPortTriple.defaultPortForProtocol(origin.scheme) == origin.port;
        boolean bl = thisUsesDefaultPort = this.scheme != null && (this.port == -1 || SchemeHostPortTriple.defaultPortForProtocol(this.scheme) == this.port);
        boolean portMatches = this.port == -1 ? originUsesDefaultPort : (origin.port == -1 ? thisUsesDefaultPort : this.port == origin.port);
        return schemeMatches && hostMatches && portMatches;
    }

    @Override
    @Nonnull
    public String show() {
        boolean isDefaultPort = this.port == -1 || this.scheme != null && this.port == SchemeHostPortTriple.defaultPortForProtocol(this.scheme);
        return (this.scheme == null ? "" : this.scheme + "://") + this.host + (isDefaultPort ? "" : ":" + (this.port == -200 ? "*" : Integer.valueOf(this.port))) + (this.path == null ? "" : this.path);
    }

    public static boolean pathMatches(@Nullable String pathA, @Nullable String pathB) {
        if (pathA == null || pathA.isEmpty()) {
            return true;
        }
        if (pathB == null || pathB.isEmpty()) {
            return false;
        }
        if (pathA.matches("/") && pathB.isEmpty()) {
            return true;
        }
        boolean exactMatch = !pathA.endsWith("/");
        List<String> pathListA = HostSource.splitBySpec(pathA, '/');
        List<String> pathListB = HostSource.splitBySpec(pathB, '/');
        if (pathListA.size() > pathListB.size()) {
            return false;
        }
        if (exactMatch && pathListA.size() != pathListB.size()) {
            return false;
        }
        if (!exactMatch) {
            pathListA.remove(pathListA.size() - 1);
        }
        Iterator<String> it1 = pathListA.iterator();
        Iterator<String> it2 = pathListB.iterator();
        while (it1.hasNext()) {
            String b;
            String a = HostSource.decodeString(it1.next());
            if (a.equals(b = HostSource.decodeString(it2.next()))) continue;
            return false;
        }
        return true;
    }

    public static String decodeString(@Nonnull String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }

    public static List<String> splitBySpec(@Nonnull String s, char delim) {
        int next;
        int off = 0;
        ArrayList<String> list = new ArrayList<String>();
        while ((next = s.indexOf(delim, off)) != -1) {
            list.add(s.substring(off, next));
            off = next + 1;
        }
        list.add(s.substring(off, s.length()));
        return list;
    }
}

