/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.util;

import com.projectlibre1.strings.Messages;
import com.projectlibre1.util.Environment;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class Alert {
    private static final String GRAPHIC_MANAGER = "com.projectlibre1.pm.graphic.frames.GraphicManager";

    public static void warn(Object object) {
        if (Alert.allowPopups()) {
            Alert.warn(object, Alert.getFrame());
        }
    }

    public static void warn(Object object, Component component) {
        System.out.println("warning message " + object);
        if (Alert.allowPopups()) {
            JOptionPane.showMessageDialog(component, object, Messages.getContextString("Title.ProjectLibreWarning"), 2);
        }
    }

    public static void error(Object object) {
        if (Alert.allowPopups()) {
            Alert.error(object, Alert.getFrame());
        }
    }

    public static void error(Object object, Component component) {
        System.out.println("error message " + object);
        if (Alert.allowPopups()) {
            JOptionPane.showMessageDialog(component, object, Messages.getContextString("Title.ProjectLibreError"), 0);
        }
    }

    public static int confirmYesNo(Object object) {
        if (!Alert.allowPopups()) {
            return 1;
        }
        return JOptionPane.showConfirmDialog(Alert.getFrame(), object, Messages.getContextString("Text.ApplicationTitle"), 0);
    }

    public static int confirm(Object object) {
        if (!Alert.allowPopups()) {
            return 1;
        }
        int n = JOptionPane.showConfirmDialog(Alert.getFrame(), object, Messages.getContextString("Text.ApplicationTitle"), 1);
        if (n == -1) {
            n = 2;
        }
        return n;
    }

    public static boolean okCancel(Object object) {
        if (!Alert.allowPopups()) {
            return true;
        }
        return 0 == JOptionPane.showConfirmDialog(Alert.getFrame(), object, Messages.getContextString("Text.ApplicationTitle"), 2);
    }

    public static String renameProject(String string, Set set, boolean bl) {
        try {
            return (String)Class.forName(GRAPHIC_MANAGER).getMethod("doRenameProjectDialog", String.class, Set.class, Boolean.TYPE).invoke(Alert.getGraphicManager(), string, set, bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Frame getFrame() {
        try {
            return (Frame)Class.forName(GRAPHIC_MANAGER).getMethod("getFrameInstance", null).invoke(null, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Object getGraphicManager() {
        try {
            return Class.forName(GRAPHIC_MANAGER).getMethod("getInstance", null).invoke(null, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static boolean allowPopups() {
        return Environment.isClientSide() && !Environment.isBatchMode();
    }

    public static Object getGraphicManagerMethod(String string) {
        try {
            return Class.forName(GRAPHIC_MANAGER).getMethod(string, null).invoke(null, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void setGraphicManagerMethod(String string, Object object) {
        try {
            Class.forName(GRAPHIC_MANAGER).getMethod(string, Object.class).invoke(null, object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void warnWithOnceOption(Object object, String string) {
        Alert.warnWithOnceOption(object, string, null);
    }

    public static void warnWithOnceOption(Object object, String string, Component component) {
        boolean bl = Preferences.userNodeForPackage(Alert.class).getBoolean(string, false);
        if (bl) {
            return;
        }
        JOptionPane jOptionPane = new JOptionPane(object);
        String string2 = Messages.getContextString("Text.ApplicationTitle");
        JDialog jDialog = jOptionPane.createDialog(component, string2);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        JCheckBox jCheckBox = new JCheckBox(Messages.getString("Text.doNotShowAgain"));
        jPanel.add(jCheckBox);
        jOptionPane.add(jPanel);
        Dimension dimension = jDialog.getSize();
        dimension.height += 40;
        jDialog.setSize(dimension);
        jDialog.setVisible(true);
        if (jCheckBox.isSelected()) {
            Preferences.userNodeForPackage(Alert.class).putBoolean(string, true);
        }
    }
}

