/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.voice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.audio.AudioSink;
import org.openhab.core.audio.AudioSource;
import org.openhab.core.voice.KSService;
import org.openhab.core.voice.STTService;
import org.openhab.core.voice.TTSService;
import org.openhab.core.voice.Voice;
import org.openhab.core.voice.text.HumanLanguageInterpreter;

@NonNullByDefault
public record DialogContext(@Nullable KSService ks, @Nullable String keyword, STTService stt, TTSService tts, @Nullable Voice voice, List<HumanLanguageInterpreter> hlis, AudioSource source, AudioSink sink, Locale locale, String dialogGroup, @Nullable String locationItem, @Nullable String listeningItem, @Nullable String listeningMelody) {

    public static class Builder {
        private @Nullable AudioSource source;
        private @Nullable AudioSink sink;
        private @Nullable KSService ks;
        private @Nullable STTService stt;
        private @Nullable TTSService tts;
        private @Nullable Voice voice;
        private List<HumanLanguageInterpreter> hlis = List.of();
        private String dialogGroup = "default";
        private @Nullable String locationItem;
        private @Nullable String listeningItem;
        private @Nullable String listeningMelody;
        private String keyword;
        private Locale locale;

        public Builder(String keyword, Locale locale) {
            this.keyword = keyword;
            this.locale = locale;
        }

        public Builder withSource(@Nullable AudioSource source) {
            this.source = source;
            return this;
        }

        public Builder withSink(@Nullable AudioSink sink) {
            this.sink = sink;
            return this;
        }

        public Builder withKS(@Nullable KSService service) {
            if (service != null) {
                this.ks = service;
            }
            return this;
        }

        public Builder withSTT(@Nullable STTService service) {
            if (service != null) {
                this.stt = service;
            }
            return this;
        }

        public Builder withTTS(@Nullable TTSService service) {
            if (service != null) {
                this.tts = service;
            }
            return this;
        }

        public Builder withHLI(@Nullable HumanLanguageInterpreter service) {
            if (service != null) {
                this.hlis = List.of(service);
            }
            return this;
        }

        public Builder withHLIs(Collection<HumanLanguageInterpreter> services) {
            return this.withHLIs((List<HumanLanguageInterpreter>)new ArrayList<HumanLanguageInterpreter>(services));
        }

        public Builder withHLIs(List<HumanLanguageInterpreter> services) {
            if (!services.isEmpty()) {
                this.hlis = services;
            }
            return this;
        }

        public Builder withKeyword(@Nullable String keyword) {
            if (keyword != null && !keyword.isBlank()) {
                this.keyword = keyword;
            }
            return this;
        }

        public Builder withVoice(@Nullable Voice voice) {
            if (voice != null) {
                this.voice = voice;
            }
            return this;
        }

        public Builder withDialogGroup(@Nullable String dialogGroup) {
            if (dialogGroup != null) {
                this.dialogGroup = dialogGroup;
            }
            return this;
        }

        public Builder withLocationItem(@Nullable String locationItem) {
            if (locationItem != null) {
                this.locationItem = locationItem;
            }
            return this;
        }

        public Builder withListeningItem(@Nullable String listeningItem) {
            if (listeningItem != null) {
                this.listeningItem = listeningItem;
            }
            return this;
        }

        public Builder withMelody(@Nullable String listeningMelody) {
            if (listeningMelody != null) {
                this.listeningMelody = listeningMelody;
            }
            return this;
        }

        public Builder withLocale(@Nullable Locale locale) {
            if (locale != null) {
                this.locale = locale;
            }
            return this;
        }

        public DialogContext build() throws IllegalStateException {
            KSService ksService = this.ks;
            STTService sttService = this.stt;
            TTSService ttsService = this.tts;
            List<HumanLanguageInterpreter> hliServices = this.hlis;
            AudioSource audioSource = this.source;
            AudioSink audioSink = this.sink;
            if (sttService == null || ttsService == null || hliServices.isEmpty() || audioSource == null || audioSink == null) {
                ArrayList<String> errors = new ArrayList<String>();
                if (sttService == null) {
                    errors.add("missing stt service");
                }
                if (ttsService == null) {
                    errors.add("missing tts service");
                }
                if (hliServices.isEmpty()) {
                    errors.add("missing interpreters");
                }
                if (audioSource == null) {
                    errors.add("missing audio source");
                }
                if (audioSink == null) {
                    errors.add("missing audio sink");
                }
                throw new IllegalStateException("Cannot build dialog context: " + String.join((CharSequence)", ", errors) + ".");
            }
            return new DialogContext(ksService, this.keyword, sttService, ttsService, this.voice, hliServices, audioSource, audioSink, this.locale, this.dialogGroup, this.locationItem, this.listeningItem, this.listeningMelody);
        }
    }
}

