/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.diff;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.errors.BinaryBlobException;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.IntList;
import org.eclipse.jgit.util.RawParseUtils;

public class RawText
extends Sequence {
    public static final RawText EMPTY_TEXT = new RawText(new byte[0]);
    private static final int FIRST_FEW_BYTES = 8192;
    private static final AtomicInteger BUFFER_SIZE = new AtomicInteger(8192);
    protected final byte[] content;
    protected final IntList lines;

    public RawText(byte[] input) {
        this(input, RawParseUtils.lineMap(input, 0, input.length));
    }

    public RawText(byte[] input, IntList lineMap) {
        this.content = input;
        this.lines = lineMap;
    }

    public RawText(File file) throws IOException {
        this(IO.readFully(file));
    }

    public byte[] getRawContent() {
        return this.content;
    }

    @Override
    public int size() {
        return this.lines.size() - 2;
    }

    public byte[] getContent() {
        return this.content;
    }

    public void writeLine(OutputStream out, int i) throws IOException {
        int start = this.getStart(i);
        int end = this.getEnd(i);
        if (this.content[end - 1] == 10) {
            --end;
        }
        out.write(this.content, start, end - start);
    }

    public boolean isMissingNewlineAtEnd() {
        int end = this.lines.get(this.lines.size() - 1);
        if (end == 0) {
            return true;
        }
        return this.content[end - 1] != 10;
    }

    public String getString(int i) {
        return this.getString(i, i + 1, true);
    }

    public ByteBuffer getRawString(int i) {
        int s = this.getStart(i);
        int e = this.getEnd(i);
        if (e > 0 && this.content[e - 1] == 10) {
            --e;
        }
        return ByteBuffer.wrap(this.content, s, e - s);
    }

    public String getString(int begin, int end, boolean dropLF) {
        if (begin == end) {
            return "";
        }
        int s = this.getStart(begin);
        int e = this.getEnd(end - 1);
        if (dropLF && this.content[e - 1] == 10) {
            --e;
        }
        return this.decode(s, e);
    }

    protected String decode(int start, int end) {
        return RawParseUtils.decode(this.content, start, end);
    }

    private int getStart(int i) {
        return this.lines.get(i + 1);
    }

    private int getEnd(int i) {
        return this.lines.get(i + 2);
    }

    public static int getBufferSize() {
        return BUFFER_SIZE.get();
    }

    public static int setBufferSize(int bufferSize) {
        int newSize = Math.max(8192, bufferSize);
        return BUFFER_SIZE.updateAndGet(curr -> newSize);
    }

    public static boolean isBinary(InputStream raw) throws IOException {
        byte[] buffer = new byte[RawText.getBufferSize() + 1];
        int cnt = 0;
        while (cnt < buffer.length) {
            int n = raw.read(buffer, cnt, buffer.length - cnt);
            if (n == -1) break;
            cnt += n;
        }
        return RawText.isBinary(buffer, cnt, cnt < buffer.length);
    }

    public static boolean isBinary(byte[] raw) {
        return RawText.isBinary(raw, raw.length);
    }

    public static boolean isBinary(byte[] raw, int length) {
        return RawText.isBinary(raw, length, false);
    }

    public static boolean isBinary(byte[] raw, int length, boolean complete) {
        int maxLength = RawText.getBufferSize();
        boolean isComplete = complete;
        if (length > maxLength) {
            length = maxLength;
            isComplete = false;
        }
        byte last = 120;
        int ptr = 0;
        while (ptr < length) {
            byte curr = raw[ptr];
            if (RawText.isBinary(curr, last)) {
                return true;
            }
            last = curr;
            ++ptr;
        }
        if (isComplete) {
            return last == 13;
        }
        return false;
    }

    public static boolean isBinary(byte curr, byte prev) {
        return curr == 0 || curr != 10 && prev == 13 || prev == 0;
    }

    public static boolean isCrLfText(byte[] raw) {
        return RawText.isCrLfText(raw, raw.length);
    }

    public static boolean isCrLfText(InputStream raw) throws IOException {
        byte[] buffer = new byte[RawText.getBufferSize()];
        int cnt = 0;
        while (cnt < buffer.length) {
            int n = raw.read(buffer, cnt, buffer.length - cnt);
            if (n == -1) break;
            cnt += n;
        }
        return RawText.isCrLfText(buffer, cnt);
    }

    public static boolean isCrLfText(byte[] raw, int length) {
        return RawText.isCrLfText(raw, length, false);
    }

    public static boolean isCrLfText(byte[] raw, int length, boolean complete) {
        boolean has_crlf = false;
        byte last = 120;
        int ptr = 0;
        while (ptr < length) {
            byte curr = raw[ptr];
            if (RawText.isBinary(curr, last)) {
                return false;
            }
            if (curr == 10 && last == 13) {
                has_crlf = true;
            }
            last = curr;
            ++ptr;
        }
        if (last == 13 && complete) {
            return false;
        }
        return has_crlf;
    }

    public String getLineDelimiter() {
        if (this.size() == 0) {
            return null;
        }
        int e = this.getEnd(0);
        if (this.content[e - 1] != 10) {
            return null;
        }
        if (this.content.length > 1 && e > 1 && this.content[e - 2] == 13) {
            return "\r\n";
        }
        return "\n";
    }

    public static RawText load(ObjectLoader ldr, int threshold) throws IOException, BinaryBlobException {
        long sz = ldr.getSize();
        if (sz > (long)threshold) {
            throw new BinaryBlobException();
        }
        int bufferSize = RawText.getBufferSize();
        if (sz <= (long)bufferSize) {
            byte[] data = ldr.getCachedBytes(bufferSize);
            if (RawText.isBinary(data, data.length, true)) {
                throw new BinaryBlobException();
            }
            return new RawText(data);
        }
        byte[] head = new byte[bufferSize];
        Throwable throwable = null;
        Object var7_8 = null;
        try (ObjectStream stream = ldr.openStream();){
            byte[] data;
            int off = 0;
            int left = head.length;
            byte last = 120;
            while (left > 0) {
                int n = stream.read(head, off, left);
                if (n < 0) {
                    throw new EOFException();
                }
                left -= n;
                while (n > 0) {
                    byte curr = head[off];
                    if (RawText.isBinary(curr, last)) {
                        throw new BinaryBlobException();
                    }
                    last = curr;
                    ++off;
                    --n;
                }
            }
            try {
                data = new byte[(int)sz];
            }
            catch (OutOfMemoryError e) {
                throw new LargeObjectException.OutOfMemory(e);
            }
            System.arraycopy(head, 0, data, 0, head.length);
            IO.readFully(stream, data, off, (int)(sz - (long)off));
            return new RawText(data, RawParseUtils.lineMapOrBinary(data, 0, (int)sz));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

