/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible.filters;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.visible.filters.VcsLogTextFilterWithMatches;
import com.intellij.vcs.log.visible.filters.VcsLogTextFiltersKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\f\u001a\u00020\u0005H\u0016J\b\u0010\r\u001a\u00020\u0007H\u0016J\b\u0010\u000e\u001a\u00020\u0007H\u0016J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u0013H\u0002J\b\u0010\u0016\u001a\u00020\u0005H\u0017J\u0013\u0010\u0017\u001a\u00020\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/vcs/log/visible/filters/VcsLogMultiplePatternsTextFilter;", "Lcom/intellij/vcs/log/VcsLogDetailsFilter;", "Lcom/intellij/vcs/log/visible/filters/VcsLogTextFilterWithMatches;", "patterns", "", "", "isMatchCase", "", "<init>", "(Ljava/util/List;Z)V", "getPatterns", "()Ljava/util/List;", "getText", "isRegex", "matchesCase", "matches", "message", "matchingRanges", "", "Lcom/intellij/openapi/util/TextRange;", "findNextMatch", "previousRange", "toString", "equals", "other", "", "hashCode", "", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nVcsLogTextFilters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogTextFilters.kt\ncom/intellij/vcs/log/visible/filters/VcsLogMultiplePatternsTextFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1761#2,3:106\n*S KotlinDebug\n*F\n+ 1 VcsLogTextFilters.kt\ncom/intellij/vcs/log/visible/filters/VcsLogMultiplePatternsTextFilter\n*L\n62#1:106,3\n*E\n"})
public final class VcsLogMultiplePatternsTextFilter
implements VcsLogDetailsFilter,
VcsLogTextFilterWithMatches {
    @NotNull
    private final List<String> patterns;
    private final boolean isMatchCase;

    public VcsLogMultiplePatternsTextFilter(@NotNull List<String> patterns, boolean isMatchCase) {
        Intrinsics.checkNotNullParameter(patterns, (String)"patterns");
        this.patterns = patterns;
        this.isMatchCase = isMatchCase;
    }

    @NotNull
    public final List<String> getPatterns() {
        return this.patterns;
    }

    @NotNull
    public String getText() {
        return this.patterns.size() == 1 ? (String)CollectionsKt.single(this.patterns) : CollectionsKt.joinToString$default((Iterable)this.patterns, (CharSequence)"|", null, null, (int)0, null, VcsLogMultiplePatternsTextFilter::getText$lambda$0, (int)30, null);
    }

    public boolean isRegex() {
        return this.patterns.size() > 1;
    }

    public boolean matchesCase() {
        return this.isMatchCase;
    }

    @Override
    public boolean matches(@NotNull String message) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Iterable $this$any$iv = this.patterns;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.contains((CharSequence)message, (CharSequence)it, (!this.isMatchCase ? 1 : 0) != 0)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public Iterable<TextRange> matchingRanges(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return SequencesKt.asIterable((Sequence)SequencesKt.generateSequence(() -> VcsLogMultiplePatternsTextFilter.matchingRanges$lambda$2(this, message), arg_0 -> VcsLogMultiplePatternsTextFilter.matchingRanges$lambda$3(this, message, arg_0)));
    }

    private final TextRange findNextMatch(String message, TextRange previousRange) {
        TextRange textRange = previousRange;
        int startIndex = textRange != null ? textRange.getEndOffset() : 0;
        TextRange match = null;
        Iterator<String> iterator = this.patterns.iterator();
        while (iterator.hasNext()) {
            String pattern;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            int patternIndex = StringsKt.indexOf((CharSequence)message, (String)pattern, (int)startIndex, (!this.isMatchCase ? 1 : 0) != 0);
            if (patternIndex < 0 || match != null && patternIndex > match.getStartOffset()) continue;
            match = new TextRange(patternIndex, patternIndex + pattern.length());
        }
        return match;
    }

    @NonNls
    @NotNull
    public String toString() {
        return "containing at least one of the " + CollectionsKt.joinToString$default((Iterable)this.patterns, (CharSequence)", ", null, null, (int)0, null, VcsLogMultiplePatternsTextFilter::toString$lambda$4, (int)30, null) + " " + VcsLogTextFiltersKt.caseSensitiveText(this);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.vcs.log.visible.filters.VcsLogMultiplePatternsTextFilter");
        VcsLogMultiplePatternsTextFilter cfr_ignored_0 = (VcsLogMultiplePatternsTextFilter)other;
        return Comparing.haveEqualElements((Collection)this.patterns, (Collection)((VcsLogMultiplePatternsTextFilter)other).patterns) && this.isMatchCase == ((VcsLogMultiplePatternsTextFilter)other).isMatchCase;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{Comparing.unorderedHashcode((Collection)this.patterns), this.isMatchCase};
        return Objects.hash(objectArray);
    }

    private static final CharSequence getText$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = Pattern.quote(it);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"quote(...)");
        return string;
    }

    private static final TextRange matchingRanges$lambda$2(VcsLogMultiplePatternsTextFilter this$0, String $message) {
        return this$0.findNextMatch($message, null);
    }

    private static final TextRange matchingRanges$lambda$3(VcsLogMultiplePatternsTextFilter this$0, String $message, TextRange previousRange) {
        Intrinsics.checkNotNullParameter((Object)previousRange, (String)"previousRange");
        return this$0.findNextMatch($message, previousRange);
    }

    private static final CharSequence toString$lambda$4(String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return "'" + s + "'";
    }
}

